{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2005 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2005 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

{ ActiveX / OLE 2 Interface Unit }

unit Borland.Vcl.ActiveX platform;

{$WEAKPACKAGEUNIT}

interface

uses System.Runtime.InteropServices, System.Text,
  Messages, Windows;

{ Do not WEAKPACKAGE this unit.
  This unit requires startup code to initialize constants. }

const

{ from WTYPES.H }
  MEMCTX_TASK      = 1;
  MEMCTX_SHARED    = 2;
  MEMCTX_MACSYSTEM = 3;
  MEMCTX_UNKNOWN   = -1;
  MEMCTX_SAME      = -2;

  ROTFLAGS_REGISTRATIONKEEPSALIVE = 1;
  ROTFLAGS_ALLOWANYCLIENT         = 2;

  CLSCTX_INPROC_SERVER     = 1;
  CLSCTX_INPROC_HANDLER    = 2;
  CLSCTX_LOCAL_SERVER      = 4;
  CLSCTX_INPROC_SERVER16   = 8;
  CLSCTX_REMOTE_SERVER     = $10;
  CLSCTX_INPROC_HANDLER16  = $20;
  CLSCTX_INPROC_SERVERX86  = $40;
  CLSCTX_INPROC_HANDLERX86 = $80;

{ from OBJBASE }
  CLSCTX_ALL    = CLSCTX_INPROC_SERVER or CLSCTX_INPROC_HANDLER or
      CLSCTX_LOCAL_SERVER;
  CLSCTX_INPROC = CLSCTX_INPROC_SERVER or CLSCTX_INPROC_HANDLER;
  CLSCTX_SERVER = CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER;

  COM_RIGHTS_EXECUTE = 1;

{ from WTYPES.H }
  MSHLFLAGS_NORMAL      = 0;
  MSHLFLAGS_TABLESTRONG = 1;
  MSHLFLAGS_TABLEWEAK   = 2;
  MSHLFLAGS_NOPING      = 4;

  MSHCTX_LOCAL            = 0;
  MSHCTX_NOSHAREDMEM      = 1;
  MSHCTX_DIFFERENTMACHINE = 2;
  MSHCTX_INPROC           = 3;

  DVASPECT_CONTENT   = 1;
  DVASPECT_THUMBNAIL = 2;
  DVASPECT_ICON      = 4;
  DVASPECT_DOCPRINT  = 8;

  STGC_DEFAULT                            = 0;
  STGC_OVERWRITE                          = 1;
  STGC_ONLYIFCURRENT                      = 2;
  STGC_DANGEROUSLYCOMMITMERELYTODISKCACHE = 4;

  STGMOVE_MOVE        = 0;
  STGMOVE_COPY        = 1;
  STGMOVE_SHALLOWCOPY = 2;

  STATFLAG_DEFAULT = 0;
  STATFLAG_NONAME  = 1;

{ from OBJIDL.H }
  BIND_MAYBOTHERUSER     = 1;
  BIND_JUSTTESTEXISTENCE = 2;

  MKSYS_NONE             = 0;
  MKSYS_GENERICCOMPOSITE = 1;
  MKSYS_FILEMONIKER      = 2;
  MKSYS_ANTIMONIKER      = 3;
  MKSYS_ITEMMONIKER      = 4;
  MKSYS_POINTERMONIKER   = 5;

  MKRREDUCE_ONE         = 3 shl 16;
  MKRREDUCE_TOUSER      = 2 shl 16;
  MKRREDUCE_THROUGHUSER = 1 shl 16;
  MKRREDUCE_ALL         = 0;

  STGTY_STORAGE   = 1;
  STGTY_STREAM    = 2;
  STGTY_LOCKBYTES = 3;
  STGTY_PROPERTY  = 4;

  STREAM_SEEK_SET = 0;
  STREAM_SEEK_CUR = 1;
  STREAM_SEEK_END = 2;

  LOCK_WRITE     = 1;
  LOCK_EXCLUSIVE = 2;
  LOCK_ONLYONCE  = 4;

  ADVF_NODATA            = 1;
  ADVF_PRIMEFIRST        = 2;
  ADVF_ONLYONCE          = 4;
  ADVF_DATAONSTOP        = 64;
  ADVFCACHE_NOHANDLER    = 8;
  ADVFCACHE_FORCEBUILTIN = 16;
  ADVFCACHE_ONSAVE       = 32;

  TYMED_HGLOBAL  = 1;
  TYMED_FILE     = 2;
  TYMED_ISTREAM  = 4;
  TYMED_ISTORAGE = 8;
  TYMED_GDI      = 16;
  TYMED_MFPICT   = 32;
  TYMED_ENHMF    = 64;
  TYMED_NULL     = 0;

  DATADIR_GET = 1;
  DATADIR_SET = 2;

  CALLTYPE_TOPLEVEL             = 1;
  CALLTYPE_NESTED               = 2;
  CALLTYPE_ASYNC                = 3;
  CALLTYPE_TOPLEVEL_CALLPENDING = 4;
  CALLTYPE_ASYNC_CALLPENDING    = 5;

  SERVERCALL_ISHANDLED  = 0;
  SERVERCALL_REJECTED   = 1;
  SERVERCALL_RETRYLATER = 2;

  PENDINGTYPE_TOPLEVEL = 1;
  PENDINGTYPE_NESTED   = 2;

  PENDINGMSG_CANCELCALL     = 0;
  PENDINGMSG_WAITNOPROCESS  = 1;
  PENDINGMSG_WAITDEFPROCESS = 2;

  PROPSETFLAG_DEFAULT   = 0;
  PROPSETFLAG_NONSIMPLE = 1;
  PROPSETFLAG_ANSI      = 2;

{ from OBJBASE.H }
  REGCLS_SINGLEUSE      = 0;
  REGCLS_MULTIPLEUSE    = 1;
  REGCLS_MULTI_SEPARATE = 2;
  REGCLS_SUSPENDED      = 4;

  MARSHALINTERFACE_MIN = 500;

  CWCSTORAGENAME = 32;

  STGM_DIRECT           = $00000000;
  STGM_TRANSACTED       = $00010000;
  STGM_SIMPLE           = $08000000;

  STGM_READ             = $00000000;
  STGM_WRITE            = $00000001;
  STGM_READWRITE        = $00000002;

  STGM_SHARE_DENY_NONE  = $00000040;
  STGM_SHARE_DENY_READ  = $00000030;
  STGM_SHARE_DENY_WRITE = $00000020;
  STGM_SHARE_EXCLUSIVE  = $00000010;

  STGM_PRIORITY         = $00040000;
  STGM_DELETEONRELEASE  = $04000000;
  STGM_NOSCRATCH        = $00100000;

  STGM_CREATE           = $00001000;
  STGM_CONVERT          = $00020000;
  STGM_FAILIFTHERE      = $00000000;

  FADF_AUTO      = $0001;  { array is allocated on the stack }
  FADF_STATIC    = $0002;  { array is staticly allocated }
  FADF_EMBEDDED  = $0004;  { array is embedded in a structure }
  FADF_FIXEDSIZE = $0010;  { array may not be resized or reallocated }
  FADF_BSTR      = $0100;  { an array of BSTRs }
  FADF_UNKNOWN   = $0200;  { an array of IUnknown }
  FADF_DISPATCH  = $0400;  { an array of IDispatch }
  FADF_VARIANT   = $0800;  { an array of VARIANTs }
  FADF_RESERVED  = $F0E8;  { bits reserved for future use }

{ from WTYPES.H }
{ VARENUM usage key,

    [V] - may appear in a VARIANT
    [T] - may appear in a TYPEDESC
    [P] - may appear in an OLE property set
    [S] - may appear in a Safe Array }

  VT_EMPTY           = 0;   { [V]   [P]  nothing                     }
  VT_NULL            = 1;   { [V]        SQL style Null              }
  VT_I2              = 2;   { [V][T][P]  2 byte signed int           }
  VT_I4              = 3;   { [V][T][P]  4 byte signed int           }
  VT_R4              = 4;   { [V][T][P]  4 byte real                 }
  VT_R8              = 5;   { [V][T][P]  8 byte real                 }
  VT_CY              = 6;   { [V][T][P]  currency                    }
  VT_DATE            = 7;   { [V][T][P]  date                        }
  VT_BSTR            = 8;   { [V][T][P]  binary string               }
  VT_DISPATCH        = 9;   { [V][T]     IDispatch FAR*              }
  VT_ERROR           = 10;  { [V][T]     SCODE                       }
  VT_BOOL            = 11;  { [V][T][P]  True=-1, False=0            }
  VT_VARIANT         = 12;  { [V][T][P]  VARIANT FAR*                }
  VT_UNKNOWN         = 13;  { [V][T]     IUnknown FAR*               }
  VT_DECIMAL         = 14;  { [V][T]   [S]  16 byte fixed point      }

  VT_I1              = 16;  {    [T]     signed char                 }
  VT_UI1             = 17;  {    [T]     unsigned char               }
  VT_UI2             = 18;  {    [T]     unsigned short              }
  VT_UI4             = 19;  {    [T]     unsigned long               }
  VT_I8              = 20;  {    [T][P]  signed 64-bit int           }
  VT_UI8             = 21;  {    [T]     unsigned 64-bit int         }
  VT_INT             = 22;  {    [T]     signed machine int          }
  VT_UINT            = 23;  {    [T]     unsigned machine int        }
  VT_VOID            = 24;  {    [T]     C style void                }
  VT_HRESULT         = 25;  {    [T]                                 }
  VT_PTR             = 26;  {    [T]     pointer type                }
  VT_SAFEARRAY       = 27;  {    [T]     (use VT_ARRAY in VARIANT)   }
  VT_CARRAY          = 28;  {    [T]     C style array               }
  VT_USERDEFINED     = 29;  {    [T]     user defined type          }
  VT_LPSTR           = 30;  {    [T][P]  null terminated string      }
  VT_LPWSTR          = 31;  {    [T][P]  wide null terminated string }

  VT_FILETIME        = 64;  {       [P]  FILETIME                    }
  VT_BLOB            = 65;  {       [P]  Length prefixed bytes       }
  VT_STREAM          = 66;  {       [P]  Name of the stream follows  }
  VT_STORAGE         = 67;  {       [P]  Name of the storage follows }
  VT_STREAMED_OBJECT = 68;  {       [P]  Stream contains an object   }
  VT_STORED_OBJECT   = 69;  {       [P]  Storage contains an object  }
  VT_BLOB_OBJECT     = 70;  {       [P]  Blob contains an object     }
  VT_CF              = 71;  {       [P]  Clipboard format            }
  VT_CLSID           = 72;  {       [P]  A Class ID                  }

  VT_VECTOR        = $1000; {       [P]  simple counted array        }
  VT_ARRAY         = $2000; { [V]        SAFEARRAY*                  }
  VT_BYREF         = $4000; { [V]                                    }
  VT_RESERVED      = $8000;
  VT_ILLEGAL       = $ffff;
  VT_ILLEGALMASKED = $0fff;
  VT_TYPEMASK      = $0fff;

type
  PROPID = ULONG;
  TPropID = PROPID;

{ from OAIDL.H }

const
  TKIND_ENUM      = 0;
  TKIND_RECORD    = 1;
  TKIND_MODULE    = 2;
  TKIND_INTERFACE = 3;
  TKIND_DISPATCH  = 4;
  TKIND_COCLASS   = 5;
  TKIND_ALIAS     = 6;
  TKIND_UNION     = 7;
  TKIND_MAX       = 8;

  CC_SAFECALL    = 0;
  CC_CDECL       = 1;
  CC_PASCAL      = 2;
  CC_MACPASCAL   = 3;
  CC_STDCALL     = 4;
  CC_FPFASTCALL  = 5;
  CC_SYSCALL     = 6;
  CC_MPWCDECL    = 7;
  CC_MPWPASCAL   = 8;
  CC_MAX         = 9;

  FUNC_VIRTUAL     = 0;
  FUNC_PUREVIRTUAL = 1;
  FUNC_NONVIRTUAL  = 2;
  FUNC_STATIC      = 3;
  FUNC_DISPATCH    = 4;

  INVOKE_FUNC           = 1;
  INVOKE_PROPERTYGET    = 2;
  INVOKE_PROPERTYPUT    = 4;
  INVOKE_PROPERTYPUTREF = 8;

  VAR_PERINSTANCE = 0;
  VAR_STATIC      = 1;
  VAR_CONST       = 2;
  VAR_DISPATCH    = 3;

  IMPLTYPEFLAG_FDEFAULT        = 1;
  IMPLTYPEFLAG_FSOURCE         = 2;
  IMPLTYPEFLAG_FRESTRICTED     = 4;
  IMPLTYPEFLAG_FDEFAULTVTABLE    = 8;

  TYPEFLAG_FAPPOBJECT     = $0001;
  TYPEFLAG_FCANCREATE     = $0002;
  TYPEFLAG_FLICENSED      = $0004;
  TYPEFLAG_FPREDECLID     = $0008;
  TYPEFLAG_FHIDDEN        = $0010;
  TYPEFLAG_FCONTROL       = $0020;
  TYPEFLAG_FDUAL          = $0040;
  TYPEFLAG_FNONEXTENSIBLE = $0080;
  TYPEFLAG_FOLEAUTOMATION = $0100;
  TYPEFLAG_FRESTRICTED    = $0200;
  TYPEFLAG_FAGGREGATABLE  = $0400;
  TYPEFLAG_FREPLACEABLE   = $0800;
  TYPEFLAG_FDISPATCHABLE  = $1000;
  TYPEFLAG_FREVERSEBIND   = $2000;

  FUNCFLAG_FRESTRICTED       = $0001;
  FUNCFLAG_FSOURCE           = $0002;
  FUNCFLAG_FBINDABLE         = $0004;
  FUNCFLAG_FREQUESTEDIT      = $0008;
  FUNCFLAG_FDISPLAYBIND      = $0010;
  FUNCFLAG_FDEFAULTBIND      = $0020;
  FUNCFLAG_FHIDDEN           = $0040;
  FUNCFLAG_FUSESGETLASTERROR = $0080;
  FUNCFLAG_FDEFAULTCOLLELEM  = $0100;
  FUNCFLAG_FUIDEFAULT        = $0200;
  FUNCFLAG_FNONBROWSABLE          = $0400;
  FUNCFLAG_FREPLACEABLE      = $0800;
  FUNCFLAG_FIMMEDIATEBIND         = $1000;

  VARFLAG_FREADONLY        = $0001;
  VARFLAG_FSOURCE          = $0002;
  VARFLAG_FBINDABLE        = $0004;
  VARFLAG_FREQUESTEDIT     = $0008;
  VARFLAG_FDISPLAYBIND     = $0010;
  VARFLAG_FDEFAULTBIND     = $0020;
  VARFLAG_FHIDDEN          = $0040;
  VARFLAG_FRESTRICTED      = $0080;
  VARFLAG_FDEFAULTCOLLELEM      = $0100;
  VARFLAG_FUIDEFAULT          = $0200;
  VARFLAG_FNONBROWSABLE    = $0400;
  VARFLAG_FREPLACEABLE     = $0800;
  VARFLAG_FIMMEDIATEBIND        = $1000;

  DISPID_VALUE       = 0;
  DISPID_UNKNOWN     = -1;
  DISPID_STARTENUM   = DISPID_UNKNOWN;
  DISPID_PROPERTYPUT = -3;
  DISPID_NEWENUM     = -4;
  DISPID_EVALUATE    = -5;
  DISPID_CONSTRUCTOR = -6;
  DISPID_DESTRUCTOR  = -7;
  DISPID_COLLECT     = -8;
  DISPID_WINDOWOBJECT  = -5500;
  DISPID_LOCATIONOBJECT = -5506;
  DISPID_HISTORYOBJECT = -5507;
  DISPID_NAVIGATOROBJECT = -5508;
  DISPID_SECURITYCTX = -5511;
  DISPID_AMBIENT_DLCONTROL = -5512;
  DISPID_AMBIENT_USERAGENT = -5513;
  DISPID_SECURITYDOMAIN = -5514;


  DESCKIND_NONE = 0;
  DESCKIND_FUNCDESC = 1;
  DESCKIND_VARDESC = 2;
  DESCKIND_TYPECOMP = 3;
  DESCKIND_IMPLICITAPPOBJ = 4;
  DESCKIND_MAX = 5;

  SYS_WIN16 = 0;
  SYS_WIN32 = 1;
  SYS_MAC   = 2;

  LIBFLAG_FRESTRICTED   = 1;
  LIBFLAG_FCONTROL      = 2;
  LIBFLAG_FHIDDEN       = 4;
  LIBFLAG_FHASDISKIMAGE = 8;

{ from OLEAUTO.H }
  STDOLE_MAJORVERNUM = 1;
  STDOLE_MINORVERNUM = 0;
  STDOLE_LCID = 0;

  VARIANT_NOVALUEPROP = 1;

  VAR_TIMEVALUEONLY = 1;
  VAR_DATEVALUEONLY = 2;

  MEMBERID_NIL = DISPID_UNKNOWN;
  ID_DEFAULTINST = -2;

  DISPATCH_METHOD         = $1;
  DISPATCH_PROPERTYGET    = $2;
  DISPATCH_PROPERTYPUT    = $4;
  DISPATCH_PROPERTYPUTREF = $8;
  DISPATCH_CONSTRUCT      = $4000;

{ from OAIDL.H }
  IDLFLAG_NONE    = 0;
  IDLFLAG_FIN     = 1;
  IDLFLAG_FOUT    = 2;
  IDLFLAG_FLCID   = 4;
  IDLFLAG_FRETVAL = 8;

  PARAMFLAG_NONE          = $00;
  PARAMFLAG_FIN           = $01;
  PARAMFLAG_FOUT          = $02;
  PARAMFLAG_FLCID         = $04;
  PARAMFLAG_FRETVAL       = $08;
  PARAMFLAG_FOPT          = $10;
  PARAMFLAG_FHASDEFAULT   = $20;

{ from OLE2.H }
  OLEIVERB_PRIMARY          = 0;
  OLEIVERB_SHOW             = -1;
  OLEIVERB_OPEN             = -2;
  OLEIVERB_HIDE             = -3;
  OLEIVERB_UIACTIVATE       = -4;
  OLEIVERB_INPLACEACTIVATE  = -5;
  OLEIVERB_DISCARDUNDOSTATE = -6;

  EMBDHLP_INPROC_HANDLER = $00000000;
  EMBDHLP_INPROC_SERVER  = $00000001;
  EMBDHLP_CREATENOW      = $00000000;
  EMBDHLP_DELAYCREATE    = $00010000;

  OLECREATE_LEAVERUNNING = $00000001;

{ from OLEIDL.H }

type
  BORDERWIDTHS = TRect;
  TBorderWidths = BORDERWIDTHS;

const
  UPDFCACHE_NODATACACHE = 1;
  UPDFCACHE_ONSAVECACHE = 2;
  UPDFCACHE_ONSTOPCACHE = 4;
  UPDFCACHE_NORMALCACHE = 8;
  UPDFCACHE_IFBLANK     = $10;
  UPDFCACHE_ONLYIFBLANK = DWORD($80000000);

  UPDFCACHE_IFBLANKORONSAVECACHE = UPDFCACHE_IFBLANK or UPDFCACHE_ONSAVECACHE;
  UPDFCACHE_ALL                  = not UPDFCACHE_ONLYIFBLANK;
  UPDFCACHE_ALLBUTNODATACACHE    = UPDFCACHE_ALL and not UPDFCACHE_NODATACACHE;

  DISCARDCACHE_SAVEIFDIRTY = 0;
  DISCARDCACHE_NOSAVE      = 1;

  OLEGETMONIKER_ONLYIFTHERE = 1;
  OLEGETMONIKER_FORCEASSIGN = 2;
  OLEGETMONIKER_UNASSIGN    = 3;
  OLEGETMONIKER_TEMPFORUSER = 4;

  OLEWHICHMK_CONTAINER = 1;
  OLEWHICHMK_OBJREL    = 2;
  OLEWHICHMK_OBJFULL   = 3;

  USERCLASSTYPE_FULL    = 1;
  USERCLASSTYPE_SHORT   = 2;
  USERCLASSTYPE_APPNAME = 3;

  OLEMISC_RECOMPOSEONRESIZE            = 1;
  OLEMISC_ONLYICONIC                   = 2;
  OLEMISC_INSERTNOTREPLACE             = 4;
  OLEMISC_STATIC                       = 8;
  OLEMISC_CANTLINKINSIDE                    = $10;
  OLEMISC_CANLINKBYOLE1                = $20;
  OLEMISC_ISLINKOBJECT                 = $40;
  OLEMISC_INSIDEOUT                       = $80;
  OLEMISC_ACTIVATEWHENVISIBLE            = $100;
  OLEMISC_RENDERINGISDEVICEINDEPENDENT  = $200;
  OLEMISC_INVISIBLEATRUNTIME             = $400;
  OLEMISC_ALWAYSRUN                       = $800;
  OLEMISC_ACTSLIKEBUTTON                    = $1000;
  OLEMISC_ACTSLIKELABEL                = $2000;
  OLEMISC_NOUIACTIVATE                 = $4000;
  OLEMISC_ALIGNABLE                       = $8000;
  OLEMISC_SIMPLEFRAME                  = $10000;
  OLEMISC_SETCLIENTSITEFIRST           = $20000;
  OLEMISC_IMEMODE                            = $40000;
  OLEMISC_IGNOREACTIVATEWHENVISIBLE    = $80000;
  OLEMISC_WANTSTOMENUMERGE             = $100000;
  OLEMISC_SUPPORTSMULTILEVELUNDO              = $200000;

  OLECLOSE_SAVEIFDIRTY = 0;
  OLECLOSE_NOSAVE      = 1;
  OLECLOSE_PROMPTSAVE  = 2;

  OLERENDER_NONE   = 0;
  OLERENDER_DRAW   = 1;
  OLERENDER_FORMAT = 2;
  OLERENDER_ASIS   = 3;

  OLEUPDATE_ALWAYS = 1;
  OLEUPDATE_ONCALL = 3;

  OLELINKBIND_EVENIFCLASSDIFF = 1;

  BINDSPEED_INDEFINITE = 1;
  BINDSPEED_MODERATE   = 2;
  BINDSPEED_IMMEDIATE  = 3;

  OLECONTF_EMBEDDINGS    = 1;
  OLECONTF_LINKS         = 2;
  OLECONTF_OTHERS        = 4;
  OLECONTF_ONLYUSER      = 8;
  OLECONTF_ONLYIFRUNNING = 16;

  DROPEFFECT_NONE   = 0;
  DROPEFFECT_COPY   = 1;
  DROPEFFECT_MOVE   = 2;
  DROPEFFECT_LINK   = 4;
  DROPEFFECT_SCROLL = DWORD($80000000);

  MK_ALT = $20;

  DD_DEFSCROLLINSET    = 11;
  DD_DEFSCROLLDELAY    = 50;
  DD_DEFSCROLLINTERVAL = 50;
  DD_DEFDRAGDELAY      = 200;
  DD_DEFDRAGMINDIST    = 2;

  OLEVERBATTRIB_NEVERDIRTIES    = 1;
  OLEVERBATTRIB_ONCONTAINERMENU = 2;

{ from OLECTL.H}
{ OLE control status codes }

  CTL_E_ILLEGALFUNCTIONCALL       = HRESULT($800A0000) + 5;
  CTL_E_OVERFLOW                  = HRESULT($800A0000) + 6;
  CTL_E_OUTOFMEMORY               = HRESULT($800A0000) + 7;
  CTL_E_DIVISIONBYZERO            = HRESULT($800A0000) + 11;
  CTL_E_OUTOFSTRINGSPACE          = HRESULT($800A0000) + 14;
  CTL_E_OUTOFSTACKSPACE           = HRESULT($800A0000) + 28;
  CTL_E_BADFILENAMEORNUMBER       = HRESULT($800A0000) + 52;
  CTL_E_FILENOTFOUND              = HRESULT($800A0000) + 53;
  CTL_E_BADFILEMODE               = HRESULT($800A0000) + 54;
  CTL_E_FILEALREADYOPEN           = HRESULT($800A0000) + 55;
  CTL_E_DEVICEIOERROR             = HRESULT($800A0000) + 57;
  CTL_E_FILEALREADYEXISTS         = HRESULT($800A0000) + 58;
  CTL_E_BADRECORDLENGTH           = HRESULT($800A0000) + 59;
  CTL_E_DISKFULL                  = HRESULT($800A0000) + 61;
  CTL_E_BADRECORDNUMBER           = HRESULT($800A0000) + 63;
  CTL_E_BADFILENAME               = HRESULT($800A0000) + 64;
  CTL_E_TOOMANYFILES              = HRESULT($800A0000) + 67;
  CTL_E_DEVICEUNAVAILABLE         = HRESULT($800A0000) + 68;
  CTL_E_PERMISSIONDENIED          = HRESULT($800A0000) + 70;
  CTL_E_DISKNOTREADY              = HRESULT($800A0000) + 71;
  CTL_E_PATHFILEACCESSERROR       = HRESULT($800A0000) + 75;
  CTL_E_PATHNOTFOUND              = HRESULT($800A0000) + 76;
  CTL_E_INVALIDPATTERNSTRING      = HRESULT($800A0000) + 93;
  CTL_E_INVALIDUSEOFNULL          = HRESULT($800A0000) + 94;
  CTL_E_INVALIDFILEFORMAT         = HRESULT($800A0000) + 321;
  CTL_E_INVALIDPROPERTYVALUE      = HRESULT($800A0000) + 380;
  CTL_E_INVALIDPROPERTYARRAYINDEX = HRESULT($800A0000) + 381;
  CTL_E_SETNOTSUPPORTEDATRUNTIME  = HRESULT($800A0000) + 382;
  CTL_E_SETNOTSUPPORTED           = HRESULT($800A0000) + 383;
  CTL_E_NEEDPROPERTYARRAYINDEX    = HRESULT($800A0000) + 385;
  CTL_E_SETNOTPERMITTED           = HRESULT($800A0000) + 387;
  CTL_E_GETNOTSUPPORTEDATRUNTIME  = HRESULT($800A0000) + 393;
  CTL_E_GETNOTSUPPORTED           = HRESULT($800A0000) + 394;
  CTL_E_PROPERTYNOTFOUND          = HRESULT($800A0000) + 422;
  CTL_E_INVALIDCLIPBOARDFORMAT    = HRESULT($800A0000) + 460;
  CTL_E_INVALIDPICTURE            = HRESULT($800A0000) + 481;
  CTL_E_PRINTERERROR              = HRESULT($800A0000) + 482;
  CTL_E_CANTSAVEFILETOTEMP        = HRESULT($800A0000) + 735;
  CTL_E_SEARCHTEXTNOTFOUND        = HRESULT($800A0000) + 744;
  CTL_E_REPLACEMENTSTOOLONG       = HRESULT($800A0000) + 746;

  CTL_E_CUSTOM_FIRST = HRESULT($800A0000) + 600;

{ IClassFactory2 status codes }

  CLASS_E_NOTLICENSED = CLASSFACTORY_E_FIRST + 2;

{ IConnectionPoint status codes }

  CONNECT_E_FIRST = HRESULT($80040200);
  CONNECT_E_LAST  = HRESULT($8004020F);
  CONNECT_S_FIRST = $00040200;
  CONNECT_S_LAST  = $0004020F;

  CONNECT_E_NOCONNECTION  = CONNECT_E_FIRST + 0;
  CONNECT_E_ADVISELIMIT   = CONNECT_E_FIRST + 1;
  CONNECT_E_CANNOTCONNECT = CONNECT_E_FIRST + 2;
  CONNECT_E_OVERRIDDEN    = CONNECT_E_FIRST + 3;

{ DllRegisterServer/DllUnregisterServer status codes }

  SELFREG_E_FIRST = HRESULT($80040200);
  SELFREG_E_LAST  = HRESULT($80040200);
  SELFREG_S_FIRST = $00040200;
  SELFREG_S_LAST  = $00040200;

  SELFREG_E_TYPELIB = SELFREG_E_FIRST + 0;
  SELFREG_E_CLASS   = SELFREG_E_FIRST + 1;

{ IPerPropertyBrowsing status codes }

  PERPROP_E_FIRST = HRESULT($80040200);
  PERPROP_E_LAST  = HRESULT($8004020F);
  PERPROP_S_FIRST = $00040200;
  PERPROP_S_LAST  = $0004020F;

  PERPROP_E_NOPAGEAVAILABLE = PERPROP_E_FIRST + 0;

{ Additional OLEIVERB constants }

  OLEIVERB_PROPERTIES = -7;

{ Additional variant type tags for property sets }

  VT_STREAMED_PROPSET = 73;  { Stream contains a property set }
  VT_STORED_PROPSET   = 74;  { Storage contains a property set }
  VT_BLOB_PROPSET     = 75;  { Blob contains a property set }
  VT_VERBOSE_ENUM     = 76;  { Enum value with text string }

{ Variant type tags that are just aliases for others }

  VT_COLOR          = VT_I4;
  VT_XPOS_PIXELS    = VT_I4;
  VT_YPOS_PIXELS    = VT_I4;
  VT_XSIZE_PIXELS   = VT_I4;
  VT_YSIZE_PIXELS   = VT_I4;
  VT_XPOS_HIMETRIC  = VT_I4;
  VT_YPOS_HIMETRIC  = VT_I4;
  VT_XSIZE_HIMETRIC = VT_I4;
  VT_YSIZE_HIMETRIC = VT_I4;
  VT_TRISTATE       = VT_I2;
  VT_OPTEXCLUSIVE   = VT_BOOL;
  VT_FONT           = VT_DISPATCH;
  VT_PICTURE        = VT_DISPATCH;
  VT_HANDLE         = VT_I4;

{ Reflected window message IDs }

  OCM__BASE = WM_USER + $1C00;

  OCM_COMMAND           = OCM__BASE + WM_COMMAND;
  OCM_CTLCOLORBTN       = OCM__BASE + WM_CTLCOLORBTN;
  OCM_CTLCOLOREDIT      = OCM__BASE + WM_CTLCOLOREDIT;
  OCM_CTLCOLORDLG       = OCM__BASE + WM_CTLCOLORDLG;
  OCM_CTLCOLORLISTBOX   = OCM__BASE + WM_CTLCOLORLISTBOX;
  OCM_CTLCOLORMSGBOX    = OCM__BASE + WM_CTLCOLORMSGBOX;
  OCM_CTLCOLORSCROLLBAR = OCM__BASE + WM_CTLCOLORSCROLLBAR;
  OCM_CTLCOLORSTATIC    = OCM__BASE + WM_CTLCOLORSTATIC;
  OCM_DRAWITEM          = OCM__BASE + WM_DRAWITEM;
  OCM_MEASUREITEM       = OCM__BASE + WM_MEASUREITEM;
  OCM_DELETEITEM        = OCM__BASE + WM_DELETEITEM;
  OCM_VKEYTOITEM        = OCM__BASE + WM_VKEYTOITEM;
  OCM_CHARTOITEM        = OCM__BASE + WM_CHARTOITEM;
  OCM_COMPAREITEM       = OCM__BASE + WM_COMPAREITEM;
  OCM_HSCROLL           = OCM__BASE + WM_HSCROLL;
  OCM_VSCROLL           = OCM__BASE + WM_VSCROLL;
  OCM_PARENTNOTIFY      = OCM__BASE + WM_PARENTNOTIFY;
  OCM_NOTIFY            = OCM__BASE + WM_NOTIFY;

{ from OCIDL.H }
{ TControlInfo.dwFlags masks }

  CTRLINFO_EATS_RETURN = 1;  { Control doesn't send Return to container }
  CTRLINFO_EATS_ESCAPE = 2;  { Control doesn't send Escape to container }

{ IOleControlSite.TransformCoords flags }

  XFORMCOORDS_POSITION            = 1;
  XFORMCOORDS_SIZE                = 2;
  XFORMCOORDS_HIMETRICTOCONTAINER = 4;
  XFORMCOORDS_CONTAINERTOHIMETRIC = 8;

{ IPropertyPageSite.OnStatusChange flags }

  PROPPAGESTATUS_DIRTY    = 1;  { Values in page have changed }
  PROPPAGESTATUS_VALIDATE = 2;  { Appropriate time to validate/apply }
  PROPPAGESTATUS_CLEAN    = 4;

{ Picture attributes }

  PICTURE_SCALABLE    = 1;
  PICTURE_TRANSPARENT = 2;

{ from OLECTL.H }
{ TPictDesc.picType values }

  PICTYPE_UNINITIALIZED = -1;
  PICTYPE_NONE          = 0;
  PICTYPE_BITMAP        = 1;
  PICTYPE_METAFILE      = 2;
  PICTYPE_ICON          = 3;
  PICTYPE_ENHMETAFILE   = 4;

{ Standard dispatch ID constants }

  DISPID_AUTOSIZE      = -500;
  DISPID_BACKCOLOR     = -501;
  DISPID_BACKSTYLE     = -502;
  DISPID_BORDERCOLOR   = -503;
  DISPID_BORDERSTYLE   = -504;
  DISPID_BORDERWIDTH   = -505;
  DISPID_DRAWMODE      = -507;
  DISPID_DRAWSTYLE     = -508;
  DISPID_DRAWWIDTH     = -509;
  DISPID_FILLCOLOR     = -510;
  DISPID_FILLSTYLE     = -511;
  DISPID_FONT          = -512;
  DISPID_FORECOLOR     = -513;
  DISPID_ENABLED       = -514;
  DISPID_HWND          = -515;
  DISPID_TABSTOP       = -516;
  DISPID_TEXT          = -517;
  DISPID_CAPTION       = -518;
  DISPID_BORDERVISIBLE = -519;
  DISPID_APPEARANCE    = -520;
  DISPID_MOUSEPOINTER  = -521;
  DISPID_MOUSEICON     = -522;
  DISPID_PICTURE       = -523;
  DISPID_VALID         = -524;
  DISPID_READYSTATE    = -525;

  DISPID_REFRESH  = -550;
  DISPID_DOCLICK  = -551;
  DISPID_ABOUTBOX = -552;

  DISPID_CLICK            = -600;
  DISPID_DBLCLICK         = -601;
  DISPID_KEYDOWN          = -602;
  DISPID_KEYPRESS         = -603;
  DISPID_KEYUP            = -604;
  DISPID_MOUSEDOWN        = -605;
  DISPID_MOUSEMOVE        = -606;
  DISPID_MOUSEUP          = -607;
  DISPID_ERROREVENT       = -608;
  DISPID_READYSTATECHANGE = -609;

  { DISPID_THIS is from dispex.h }

  DISPID_THIS = -613;

  DISPID_AMBIENT_BACKCOLOR         = -701;
  DISPID_AMBIENT_DISPLAYNAME       = -702;
  DISPID_AMBIENT_FONT              = -703;
  DISPID_AMBIENT_FORECOLOR         = -704;
  DISPID_AMBIENT_LOCALEID          = -705;
  DISPID_AMBIENT_MESSAGEREFLECT    = -706;
  DISPID_AMBIENT_SCALEUNITS        = -707;
  DISPID_AMBIENT_TEXTALIGN         = -708;
  DISPID_AMBIENT_USERMODE          = -709;
  DISPID_AMBIENT_UIDEAD            = -710;
  DISPID_AMBIENT_SHOWGRABHANDLES   = -711;
  DISPID_AMBIENT_SHOWHATCHING      = -712;
  DISPID_AMBIENT_DISPLAYASDEFAULT  = -713;
  DISPID_AMBIENT_SUPPORTSMNEMONICS = -714;
  DISPID_AMBIENT_AUTOCLIP          = -715;
  DISPID_AMBIENT_APPEARANCE        = -716;

  DISPID_AMBIENT_PALETTE           = -726;
  DISPID_AMBIENT_TRANSFERPRIORITY  = -728;

  DISPID_Name                      = -800;
  DISPID_Delete                    = -801;
  DISPID_Object                    = -802;
  DISPID_Parent                    = -803;


{ Dispatch ID constants for fonts }

  DISPID_FONT_NAME    = 0;
  DISPID_FONT_SIZE    = 2;
  DISPID_FONT_BOLD    = 3;
  DISPID_FONT_ITALIC  = 4;
  DISPID_FONT_UNDER   = 5;
  DISPID_FONT_STRIKE  = 6;
  DISPID_FONT_WEIGHT  = 7;
  DISPID_FONT_CHARSET = 8;

{ Dispatch ID constants for pictures }

  DISPID_PICT_HANDLE = 0;
  DISPID_PICT_HPAL   = 2;
  DISPID_PICT_TYPE   = 3;
  DISPID_PICT_WIDTH  = 4;
  DISPID_PICT_HEIGHT = 5;
  DISPID_PICT_RENDER = 6;

  // Reserved global Property IDs
  PID_DICTIONARY     = 0;
  PID_CODEPAGE       = $1;
  PID_FIRST_USABLE   = $2;
  PID_FIRST_NAME_DEFAULT = $fff;
  PID_LOCALE         = $80000000;
  PID_MODIFY_TIME    = $80000001;
  PID_SECURITY       = $80000002;
  PID_ILLEGAL            = $ffffffff;

  // Property IDs for the SummaryInformation Property Set
  PIDSI_TITLE               = $00000002;  // VT_LPSTR
  PIDSI_SUBJECT             = $00000003;  // VT_LPSTR
  PIDSI_AUTHOR              = $00000004;  // VT_LPSTR
  PIDSI_KEYWORDS            = $00000005;  // VT_LPSTR
  PIDSI_COMMENTS            = $00000006;  // VT_LPSTR
  PIDSI_TEMPLATE            = $00000007;  // VT_LPSTR
  PIDSI_LASTAUTHOR          = $00000008;  // VT_LPSTR
  PIDSI_REVNUMBER           = $00000009;  // VT_LPSTR
  PIDSI_EDITTIME            = $0000000a;  // VT_FILETIME (UTC)
  PIDSI_LASTPRINTED         = $0000000b;  // VT_FILETIME (UTC)
  PIDSI_CREATE_DTM          = $0000000c;  // VT_FILETIME (UTC)
  PIDSI_LASTSAVE_DTM        = $0000000d;  // VT_FILETIME (UTC)
  PIDSI_PAGECOUNT           = $0000000e;  // VT_I4
  PIDSI_WORDCOUNT           = $0000000f;  // VT_I4
  PIDSI_CHARCOUNT           = $00000010;  // VT_I4
  PIDSI_THUMBNAIL           = $00000011;  // VT_CF
  PIDSI_APPNAME             = $00000012;  // VT_LPSTR
  PIDSI_DOC_SECURITY        = $00000013;  // VT_I4

  PRSPEC_INVALID            = $ffffffff;
  PRSPEC_LPWSTR             = 0;
  PRSPEC_PROPID             = 1;

{ from WTYPES.H }
{ Result code }

type
  SCODE = Integer;

{ VT_INT and VT_UINT }
  SYSINT = Integer;
  SYSUINT = LongWord;

  TResultList = array[0..65535] of HRESULT;

{ Unknown lists }

  TUnknownList = array[0..65535] of TObject; { IUnknown }

{ OLE character and string types }

  TOleChar = WideChar;

  TOleStrList = array[0..65535] of IntPtr; { POleStr }

{ 64-bit large integer }

  Largeint = Int64;

{ 64-bit large unsigned integer }

  Largeuint = Int64;

{ Interface ID }

  TIID = TGUID;

{ Class ID }

  TCLSID = TGUID;

{ Object ID }

  [StructLayout(LayoutKind.Sequential)]
  _OBJECTID = record
    Lineage: TGUID;
    Uniquifier: Longint;
  end;
  TObjectID = _OBJECTID;
  OBJECTID = TObjectID;

{ Locale ID }

  TLCID = DWORD;

{ Format ID }

  FMTID = TGUID;
  TFmtID = TGUID;

{ OLE control types }

  TTextMetricOle = TTextMetricW;

  OLE_COLOR = DWORD;
  TOleColor = OLE_COLOR;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _COSERVERINFO = record
    dwReserved1: Longint;
    [MarshalAs(UnmanagedType.LPWStr)]
    pwszName: string;  { LPWSTR }
    pAuthInfo: IntPtr; { Pointer }
    dwReserved2: Longint;
  end;
  TCoServerInfo = _COSERVERINFO;
  COSERVERINFO = TCoServerInfo;

  [StructLayout(LayoutKind.Sequential)]
  tagMULTI_QI = record
    IID: IntPtr;  { PIID }
    [MarshalAs(UnmanagedType.IUnknown)]
    Itf: TObject; { IUnknown }
    hr: HRESULT;
  end;
  TMultiQI = tagMULTI_QI;
  MULTI_QI = TMultiQI;

  TMultiQIArray = array of TMultiQI;

{ from OAIDL.H }
  [StructLayout(LayoutKind.Sequential)]
  tagSAFEARRAYBOUND = record
    cElements: Longint;
    lLbound: Longint;
  end;
  TSafeArrayBound = tagSAFEARRAYBOUND;
  SAFEARRAYBOUND = TSafeArrayBound;

  PSafeArray = IntPtr; { ^TSafeArray }
  tagSAFEARRAY = record
    cDims: Word;
    fFeatures: Word;
    cbElements: Longint;
    cLocks: Longint;
    pvData: IntPtr; { Pointer }
    rgsabound: IntPtr; { array[0..0] of TSafeArrayBound }
  end;
  TSafeArray = tagSAFEARRAY;
  SAFEARRAY = TSafeArray;

  TOleDate = Double;

  TOleBool = WordBool;

  TVarType = Word;

  TOldOleEnum = type Integer;
  TOleEnum = type LongWord;

{ from OLECTL.H }
  OLE_XPOS_PIXELS  = Longint;
  OLE_YPOS_PIXELS  = Longint;
  OLE_XSIZE_PIXELS = Longint;
  OLE_YSIZE_PIXELS = Longint;

  OLE_XPOS_HIMETRIC  = Longint;
  OLE_YPOS_HIMETRIC  = Longint;
  OLE_XSIZE_HIMETRIC = Longint;
  OLE_YSIZE_HIMETRIC = Longint;

  OLE_XPOS_CONTAINER  = Single;
  OLE_YPOS_CONTAINER  = Single;
  OLE_XSIZE_CONTAINER = Single;
  OLE_YSIZE_CONTAINER = Single;

  OLE_TRISTATE = SmallInt;

const
  triUnchecked = 0;
  triChecked   = 1;
  triGray      = 2;

type
  OLE_OPTEXCLUSIVE = WordBool;

  OLE_CANCELBOOL = WordBool;

  OLE_ENABLEDEFAULTBOOL = WordBool;

  OLE_HANDLE = LongWord;

  FONTNAME = WideString;

  FONTSIZE = Currency;

  FONTBOLD = WordBool;

  FONTITALIC = WordBool;

  FONTUNDERSCORE = WordBool;

  FONTSTRIKETHROUGH = WordBool;


{ Registration function types }

  TDLLRegisterServer = function: HResult;
  TDLLUnregisterServer = function: HResult;

{ from OCIDL.H }
{ TPointF structure }

  [StructLayout(LayoutKind.Sequential)]
  tagPOINTF = record
    x: Single;
    y: Single;
  end;
  TPointF = tagPOINTF;
  POINTF = TPointF;


{ TControlInfo structure }

  [StructLayout(LayoutKind.Sequential)]
  tagCONTROLINFO = record
    cb: Longint;
    hAccel: HAccel;
    cAccel: Word;
    dwFlags: Longint;
  end;
  TControlInfo = tagCONTROLINFO;
  CONTROLINFO = TControlInfo;

{ from OBJIDL.H }
{ Forward declarations }

  IStream = interface;
  IRunningObjectTable = interface;
  IEnumString = interface;
  IMoniker = interface;
  IAdviseSink = interface;
  ITypeInfo = interface;
  ITypeInfo2 = interface;
  ITypeComp = interface;
  ITypeLib = interface;
  ITypeLib2 = interface;
  IEnumOLEVERB = interface;
  IOleInPlaceActiveObject = interface;
  IOleControl = interface;
  IOleControlSite = interface;
  ISimpleFrameSite = interface;
  IPersistStreamInit = interface;
  IPersistPropertyBag = interface;
  IPropertyNotifySink = interface;
  IProvideClassInfo = interface;
  IConnectionPointContainer = interface;
  IEnumConnectionPoints = interface;
  IConnectionPoint = interface;
  IEnumConnections = interface;
  IClassFactory2 = interface;
  ISpecifyPropertyPages = interface;
  IPerPropertyBrowsing = interface;
  IPropertyPageSite = interface;
  IPropertyPage = interface;
  IPropertyPage2 = interface;
  IPropertySetStorage = interface;
  IPropertyStorage = interface;
  IEnumSTATPROPSTG = interface;
  IEnumSTATPROPSETSTG = interface;
  IGlobalInterfaceTable = interface;

{ IClassFactory interface }
  [ComImport,
  GuidAttribute('00000001-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IClassFactory = interface
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out obj): HResult;
    [PreserveSig]
    function LockServer(fLock: BOOL): HResult;
  end;

{ IMarshal interface }

  [ComImport,
  GuidAttribute('00000003-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMarshal = interface
    [PreserveSig]
    function GetUnmarshalClass([MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      pv: IntPtr; dwDestContext: Longint; pvDestContext: IntPtr;
      mshlflags: Longint; out cid: TCLSID): HResult;
    [PreserveSig]
    function GetMarshalSizeMax([MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      pv: IntPtr; dwDestContext: Longint; pvDestContext: IntPtr;
      mshlflags: Longint; out size: Longint): HResult;
    [PreserveSig]
    function MarshalInterface([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID; pv: IntPtr;
      dwDestContext: Longint; pvDestContext: IntPtr; mshlflags: Longint): HResult;
    [PreserveSig]
    function UnmarshalInterface([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
    [PreserveSig]
    function ReleaseMarshalData([in, MarshalAs(UnmanagedType.Interface)] stm: IStream): HResult;
    [PreserveSig]
    function DisconnectObject(dwReserved: Longint): HResult;
  end;

{ IMalloc interface }

  [ComImport,
  GuidAttribute('00000002-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMalloc = interface
    [PreserveSig]
    function Alloc(cb: Longint): IntPtr;
    [PreserveSig]
    function Realloc(pv: IntPtr; cb: Longint): IntPtr;
    [PreserveSig]
    procedure Free(pv: IntPtr);
    [PreserveSig]
    function GetSize(pv: IntPtr): Longint;
    [PreserveSig]
    function DidAlloc(pv: IntPtr): Integer;
    [PreserveSig]
    procedure HeapMinimize;
  end;

{ IMallocSpy interface }

  [ComImport,
  GuidAttribute('0000001D-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMallocSpy = interface
    [PreserveSig]
    function PreAlloc(cbRequest: Longint): Longint;
    [PreserveSig]
    function PostAlloc(pActual: IntPtr): IntPtr;
    [PreserveSig]
    function PreFree(pRequest: IntPtr; fSpyed: BOOL): IntPtr;
    [PreserveSig]
    procedure PostFree(fSpyed: BOOL);
    [PreserveSig]
    function PreRealloc(pRequest: IntPtr; cbRequest: Longword;
      out ppNewRequest: IntPtr; fSpyed: BOOL): Longword;
    [PreserveSig]
    function PostRealloc(pActual: IntPtr; fSpyed: BOOL): IntPtr;
    [PreserveSig]
    function PreGetSize(pRequest: IntPtr; fSpyed: BOOL): IntPtr;
    [PreserveSig]
    function PostGetSize(pActual: Longword; fSpyed: BOOL): Longword;
    [PreserveSig]
    function PreDidAlloc(pRequest: IntPtr; fSpyed: BOOL): IntPtr;
    [PreserveSig]
    function PostDidAlloc(pRequest: IntPtr; fSpyed: BOOL; fActual: Integer): Integer;
    [PreserveSig]
    procedure PreHeapMinimize;
    [PreserveSig]
    procedure PostHeapMinimize;
  end;

{ IStdMarshalInfo interface }

  [ComImport,
  GuidAttribute('00000018-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IStdMarshalInfo = interface
    [PreserveSig]
    function GetClassForHandler(dwDestContext: Longint; pvDestContext: IntPtr;
      out clsid: TCLSID): HResult;
  end;

{ IExternalConnection interface }

  [ComImport,
  GuidAttribute('00000019-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IExternalConnection = interface
    [PreserveSig]
    function AddConnection(extconn: Longint; reserved: Longint): Longint;
    [PreserveSig]
    function ReleaseConnection(extconn: Longint; reserved: Longint;
      fLastReleaseCloses: BOOL): Longint;
  end;

{ IWeakRef interface }

  [ComImport,
  GuidAttribute('A35E20C2-837D-11D0-9E9F-00A02457621F'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IWeakRef = interface
    [PreserveSig]
    function ChangeWeakCount(delta: Longint): Longint;
    [PreserveSig]
    function ReleaseKeepAlive([MarshalAs(UnmanagedType.IUnknown)] unkReleased: TObject;
      reserved: Longint): Longint;
  end;

{ IEnumUnknown interface }

  [ComImport,
  GuidAttribute('00000100-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumUnknown = interface
    [PreserveSig]
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of TObject; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out enm: IEnumUnknown): HResult;
  end;

{ IBindCtx interface }

  [StructLayout(LayoutKind.Sequential)]
  tagBIND_OPTS = record
    cbStruct: Longint;
    grfFlags: Longint;
    grfMode: Longint;
    dwTickCountDeadline: Longint;
  end;
  TBindOpts = tagBIND_OPTS;
  BIND_OPTS = TBindOpts;

  [ComImport,
  GuidAttribute('0000000E-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IBindCtx = interface
    [PreserveSig]
    function RegisterObjectBound([MarshalAs(UnmanagedType.IUnknown)] unk: TObject): HResult;
    [PreserveSig]
    function RevokeObjectBound([MarshalAs(UnmanagedType.IUnknown)] unk: TObject): HResult;
    [PreserveSig]
    function ReleaseBoundObjects: HResult;
    [PreserveSig]
    function SetBindOptions([in] var bindopts: TBindOpts): HResult;
    [PreserveSig]
    function GetBindOptions(var bindopts: TBindOpts): HResult;
    [PreserveSig]
    function GetRunningObjectTable(out rot: IRunningObjectTable): HResult;
    [PreserveSig]
    function RegisterObjectParam([MarshalAs(UnmanagedType.LPWStr)] pszKey: string;
      [MarshalAs(UnmanagedType.Interface)] unk: TObject): HResult;
    [PreserveSig]
    function GetObjectParam([MarshalAs(UnmanagedType.LPWStr)] pszKey: string;
      [MarshalAs(UnmanagedType.Interface)] out unk): HResult;
    [PreserveSig]
    function EnumObjectParam(out Enum: IEnumString): HResult;
    [PreserveSig]
    function RevokeObjectParam([MarshalAs(UnmanagedType.LPWStr)] pszKey: string): HResult;
  end;

{ IEnumMoniker interface }

  [ComImport,
  GuidAttribute('00000102-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumMoniker = interface
    [PreserveSig]
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of IMoniker; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out enm: IEnumMoniker): HResult;
  end;

{ IRunnableObject interface }

  [ComImport,
  GuidAttribute('00000126-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRunnableObject = interface
    [PreserveSig]
    function GetRunningClass(out clsid: TCLSID): HResult;
    [PreserveSig]
    function Run([in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx): HResult;
    [PreserveSig]
    function IsRunning: BOOL;
    [PreserveSig]
    function LockRunning(fLock: BOOL; fLastUnlockCloses: BOOL): HResult;
    [PreserveSig]
    function SetContainedObject(fContained: BOOL): HResult;
  end;

{ IRunningObjectTable interface }

  [ComImport,
  GuidAttribute('00000010-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRunningObjectTable = interface
    [PreserveSig]
    function Register(grfFlags: Longint;
      [MarshalAs(UnmanagedType.IUnknown)] unkObject: TObject;
      [MarshalAs(UnmanagedType.Interface)] mkObjectName: IMoniker;
      out dwRegister: Longint): HResult;
    [PreserveSig]
    function Revoke(dwRegister: Longint): HResult;
    [PreserveSig]
    function IsRunning([MarshalAs(UnmanagedType.Interface)] mkObjectName: IMoniker): HResult;
    [PreserveSig]
    function GetObject([MarshalAs(UnmanagedType.Interface)] mkObjectName: IMoniker;
      [MarshalAs(UnmanagedType.Interface)] out unkObject): HResult;
    [PreserveSig]
    function NoteChangeTime(dwRegister: Longint;
      [in] var filetime: TFileTime): HResult;
    [PreserveSig]
    function GetTimeOfLastChange([MarshalAs(UnmanagedType.Interface)] mkObjectName: IMoniker;
      out filetime: TFileTime): HResult;
    [PreserveSig]
    function EnumRunning(out enumMoniker: IEnumMoniker): HResult;
  end;

{ IPersist interface }

  [ComImport,
  GuidAttribute('0000010C-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersist = interface
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;
  end;

{ IPersistStream interface }

  [ComImport,
  GuidAttribute('00000109-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistStream = interface { (IPersist) }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistStream
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function Load([in, MarshalAs(UnmanagedType.Interface)] stm: IStream): HResult;
    [PreserveSig]
    function Save([in, MarshalAs(UnmanagedType.Interface)] stm: IStream; fClearDirty: BOOL): HResult;
    [PreserveSig]
    function GetSizeMax(out cbSize: Largeint): HResult;
  end;

{ IMoniker interface }

  [ComImport,
  GuidAttribute('0000000F-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMoniker = interface { IPersistStream }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistStream
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function Load([in, MarshalAs(UnmanagedType.Interface)] stm: IStream): HResult;
    [PreserveSig]
    function Save([in, MarshalAs(UnmanagedType.Interface)] stm: IStream; fClearDirty: BOOL): HResult;
    [PreserveSig]
    function GetSizeMax(out cbSize: Largeint): HResult;

    // IMoniker
    [PreserveSig]
    function BindToObject(bc: IBindCtx; mkToLeft: IMoniker;
      [MarshalAs(UnmanagedType.LPStruct)] iidResult: TIID;
      [MarshalAs(UnmanagedType.Interface)] out vResult): HResult;
    [PreserveSig]
    function BindToStorage(bc: IBindCtx; mkToLeft: IMoniker;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
    [PreserveSig]
    function Reduce(bc: IBindCtx; dwReduceHowFar: Longint;
      var mkToLeft: IMoniker; out mkReduced: IMoniker): HResult;
    [PreserveSig]
    function ComposeWith(mkRight: IMoniker; fOnlyIfNotGeneric: BOOL;
      out mkComposite: IMoniker): HResult;
    [PreserveSig]
    function Enum(fForward: BOOL; out enumMoniker: IEnumMoniker): HResult;
    [PreserveSig]
    function IsEqual(mkOtherMoniker: IMoniker): HResult;
    [PreserveSig]
    function Hash(out dwHash: Longint): HResult;
    [PreserveSig]
    function IsRunning(bc: IBindCtx; mkToLeft: IMoniker;
      mkNewlyRunning: IMoniker): HResult;
    [PreserveSig]
    function GetTimeOfLastChange(bc: IBindCtx; mkToLeft: IMoniker;
      out filetime: TFileTime): HResult;
    [PreserveSig]
    function Inverse(out mk: IMoniker): HResult;
    [PreserveSig]
    function CommonPrefixWith(mkOther: IMoniker; out mkPrefix: IMoniker): HResult;
    [PreserveSig]
    function RelativePathTo(mkOther: IMoniker; out mkRelPath: IMoniker): HResult;
    [PreserveSig]
    function GetDisplayName(bc: IBindCtx; mkToLeft: IMoniker;
      [MarshalAs(UnmanagedType.LPWStr)] out pszDisplayName: string): HResult;
    [PreserveSig]
    function ParseDisplayName(bc: IBindCtx; mkToLeft: IMoniker;
      [MarshalAs(UnmanagedType.LPWStr)] pszDisplayName: string;
      out chEaten: Longint; out mkOut: IMoniker): HResult;
    [PreserveSig]
    function IsSystemMoniker(out dwMksys: Longint): HResult;
  end;

{ IEnumString interface }

  [ComImport,
  GuidAttribute('00000101-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumString = interface
    [PreserveSig]
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr, SizeParamIndex = 0)]
      rgelt: array of string; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out enm: IEnumString): HResult;
  end;

{ IStream interface }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagSTATSTG = record
    [MarshalAs(UnmanagedType.LPWStr)]
    pwcsName: string;
    dwType: Longint;
    cbSize: Largeint;
    mtime: TFileTime;
    ctime: TFileTime;
    atime: TFileTime;
    grfMode: Longint;
    grfLocksSupported: Longint;
    clsid: TCLSID;
    grfStateBits: Longint;
    reserved: Longint;
  end;
  TStatStg = tagSTATSTG;
  STATSTG = TStatStg;

  [ComImport,
  GuidAttribute('0c733a30-2a1c-11ce-ade5-00aa0044773d'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISequentialStream = interface
    [PreserveSig]
    function Read([out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      pv: TBytes; cb: Longint; pcbRead: IntPtr): HResult;
    [PreserveSig]
    function Write([in, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      pv: TBytes; cb: Longint; pcbWritten: IntPtr): HResult;
  end;

  [ComImport,
  GuidAttribute('0000000C-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IStream = interface { ISequentialStream }
    // ISequentialStream
    [PreserveSig]
    function Read([out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      pv: TBytes; cb: Longint; pcbRead: IntPtr): HResult;
    [PreserveSig]
    function Write([in, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      pv: TBytes; cb: Longint; pcbWritten: IntPtr): HResult;

    // IStream
    [PreserveSig]
    function Seek(dlibMove: Int64; dwOrigin: Longint;
      libNewPosition: IntPtr): HResult;
    [PreserveSig]
    function SetSize(libNewSize: Int64): HResult;
    [PreserveSig]
    function CopyTo(stm: IStream; cb: Int64; cbRead: IntPtr; cbWritten: IntPtr): HResult;
    [PreserveSig]
    function Commit(grfCommitFlags: Longint): HResult;
    [PreserveSig]
    function Revert: HResult;
    [PreserveSig]
    function LockRegion(libOffset: Int64; cb: Int64; dwLockType: Longint): HResult;
    [PreserveSig]
    function UnlockRegion(libOffset: Int64; cb: Int64; dwLockType: Longint): HResult;
    [PreserveSig]
    function Stat(out statstg: TStatStg; grfStatFlag: Longint): HResult;
    [PreserveSig]
    function Clone(out stm: IStream): HResult;
  end;

{ IEnumStatStg interface }

  [ComImport,
  GuidAttribute('0000000D-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumStatStg = interface
    [PreserveSig]
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of TStatStg; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out enm: IEnumStatStg): HResult;
  end;

{ IStorage interface }

  //TSNB = ^POleStr;

  [ComImport,
  GuidAttribute('0000000B-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IStorage = interface
    [PreserveSig]
    function CreateStream([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string;
      grfMode: Longint; reserved1: Longint; reserved2: Longint; out stm: IStream): HResult;
    [PreserveSig]
    function OpenStream([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string;
      reserved1: IntPtr; grfMode: Longint; reserved2: Longint; out stm: IStream): HResult;
    [PreserveSig]
    function CreateStorage([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string;
      grfMode: Longint; dwStgFmt: Longint; reserved2: Longint; out stg: IStorage): HResult;
    [PreserveSig]
    function OpenStorage([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string;
      [in, MarshalAs(UnmanagedType.Interface)] stgPriority: IStorage;
      grfMode: Longint; snbExclude: IntPtr;
      reserved: Longint; out stg: IStorage): HResult;
    [PreserveSig]
    function CopyTo(ciidExclude: Longint;
      [MarshalAs(UnmanagedType.LPStruct)] rgiidExclude: TIID; snbExclude: IntPtr;
      [in, MarshalAs(UnmanagedType.Interface)] stgDest: IStorage): HResult;
    [PreserveSig]
    function MoveElementTo([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string;
      [in, MarshalAs(UnmanagedType.Interface)] stgDest: IStorage;
      [in, MarshalAs(UnmanagedType.BStr)] pwcsNewName: string;
      grfFlags: Longint): HResult;
    [PreserveSig]
    function Commit(grfCommitFlags: Longint): HResult;
    [PreserveSig]
    function Revert: HResult;
    [PreserveSig]
    function EnumElements(reserved1: Longint; reserved2: IntPtr; reserved3: Longint;
      out enm: IEnumStatStg): HResult;
    [PreserveSig]
    function DestroyElement([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string): HResult;
    [PreserveSig]
    function RenameElement([in, MarshalAs(UnmanagedType.BStr)] pwcsOldName: string;
      [in, MarshalAs(UnmanagedType.BStr)] pwcsNewName: string): HResult;
    [PreserveSig]
    function SetElementTimes([in, MarshalAs(UnmanagedType.BStr)] pwcsName: string;
      [in] var ctime: TFileTime; [in] var atime: TFileTime; [in] var mtime: TFileTime): HResult;
    [PreserveSig]
    function SetClass([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID): HResult;
    [PreserveSig]
    function SetStateBits(grfStateBits: Longint; grfMask: Longint): HResult;
    [PreserveSig]
    function Stat(out statstg: TStatStg; grfStatFlag: Longint): HResult;
  end;

{ IPersistFile interface }

  [ComImport,
  GuidAttribute('0000010B-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistFile = interface { IPersist }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistFile
    function IsDirty: HResult;
    function Load([MarshalAs(UnmanagedType.LPWStr)] pszFileName: string;
      dwMode: Longint): HResult;
    function Save([MarshalAs(UnmanagedType.LPWStr)] pszFileName: string;
      fRemember: BOOL): HResult;
    function SaveCompleted([MarshalAs(UnmanagedType.LPWStr)] pszFileName: string): HResult;
    function GetCurFile([MarshalAs(UnmanagedType.LPWStr)] out pszFileName: string): HResult;
  end;

{ IPersistStorage interface }

  [ComImport,
  GuidAttribute('0000010A-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistStorage = interface { IPersist }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistStorage
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function InitNew([in, MarshalAs(UnmanagedType.Interface)] stg: IStorage): HResult;
    [PreserveSig]
    function Load([in, MarshalAs(UnmanagedType.Interface)] stg: IStorage): HResult;
    [PreserveSig]
    function Save([in, MarshalAs(UnmanagedType.Interface)] stgSave: IStorage;
      fSameAsLoad: BOOL): HResult;
    [PreserveSig]
    function SaveCompleted([in, MarshalAs(UnmanagedType.Interface)] stgNew: IStorage): HResult;
    [PreserveSig]
    function HandsOffStorage: HResult;
  end;

{ ILockBytes interface }

  [ComImport,
  GuidAttribute('0000000A-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ILockBytes = interface
    [PreserveSig]
    function ReadAt(ulOffset: Largeint; pv: IntPtr; cb: Longint;
      pcbRead: IntPtr): HResult;
    [PreserveSig]
    function WriteAt(ulOffset: Largeint; pv: IntPtr; cb: Longint;
      pcbWritten: IntPtr): HResult;
    [PreserveSig]
    function Flush: HResult;
    [PreserveSig]
    function SetSize(cb: Largeint): HResult;
    [PreserveSig]
    function LockRegion(libOffset: Largeint; cb: Largeint;
      dwLockType: Longint): HResult;
    [PreserveSig]
    function UnlockRegion(libOffset: Largeint; cb: Largeint;
      dwLockType: Longint): HResult;
    [PreserveSig]
    function Stat(out statstg: TStatStg; grfStatFlag: Longint): HResult;
  end;

{ IEnumFormatEtc interface }

  [StructLayout(LayoutKind.Sequential)]
  tagDVTARGETDEVICE = record
    tdSize: Longint;
    tdDriverNameOffset: Word;
    tdDeviceNameOffset: Word;
    tdPortNameOffset: Word;
    tdExtDevmodeOffset: Word;
    tdData: THandle; { record end }
  end;
  TDVTargetDevice = tagDVTARGETDEVICE;
  DVTARGETDEVICE = TDVTargetDevice;

  TClipFormat = Word;

  [StructLayout(LayoutKind.Sequential)]
  tagFORMATETC = record
    cfFormat: TClipFormat;
    dummy: Word;
    ptd: IntPtr; { ^TDVTargetDevice }
    dwAspect: Longint;
    lindex: Longint;
    tymed: Longint;
  end;
  TFormatEtc = tagFORMATETC;
  FORMATETC = TFormatEtc;
  TFormatEtcArray = array of TFormatEtc;

  [ComImport,
  GuidAttribute('00000103-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumFORMATETC = interface
    [PreserveSig]
    function Next(celt: ULONG;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: TFormatEtcArray; out pceltFetched: ULONG): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumFormatEtc): HResult;
  end;

{ IEnumStatData interface }

  tagSTATDATA = record
    formatetc: TFormatEtc;
    advf: Longint;
    [MarshalAs(UnmanagedType.Interface)]
    advSink: TObject; { IAdviseSink }
    dwConnection: Longint;
  end;
  TStatData = tagSTATDATA;
  STATDATA = TStatData;


  [ComImport,
  GuidAttribute('00000105-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumSTATDATA = interface
    [PreserveSig]
    function Next(celt: ULONG;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of TStatData; out pceltFetched: ULONG): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumStatData): HResult;
  end;

{ IRootStorage interface }

  [ComImport,
  GuidAttribute('00000012-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRootStorage = interface
    [PreserveSig]
    function SwitchToFile([MarshalAs(UnmanagedType.LPWStr)] pszFile: string): HResult;
  end;

{ IAdviseSink interface }

  [StructLayout(LayoutKind.Sequential)]
  tagRemSTGMEDIUM = record
    tymed: Longint;
    dwHandleType: Longint;
    pData: Longint;
    pUnkForRelease: Longint;
    cbData: Longint;
    data: THandle; { record end }
  end;
  TRemStgMedium = tagRemSTGMEDIUM;
  RemSTGMEDIUM = TRemStgMedium;

  tagSTGMEDIUM = record
    tymed: Longint;
    case Integer of
      0: (hBitmap: HBitmap; unkForRelease: IntPtr); { IUnknown }
      1: (hMetaFilePict: THandle);
      2: (hEnhMetaFile: THandle);
      3: (hGlobal: HGLOBAL);
      4: (lpszFileName: IntPtr);                    { POleStr }
      5: (stm: IntPtr);                             { IStream }
      6: (stg: IntPtr);                             { IStorage }
  end;
  TStgMedium = tagSTGMEDIUM;
  STGMEDIUM = TStgMedium;

  [ComImport,
  GuidAttribute('0000010F-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAdviseSink = interface
    [PreserveSig]
    procedure OnDataChange([in] var formatetc: TFormatEtc; [in] var stgmed: TStgMedium);
    [PreserveSig]
    procedure OnViewChange(dwAspect: Longint; lindex: Longint);
    [PreserveSig]
    procedure OnRename([in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker);
    [PreserveSig]
    procedure OnSave;
    [PreserveSig]
    procedure OnClose;
  end;

{ IAdviseSink2 interface }

  [ComImport,
  GuidAttribute('00000125-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAdviseSink2 = interface { IAdviseSink }
    // IAdviseSink
    [PreserveSig]
    procedure OnDataChange([in] var formatetc: TFormatEtc; [in] var stgmed: TStgMedium);
    [PreserveSig]
    procedure OnViewChange(dwAspect: Longint; lindex: Longint);
    [PreserveSig]
    procedure OnRename([in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker);
    [PreserveSig]
    procedure OnSave;
    [PreserveSig]
    procedure OnClose;

    // IAdviseSink2
    procedure OnLinkSrcChange([in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker);
  end;

{ IDataObject interface }

  [ComImport,
  GuidAttribute('0000010E-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDataObject = interface
    [PreserveSig]
    function GetData([in] var formatetcIn: TFormatEtc; out medium: TStgMedium): HResult;
    [PreserveSig]
    function GetDataHere([in] var formatetc: TFormatEtc; out medium: TStgMedium): HResult;
    [PreserveSig]
    function QueryGetData([in] var formatetc: TFormatEtc): HResult;
    [PreserveSig]
    function GetCanonicalFormatEtc([in] var formatetc: TFormatEtc;
      out formatetcOut: TFormatEtc): HResult;
    [PreserveSig]
    function SetData([in] var formatetc: TFormatEtc; var medium: TStgMedium;
      fRelease: BOOL): HResult;
    [PreserveSig]
    function EnumFormatEtc(dwDirection: Longint; out enumFormatEtc: IEnumFormatEtc): HResult;
    [PreserveSig]
    function DAdvise([in] var formatetc: TFormatEtc; advf: Longint;
      [in] var advSink: IAdviseSink; out dwConnection: Longint): HResult;
    [PreserveSig]
    function DUnadvise(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumDAdvise(out enumAdvise: IEnumStatData): HResult;
  end;

{ IDataAdviseHolder interface }

  [ComImport,
  GuidAttribute('00000110-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDataAdviseHolder = interface
    [PreserveSig]
    function Advise([in, MarshalAs(UnmanagedType.Interface)] dataObject: IDataObject;
      [in] var fetc: TFormatEtc; advf: Longint;
      [in, MarshalAs(UnmanagedType.Interface)] advise: IAdviseSink;
      out pdwConnection: Longint): HResult;
    [PreserveSig]
    function Unadvise(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumAdvise(out enumAdvise: IEnumStatData): HResult;
    [PreserveSig]
    function SendOnDataChange([in, MarshalAs(UnmanagedType.Interface)] dataObject: IDataObject;
      dwReserved: Longint; advf: Longint): HResult;
  end;

{ IMessageFilter interface }

  [StructLayout(LayoutKind.Sequential)]
  tagINTERFACEINFO = record
    [MarshalAs(UnmanagedType.IUnknown)]
    unk: TObject;
    iid: TIID;
    wMethod: Word;
  end;
  TInterfaceInfo = tagINTERFACEINFO;
  INTERFACEINFO = TInterfaceInfo;


  [ComImport,
  GuidAttribute('00000016-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMessageFilter = interface
    [PreserveSig]
    function HandleInComingCall(dwCallType: Longint; htaskCaller: HTask;
      dwTickCount: Longint; lpInterfaceInfo: IntPtr): Longint;
    [PreserveSig]
    function RetryRejectedCall(htaskCallee: HTask; dwTickCount: Longint;
      dwRejectType: Longint): Longint;
    [PreserveSig]
    function MessagePending(htaskCallee: HTask; dwTickCount: Longint;
      dwPendingType: Longint): Longint;
  end;

{ IRpcChannelBuffer interface }

  TRpcOleDataRep = DWORD;

  [StructLayout(LayoutKind.Sequential)]
  tagRPCOLEMESSAGE = record
    reserved1: IntPtr; { Pointer }
    dataRepresentation: TRpcOleDataRep;
    Buffer: IntPtr; { Pointer }
    cbBuffer: Longint;
    iMethod: Longint;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=5)]
    reserved2: array[0..4] of IntPtr; { Pointer }
    rpcFlags: Longint;
  end;
  TRpcOleMessage = tagRPCOLEMESSAGE;
  RPCOLEMESSAGE = TRpcOleMessage;

  [ComImport,
  GuidAttribute('D5F56B60-593B-101A-B569-08002B2DBF7A'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRpcChannelBuffer = interface
    [PreserveSig]
    function GetBuffer(var message: TRpcOleMessage;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID): HResult;
    [PreserveSig]
    function SendReceive(var message: TRpcOleMessage; var status: Longint): HResult;
    [PreserveSig]
    function FreeBuffer(var message: TRpcOleMessage): HResult;
    [PreserveSig]
    function GetDestCtx(out dwDestContext: Longint; out pvDestContext): HResult;
    [PreserveSig]
    function IsConnected: HResult;
  end;

{ IRpcProxyBuffer interface }

  [ComImport,
  GuidAttribute('D5F56A34-593B-101A-B569-08002B2DBF7A'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRpcProxyBuffer = interface
    [PreserveSig]
    function Connect([in, MarshalAs(UnmanagedType.Interface)]
      rpcChannelBuffer: IRpcChannelBuffer): HResult;
    [PreserveSig]
    procedure Disconnect;
  end;

{ IRpcStubBuffer interface }

  [ComImport,
  GuidAttribute('D5F56AFC-593B-101A-B569-08002B2DBF7A'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IRpcStubBuffer = interface
    [PreserveSig]
    function Connect([MarshalAs(UnmanagedType.IUnknown)] unkServer: TObject): HResult;
    [PreserveSig]
    procedure Disconnect;
    [PreserveSig]
    function Invoke(var rpcmsg: TRpcOleMessage; rpcChannelBuffer: IRpcChannelBuffer): HResult;
    [PreserveSig]
    function IsIIDSupported([MarshalAs(UnmanagedType.LPStruct)] iid: TIID): IntPtr{IRpcStubBuffer};
    [PreserveSig]
    function CountRefs: Longint;
    [PreserveSig]
    function DebugServerQueryInterface([MarshalAs(UnmanagedType.Interface)] var pv): HResult;
    [PreserveSig]
    procedure DebugServerRelease(pv: IntPtr);
  end;

{ IPSFactoryBuffer interface }

  [ComImport,
  GuidAttribute('D5F569D0-593B-101A-B569-08002B2DBF7A'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPSFactoryBuffer = interface
    [PreserveSig]
    function CreateProxy([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      out proxy: IRpcProxyBuffer; [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
    [PreserveSig]
    function CreateStub([MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.IUnknown)] unkServer: TObject;
      [in, MarshalAs(UnmanagedType.Interface)] out stub: IRpcStubBuffer): HResult;
  end;

  [ComImport,
  GuidAttribute('1008C4A0-7613-11CF-9AF1-0020AF6E72F4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IChannelHook = interface
    [PreserveSig]
    procedure ClientGetSize([MarshalAs(UnmanagedType.LPStruct)] uExtent: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID; out DataSize: Longint);
    [PreserveSig]
    procedure ClientFillBuffer([MarshalAs(UnmanagedType.LPStruct)] uExtent: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      var DataSize: Longint; DataBuffer: IntPtr);
    [PreserveSig]
    procedure ClientNotify([MarshalAs(UnmanagedType.LPStruct)] uExtent: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      DataSize: Longint; DataBuffer: IntPtr; lDataRep: Longint; hrFault: HResult);
    [PreserveSig]
    procedure ServerNotify([MarshalAs(UnmanagedType.LPStruct)] uExtent: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      DataSize: Longint; DataBuffer: IntPtr; lDataRep: Longint);
    [PreserveSig]
    procedure ServerGetSize([MarshalAs(UnmanagedType.LPStruct)] uExtent: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      hrFault: HResult; out DataSize: Longint);
    [PreserveSig]
    procedure ServerFillBuffer([MarshalAs(UnmanagedType.LPStruct)] uExtent: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      var DataSize: Longint; DataBuffer: IntPtr; hrFault: HResult);
  end;

  [ComImport,
  GuidAttribute('99CAF010-415E-11CF-8814-00AA00B569F5'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IFillLockBytes = interface
    [PreserveSig]
    function FillAppend([in] pv: TBytes; cb: Longint; out cbWritten: Longint): HResult;
    [PreserveSig]
    function FillAt(Offset: Longint; [in] pv: TBytes; cb: Longint;
      out cbWritten: Longint): HResult;
    [PreserveSig]
    function SetFillSize(Offset: Longint): HResult;
    [PreserveSig]
    function Terminate(bCanceled: Boolean): HResult;
  end;

{ Automation types }

  TBStrList = array[0..65535] of IntPtr; { TBStr }

{ from WTYPES.H }
  tagDEC = packed record
    wReserved: Word;
    case Integer of
      0: (scale, sign: Byte; Hi32: Longint;
      case Integer of
        0: (Lo32, Mid32: Longint);
        1: (Lo64: LONGLONG));
      1: (signscale: Word);
  end;
  TDecimal = tagDEC;
  DECIMAL = TDecimal;

  // tagBLOB related types cause problem due to two definitions of BLOB in wtypes.h/nspapi.h
  // Investigating something that will always work even when a BLOB is not a tagBLOB
  [StructLayout(LayoutKind.Sequential)]
  tagBLOB = record
    cbSize: Longint;
    pBlobData: IntPtr;{ Pointer }
  end;
  // tagBLOB related types cause problem due to two definitions of BLOB in wtypes.h/nspapi.h
  // Investigating something that will always work even when a BLOB is not a tagBLOB
  TBlob = tagBLOB;
  BLOB = TBlob;

  [StructLayout(LayoutKind.Sequential)]
  tagCLIPDATA = record
    cbSize: Longint;
    ulClipFmt: Longint;
    pClipData: IntPtr; { Pointer }
  end;
  TClipData = tagCLIPDATA;
  CLIPDATA = TClipData;

{ IPropertyStorage / IPropertySetStorage }

  tagCAUB = packed record
    cElems: ULONG;
    pElems: IntPtr; { PByte }
  end;
  CAUB = tagCAUB;
  TCAUB = tagCAUB;

  tagCAI = packed record
    cElems: ULONG;
    pElems: IntPtr; { PShortInt }
  end;
  CAI = tagCAI;
  TCAI = tagCAI;

  tagCAUI = packed record
    cElems: ULONG;
    pElems: IntPtr; { PWord }
  end;
  CAUI = tagCAUI;
  TCAUI = tagCAUI;

  tagCAL = packed record
    cElems: ULONG;
    pElems: IntPtr; { PLongint }
  end;
  CAL = tagCAL;
  TCAL = tagCAL;

  tagCAUL = packed record
    cElems: ULONG;
    pElems: IntPtr; { PULONG }
  end;
  CAUL = tagCAUL;
  TCAUL = tagCAUL;

  tagCAFLT = packed record
    cElems: ULONG;
    pElems: IntPtr; { PSingle }
  end;
  CAFLT = tagCAFLT;
  TCAFLT = tagCAFLT;

  tagCADBL = packed record
    cElems: ULONG;
    pElems: IntPtr; { PDouble }
  end;
  CADBL = tagCADBL;
  TCADBL = tagCADBL;

  tagCACY = packed record
    cElems: ULONG;
    pElems: IntPtr; { PCurrency }
  end;
  CACY = tagCACY;
  TCACY = tagCACY;

  tagCADATE = packed record
    cElems: ULONG;
    pElems: IntPtr; { POleDate }
  end;
  CADATE = tagCADATE;
  TCADATE = tagCADATE;

  tagCABSTR = packed record
    cElems: ULONG;
    pElems: IntPtr; { PBSTR }
  end;
  CABSTR = tagCABSTR;
  TCABSTR = tagCABSTR;

  tagCABOOL = packed record
    cElems: ULONG;
    pElems: IntPtr; { POleBool }
  end;
  CABOOL = tagCABOOL;
  TCABOOL = tagCABOOL;

  tagCASCODE = packed record
    cElems: ULONG;
    pElems: IntPtr; { PSCODE }
  end;
  CASCODE = tagCASCODE;
  TCASCODE = tagCASCODE;

  tagCAPROPVARIANT = packed record
    cElems: ULONG;
    pElems: IntPtr; { PPropVariant }
  end;
  CAPROPVARIANT = tagCAPROPVARIANT;
  TCAPROPVARIANT = tagCAPROPVARIANT;

  tagCAH = packed record
    cElems: ULONG;
    pElems: IntPtr; { PLargeInteger }
  end;
  CAH = tagCAH;
  TCAH = tagCAH;

  tagCAUH = packed record
    cElems: ULONG;
    pElems: IntPtr; { PULargeInteger }
  end;
  CAUH = tagCAUH;
  TCAUH = tagCAUH;

  tagCALPSTR = packed record
    cElems: ULONG;
    pElems: IntPtr; { PLPSTR }
  end;
  CALPSTR = tagCALPSTR;
  TCALPSTR = tagCALPSTR;

  tagCALPWSTR = packed record
    cElems: ULONG;
    pElems: IntPtr; { PLPWSTR }
  end;
  CALPWSTR = tagCALPWSTR;
  TCALPWSTR = tagCALPWSTR;

  tagCAFILETIME = packed record
    cElems: ULONG;
    pElems: IntPtr; { PFileTime }
  end;
  CAFILETIME = tagCAFILETIME;
  TCAFILETIME = tagCAFILETIME;

  tagCACLIPDATA = packed record
    cElems: ULONG;
    pElems: IntPtr; { PClipData }
  end;
  CACLIPDATA = tagCACLIPDATA;
  TCACLIPDATA = tagCACLIPDATA;

  tagCACLSID = packed record
    cElems: ULONG;
    pElems: IntPtr; { PCLSID }
  end;
  CACLSID = tagCACLSID;
  TCACLSID = tagCACLSID;

  tagPROPVARIANT = packed record
    vt: TVarType;
    wReserved1: Word;
    wReserved2: Word;
    wReserved3: Word;
    case Integer of
      0: (bVal: Byte);
      1: (iVal: SmallInt);
      2: (uiVal: Word);
      3: (boolVal: TOleBool);
      4: (bool: TOleBool);
      5: (lVal: Longint);
      6: (ulVal: Cardinal);
      7: (fltVal: Single);
      8: (scode: SCODE);
      9: (hVal: LARGE_INTEGER);
      10: (uhVal: ULARGE_INTEGER);
      11: (dblVal: Double);
      12: (cyVal: Currency);
      13: (date: TOleDate);
      14: (filetime: TFileTime);
      15: (puuid: IntPtr);     { PGUID }
      16: (blob: TBlob);
      17: (pclipdata: IntPtr); { PClipData }
      18: (pStream: IntPtr);   { IStream }
      19: (pStorage: IntPtr);  { IStorage }
      20: (bstrVal: IntPtr);   { TBStr }
      21: (pszVal: IntPtr);    { PAnsiChar }
      22: (pwszVal: IntPtr);   { PWideChar }
      23: (caub: TCAUB);
      24: (cai: TCAI);
      25: (caui: TCAUI);
      26: (cabool: TCABOOL);
      27: (cal: TCAL);
      28: (caul: TCAUL);
      29: (caflt: TCAFLT);
      30: (cascode: TCASCODE);
      31: (cah: TCAH);
      32: (cauh: TCAUH);
      33: (cadbl: TCADBL);
      34: (cacy: TCACY);
      35: (cadate: TCADATE);
      36: (cafiletime: TCAFILETIME);
      37: (cauuid: TCACLSID);
      38: (caclipdata: TCACLIPDATA);
      39: (cabstr: TCABSTR);
      40: (calpstr: TCALPSTR);
      41: (calpwstr: TCALPWSTR );
      42: (capropvar: TCAPROPVARIANT);
  end;
  PROPVARIANT = tagPROPVARIANT;
  TPropVariant = tagPROPVARIANT;

  tagPROPSPEC = packed record
    ulKind: ULONG;
    case Integer of
      0: (propid: TPropID);
      1: (lpwstr: IntPtr); { POleStr }
  end;
  PROPSPEC = tagPROPSPEC;
  TPropSpec = tagPROPSPEC;

  tagSTATPROPSTG = record
    lpwstrName: IntPtr; { POleStr }
    propid: TPropID;
    vt: TVarType;
  end;
  STATPROPSTG = tagSTATPROPSTG;
  TStatPropStg = tagSTATPROPSTG;

  tagSTATPROPSETSTG = packed record
    fmtid: TFmtID;
    clsid: TClsID;
    grfFlags: DWORD;
    mtime: TFileTime;
    ctime: TFileTime;
    atime: TFileTime;
    dwOSVersion: DWORD;
  end;
  STATPROPSETSTG = tagSTATPROPSETSTG;
  TStatPropSetStg = tagSTATPROPSETSTG;

  [ComImport,
  GuidAttribute('00000139-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumSTATPROPSTG = interface
    [PreserveSig]
    function Next(celt: ULONG;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of TStatPropStg; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: ULONG): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out ppenum: IEnumSTATPROPSTG): HResult;
  end;

  [ComImport,
  GuidAttribute('0000013B-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumSTATPROPSETSTG = interface
    [PreserveSig]
    function Next(celt: ULONG;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of TStatPropSetStg; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: ULONG): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out ppenum: IEnumSTATPROPSETSTG): HResult;
  end;

  [ComImport,
  GuidAttribute('00000138-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertyStorage = interface
    [PreserveSig]
    function ReadMultiple(cpspec: ULONG; [in] rgpspec: array of TPropSpec;
      [in, out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex=0)]
      rgpropvar: array of TPropVariant): HResult;
    [PreserveSig]
    function WriteMultiple(cpspec: ULONG; [in] rgpspec: array of TPropSpec;
      [in] rgpropvar: array of TPropVariant; propidNameFirst: TPropID): HResult;
    [PreserveSig]
    function DeleteMultiple(cpspec: ULONG; [in] rgpspec: array of TPropSpec): HResult;
    [PreserveSig]
    function ReadPropertyNames(cpropid: ULONG; [in] rgpropid: array of TPropID;
      [in, out, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr, SizeParamIndex=0)]
      rglpwstrName: array of string): HResult;
    [PreserveSig]
    function WritePropertyNames(cpropid: ULONG; [in] rgpropid: array of TPropID;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr)]
      rglpwstrName: array of string): HResult;
    [PreserveSig]
    function DeletePropertyNames(cpropid: ULONG; [in] rgpropid: array of TPropID): HResult;
    [PreserveSig]
    function Commit(grfCommitFlags: DWORD): HResult;
    [PreserveSig]
    function Revert: HResult;
    [PreserveSig]
    function Enum(out ppenum: IEnumSTATPROPSTG): HResult;
    [PreserveSig]
    function SetTimes([in] var pctime, patime, pmtime: TFileTime): HResult;
    [PreserveSig]
    function SetClass([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID): HResult;
    [PreserveSig]
    function Stat(out pstatpsstg: TStatPropSetStg): HResult;
  end;

  [ComImport,
  GuidAttribute('0000013A-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertySetStorage = interface
    [PreserveSig]
    function Create([MarshalAs(UnmanagedType.LPStruct)] rfmtid: TFmtID;
      [MarshalAs(UnmanagedType.LPStruct)] pclsid: TCLSID; grfFlags,
      grfMode: DWORD; out ppprstg: IPropertyStorage): HResult;
    [PreserveSig]
    function Open([MarshalAs(UnmanagedType.LPStruct)] rfmtid: TFmtID;
      grfMode: DWORD; out ppprstg: IPropertyStorage): HResult;
    [PreserveSig]
    function Delete([MarshalAs(UnmanagedType.LPStruct)] rfmtid: TFmtID): HResult;
    [PreserveSig]
    function Enum(out ppenum: IEnumSTATPROPSETSTG): HResult;
  end;
  
  [ComImport,
  GuidAttribute('00000146-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IGlobalInterfaceTable = interface
    function RegisterInterfaceInGlobal([MarshalAs(UnmanagedType.IUnknown)] pUnk: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TIID; out dwCookie: DWORD): HResult;
    function RevokeInterfaceFromGlobal(dwCookie: DWORD): HResult;
    function GetInterfaceFromGlobal(dwCookie: DWORD;
      [MarshalAs(UnmanagedType.LPStruct)] riid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out ppv): HResult;
  end;

{ from OAIDL.H }

  tagVARIANT = record
    vt: TVarType;
    wReserved1: Word;
    wReserved2: Word;
    wReserved3: Word;
    case Integer of
      VT_UI1:                  (bVal: Byte);
      VT_I2:                   (iVal: Smallint);
      VT_I4:                   (lVal: Longint);
      VT_R4:                   (fltVal: Single);
      VT_R8:                   (dblVal: Double);
      VT_BOOL:                 (vbool: TOleBool);
      VT_ERROR:                (scode: HResult);
      VT_CY:                   (cyVal: TOACurrency); 
      VT_DATE:                 (date: TOleDate);
      VT_BSTR:                 (bstrVal: IntPtr);   { PWideChar(WideString) }
      VT_UNKNOWN:              (unkVal: IntPtr);    { Pointer(IUnknown) }
      VT_DISPATCH:             (dispVal: IntPtr);   { Pointer(IDispatch) }
      VT_ARRAY:                (parray: PSafeArray);
      VT_BYREF or VT_UI1:      (pbVal: IntPtr);     { ^Byte }
      VT_BYREF or VT_I2:       (piVal: IntPtr);     { ^Smallint }
      VT_BYREF or VT_I4:       (plVal: IntPtr);     { ^Longint }
      VT_BYREF or VT_R4:       (pfltVal: IntPtr);   { ^Single }
      VT_BYREF or VT_R8:       (pdblVal: IntPtr);   { ^Double }
      VT_BYREF or VT_BOOL:     (pbool: IntPtr);     { ^TOleBool }
      VT_BYREF or VT_ERROR:    (pscode: IntPtr);    { ^HResult }
      VT_BYREF or VT_CY:       (pcyVal: IntPtr);    { ^Currency }
      VT_BYREF or VT_DATE:     (pdate: IntPtr);     { ^TOleDate }
      VT_BYREF or VT_BSTR:     (pbstrVal: IntPtr);  { ^WideString }
      VT_BYREF or VT_UNKNOWN:  (punkVal: IntPtr);   { ^IUnknown }
      VT_BYREF or VT_DISPATCH: (pdispVal: IntPtr);  { ^IDispatch }
      VT_BYREF or VT_ARRAY:    (pparray: IntPtr);   { ^PSafeArray }
      VT_BYREF or VT_VARIANT:  (pvarVal: IntPtr);   { PVariant }
      VT_BYREF:                (byRef: IntPtr);     { Pointer }
      VT_I1:                   (cVal: Char);
      VT_UI2:                  (uiVal: Word);
      VT_UI4:                  (ulVal: LongWord);
      VT_INT:                  (intVal: Integer);
      VT_UINT:                 (uintVal: LongWord);
      VT_BYREF or VT_DECIMAL:  (pdecVal: IntPtr);   { PDecimal }
      VT_BYREF or VT_I1:       (pcVal: IntPtr);     { PChar }
      VT_BYREF or VT_UI2:      (puiVal: IntPtr);    { PWord }
      VT_BYREF or VT_UI4:      (pulVal: IntPtr);    { PInteger }
      VT_BYREF or VT_INT:      (pintVal: IntPtr);   { PInteger }
      VT_BYREF or VT_UINT:     (puintVal: IntPtr);  { PLongWord }
  end;
  TVariantArg = tagVARIANT;


  TVariantArgList = array[0..65535] of TVariantArg;

  TDispID = Longint;

  TDispIDList = array[0..65535] of TDispID;

  TMemberID = TDispID;

  TMemberIDList = array[0..65535] of TMemberID;

  HRefType = DWORD;

  tagTYPEKIND = DWORD;
  TTypeKind = tagTYPEKIND;

  tagTYPEDESC = record
    case Integer of
      VT_PTR:         (ptdesc: IntPtr {^TTypeDesc}; vt: TVarType);
      VT_CARRAY:      (padesc: IntPtr {^TArrayDesc});
      VT_USERDEFINED: (hreftype: HRefType);
  end;
  TTypeDesc = tagTYPEDESC;
  TYPEDESC = TTypeDesc;

  [StructLayout(LayoutKind.Sequential)]
  tagARRAYDESC = record
    tdescElem: TTypeDesc;
    cDims: Word;
    rgbounds: IntPtr; { array[0..0] of TSafeArrayBound }
  end;
  TArrayDesc = tagARRAYDESC;
  ARRAYDESC = TArrayDesc;

  tagIDLDESC = packed record
    dwReserved: Longint;
    wIDLFlags: Word;
  end;
  TIDLDesc = tagIDLDESC;
  IDLDESC = TIDLDesc;

  [StructLayout(LayoutKind.Sequential)]
  tagPARAMDESCEX = record
    cBytes: Longint;
    FourBytePad: Longint;
    varDefaultValue: TVariantArg;
  end;
  TParamDescEx = tagPARAMDESCEX;
  PARAMDESCEX = TParamDescEx;

  tagPARAMDESC = packed record
    pparamdescex: IntPtr; { ^TParamDescEx }
    wParamFlags: Word;
  end;
  TParamDesc = tagPARAMDESC;
  PARAMDESC = TParamDesc;

  tagELEMDESC = record
    tdesc: TTypeDesc;
    case Integer of
      0: (idldesc: TIDLDesc);
      1: (paramdesc: TParamDesc);
  end;
  TElemDesc = tagELEMDESC;
  ELEMDESC = TElemDesc;

  TElemDescList = array[0..65535] of TElemDesc;

  [StructLayout(LayoutKind.Sequential)]
  tagTYPEATTR = record
    guid: TGUID;
    lcid: TLCID;
    dwReserved: Longint;
    memidConstructor: TMemberID;
    memidDestructor: TMemberID;
    lpstrSchema: IntPtr; { POleStr }
    cbSizeInstance: Longint;
    typekind: TTypeKind;
    cFuncs: Word;
    cVars: Word;
    cImplTypes: Word;
    cbSizeVft: Word;
    cbAlignment: Word;
    wTypeFlags: Word;
    wMajorVerNum: Word;
    wMinorVerNum: Word;
    tdescAlias: TTypeDesc;
    idldescType: TIDLDesc;
  end;
  TTypeAttr = tagTYPEATTR;
  TYPEATTR = TTypeAttr;

  [StructLayout(LayoutKind.Sequential)]
  tagDISPPARAMS = record
    rgvarg: IntPtr; { ^TVariantArgList }
    rgdispidNamedArgs: IntPtr; { ^TDispIDList }
    cArgs: Longint;
    cNamedArgs: Longint;
  end;
  TDispParams = tagDISPPARAMS;
  DISPPARAMS = TDispParams;

  TFNDeferredFillIn = function(ExInfo: IntPtr {^TExcepInfo}): HResult;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagEXCEPINFO = record
    wCode: Word;
    wReserved: Word;
    [MarshalAs(UnmanagedType.BStr)]
    bstrSource: WideString;
    [MarshalAs(UnmanagedType.BStr)]
    bstrDescription: WideString;
    [MarshalAs(UnmanagedType.BStr)]
    bstrHelpFile: WideString;
    dwHelpContext: Longint;
    pvReserved: IntPtr;
    pfnDeferredFillIn: TFNDeferredFillIn;
    scode: HResult;
  end;
  TExcepInfo = tagEXCEPINFO;
  EXCEPINFO = TExcepInfo;

  tagFUNCKIND = Longint;
  TFuncKind = tagFUNCKIND;

  tagINVOKEKIND = Longint;
  TInvokeKind = tagINVOKEKIND;

  tagCALLCONV = Longint;
  TCallConv = tagCALLCONV;


  [StructLayout(LayoutKind.Sequential)]
  tagFUNCDESC = record
    memid: TMemberID;
    lprgscode: IntPtr; { ^TResultList }
    lprgelemdescParam: IntPtr; { ^TElemDescList }
    funckind: TFuncKind;
    invkind: TInvokeKind;
    callconv: TCallConv;
    cParams: Smallint;
    cParamsOpt: Smallint;
    oVft: Smallint;
    cScodes: Smallint;
    elemdescFunc: TElemDesc;
    wFuncFlags: Word;
  end;
  TFuncDesc = tagFUNCDESC;
  FUNCDESC = TFuncDesc;


  TVarKind = Longint;


  tagVARDESC = record
    memid: TMemberID;
    lpstrSchema: IntPtr; { POleStr }
    case Integer of
      VAR_PERINSTANCE: (
        oInst: Longint;
        elemdescVar: TElemDesc;
        wVarFlags: Word;
        varkind: TVarKind);
      VAR_CONST: (
        lpvarValue: IntPtr {POleVariant});
  end;
  TVarDesc = tagVARDESC;
  VARDESC = TVarDesc;

{ ICreateTypeInfo interface }

  [ComImport,
  GuidAttribute('00020405-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICreateTypeInfo = interface
    [PreserveSig]
    function SetGuid([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID): HResult;
    [PreserveSig]
    function SetTypeFlags(uTypeFlags: Integer): HResult;
    [PreserveSig]
    function SetDocString([MarshalAs(UnmanagedType.LPWStr)] pstrDoc: string): HResult;
    [PreserveSig]
    function SetHelpContext(dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult;
    [PreserveSig]
    function AddRefTypeInfo([in, MarshalAs(UnmanagedType.Interface)] tinfo: ITypeInfo;
      out reftype: HRefType): HResult;
    [PreserveSig]
    function AddFuncDesc(index: Integer; [in] var funcdesc: TFuncDesc): HResult;
    [PreserveSig]
    function AddImplType(index: Integer; reftype: HRefType): HResult;
    [PreserveSig]
    function SetImplTypeFlags(index: Integer; impltypeflags: Integer): HResult;
    [PreserveSig]
    function SetAlignment(cbAlignment: Word): HResult;
    [PreserveSig]
    function SetSchema([MarshalAs(UnmanagedType.LPWStr)] lpstrSchema: string): HResult;
    [PreserveSig]
    function AddVarDesc(index: Integer; [in] var vardesc: TVarDesc): HResult;
    [PreserveSig]
    function SetFuncAndParamNames(index: Integer;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr)]
      rgszNames: array of string; cNames: Integer): HResult;
    [PreserveSig]
    function SetVarName(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szName: string): HResult;
    [PreserveSig]
    function SetTypeDescAlias([in] var descAlias: TTypeDesc): HResult;
    [PreserveSig]
    function DefineFuncAsDllEntry(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szDllName: string; szProcName: IntPtr): HResult;
    [PreserveSig]
    function SetFuncDocString(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szDocString: string): HResult;
    [PreserveSig]
    function SetVarDocString(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szDocString: string): HResult;
    [PreserveSig]
    function SetFuncHelpContext(index: Integer; dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetVarHelpContext(index: Integer; dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetMops(index: Integer;
      [in, MarshalAs(UnmanagedType.BStr)] bstrMops: string): HResult;
    [PreserveSig]
    function SetTypeIdldesc([in] var idldesc: TIDLDesc): HResult;
    [PreserveSig]
    function LayOut: HResult;
  end;

{ ICreateTypeInfo2 interface }

  [ComImport,
  GuidAttribute('0002040E-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICreateTypeInfo2 = interface { ICreateTypeInfo }
    // ICreateTypeInfo
    [PreserveSig]
    function SetGuid([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID): HResult;
    [PreserveSig]
    function SetTypeFlags(uTypeFlags: Integer): HResult;
    [PreserveSig]
    function SetDocString([MarshalAs(UnmanagedType.LPWStr)] pstrDoc: string): HResult;
    [PreserveSig]
    function SetHelpContext(dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult;
    [PreserveSig]
    function AddRefTypeInfo([in, MarshalAs(UnmanagedType.Interface)] tinfo: ITypeInfo;
      out reftype: HRefType): HResult;
    [PreserveSig]
    function AddFuncDesc(index: Integer; [in] var funcdesc: TFuncDesc): HResult;
    [PreserveSig]
    function AddImplType(index: Integer; reftype: HRefType): HResult;
    [PreserveSig]
    function SetImplTypeFlags(index: Integer; impltypeflags: Integer): HResult;
    [PreserveSig]
    function SetAlignment(cbAlignment: Word): HResult;
    [PreserveSig]
    function SetSchema([MarshalAs(UnmanagedType.LPWStr)] lpstrSchema: string): HResult;
    [PreserveSig]
    function AddVarDesc(index: Integer; [in] var vardesc: TVarDesc): HResult;
    [PreserveSig]
    function SetFuncAndParamNames(index: Integer;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr)]
      rgszNames: array of string; cNames: Integer): HResult;
    [PreserveSig]
    function SetVarName(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szName: string): HResult;
    [PreserveSig]
    function SetTypeDescAlias([in] var descAlias: TTypeDesc): HResult;
    [PreserveSig]
    function DefineFuncAsDllEntry(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szDllName: string; szProcName: IntPtr): HResult;
    [PreserveSig]
    function SetFuncDocString(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szDocString: string): HResult;
    [PreserveSig]
    function SetVarDocString(index: Integer;
      [MarshalAs(UnmanagedType.LPWStr)] szDocString: string): HResult;
    [PreserveSig]
    function SetFuncHelpContext(index: Integer; dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetVarHelpContext(index: Integer; dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetMops(index: Integer;
      [in, MarshalAs(UnmanagedType.BStr)] bstrMops: string): HResult;
    [PreserveSig]
    function SetTypeIdldesc([in] var idldesc: TIDLDesc): HResult;
    [PreserveSig]
    function LayOut: HResult;

    // ICreateTypeInfo2
    [PreserveSig]
    function DeleteFuncDesc(index: Integer): HResult;
    [PreserveSig]
    function DeleteFuncDescByMemId(memid: TMemberID; invKind: TInvokeKind): HResult;
    [PreserveSig]
    function DeleteVarDesc(index: Integer): HResult;
    [PreserveSig]
    function DeleteVarDescByMemId(memid: TMemberID): HResult;
    [PreserveSig]
    function DeleteImplType(index: Integer): HResult;
    [PreserveSig]
    function SetCustData([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      pVarVal: IntPtr): HResult;
    [PreserveSig]
    function SetFuncCustData(index: Integer;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      pVarVal: IntPtr): HResult;
    [PreserveSig]
    function SetParamCustData(indexFunc: Integer; indexParam: Integer;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      pVarVal: IntPtr): HResult;
    [PreserveSig]
    function SetVarCustData(index: Integer;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      pVarVal: IntPtr): HResult;
    [PreserveSig]
    function SetImplTypeCustData(index: Integer;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      pVarVal: IntPtr): HResult;
    [PreserveSig]
    function SetHelpStringContext(dwHelpStringContext: Longint): HResult;
    [PreserveSig]
    function SetFuncHelpStringContext(index: Integer;
      dwHelpStringContext: Longint): HResult;
    [PreserveSig]
    function SetVarHelpStringContext(index: Integer;
       dwHelpStringContext: Longint): HResult;
    [PreserveSig]
    function Invalidate: HResult;
    [PreserveSig]
    function SetName([MarshalAs(UnmanagedType.LPWStr)] szName: string): HResult;
  end;

{ ICreateTypeLib interface }

  [ComImport,
  GuidAttribute('00020406-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICreateTypeLib = interface
    [PreserveSig]
    function CreateTypeInfo([MarshalAs(UnmanagedType.LPWStr)] szName: string;
      tkind: TTypeKind; out ictinfo: ICreateTypeInfo): HResult;
    [PreserveSig]
    function SetName([MarshalAs(UnmanagedType.LPWStr)] szName: string): HResult;
    [PreserveSig]
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult;
    [PreserveSig]
    function SetGuid([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID): HResult;
    [PreserveSig]
    function SetDocString([MarshalAs(UnmanagedType.LPWStr)] szDoc: string): HResult;
    [PreserveSig]
    function SetHelpFileName([MarshalAs(UnmanagedType.LPWStr)] szHelpFileName: string): HResult;
    [PreserveSig]
    function SetHelpContext(dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetLcid(lcid: TLCID): HResult;
    [PreserveSig]
    function SetLibFlags(uLibFlags: Integer): HResult;
    [PreserveSig]
    function SaveAllChanges: HResult;
  end;

  [ComImport,
  GuidAttribute('0002040F-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICreateTypeLib2 = interface { ICreateTypeLib }
    // ICreateTypeLib
    [PreserveSig]
    function CreateTypeInfo([MarshalAs(UnmanagedType.LPWStr)] szName: string;
      tkind: TTypeKind; out ictinfo: ICreateTypeInfo): HResult;
    [PreserveSig]
    function SetName([MarshalAs(UnmanagedType.LPWStr)] szName: string): HResult;
    [PreserveSig]
    function SetVersion(wMajorVerNum: Word; wMinorVerNum: Word): HResult;
    [PreserveSig]
    function SetGuid([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID): HResult;
    [PreserveSig]
    function SetDocString([MarshalAs(UnmanagedType.LPWStr)] szDoc: string): HResult;
    [PreserveSig]
    function SetHelpFileName([MarshalAs(UnmanagedType.LPWStr)] szHelpFileName: string): HResult;
    [PreserveSig]
    function SetHelpContext(dwHelpContext: Longint): HResult;
    [PreserveSig]
    function SetLcid(lcid: TLCID): HResult;
    [PreserveSig]
    function SetLibFlags(uLibFlags: Integer): HResult;
    [PreserveSig]
    function SaveAllChanges: HResult;

    // ICreateTypeLib2
    [PreserveSig]
    function DeleteTypeInfo([MarshalAs(UnmanagedType.LPWStr)] szName: string): HResult;
    [PreserveSig]
    function SetCustData([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      pVarVal: IntPtr): HResult;
    [PreserveSig]
    function SetHelpStringContext(dwHelpStringContext: Longint): HResult;
    [PreserveSig]
    function SetHelpStringDll([MarshalAs(UnmanagedType.LPWStr)] szFileName: string): HResult;
  end;

{ IEnumVariant interface }

  [ComImport,
  GuidAttribute('00020404-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumVariant = interface
    [PreserveSig]       
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of IntPtr; out pceltFetched: Longint): HResult;
    [PreserveSig]       
    function Skip(celt: LongWord): HResult;
    [PreserveSig]       
    function Reset: HResult;
    [PreserveSig]       
    function Clone(out Enum: IEnumVariant): HResult;
  end;

{ ITypeComp interface }

  TDescKind = Longint;

  tagBINDPTR = record
    case Integer of
      0: (lpfuncdesc: IntPtr {^TFuncDesc});
      1: (lpvardesc: IntPtr {^TVarDesc});
      2: (lptcomp: IntPtr {ITypeComp});
  end;
  TBindPtr = tagBINDPTR;
  BINDPTR = TBindPtr;

  [ComImport,
  GuidAttribute('00020403-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITypeComp = interface
    [PreserveSig]
    function Bind([MarshalAs(UnmanagedType.LPWStr)] szName: string;
      lHashVal: Longint; wflags: Word;
      out tinfo: ITypeInfo; out desckind: TDescKind;
      out bindptr: TBindPtr): HResult;
    [PreserveSig]
    function BindType([MarshalAs(UnmanagedType.LPWStr)] szName: string;
      lHashVal: Longint; out tinfo: ITypeInfo; out tcomp: ITypeComp): HResult;
  end;

{ ITypeInfo interface }

  [ComImport,
  GuidAttribute('00020401-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITypeInfo = interface
    [PreserveSig]
    function GetTypeAttr(out ptypeattr: IntPtr): HResult;
    [PreserveSig]
    function GetTypeComp(out tcomp: ITypeComp): HResult;
    [PreserveSig]
    function GetFuncDesc(index: Integer; out pfuncdesc: IntPtr): HResult;
    [PreserveSig]
    function GetVarDesc(index: Integer; out pvardesc: IntPtr): HResult;
    [PreserveSig]
    function GetNames(memid: TMemberID;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 2)]
      rgbstrNames: array of string;
      cMaxNames: Integer; out cNames: Integer): HResult;
    [PreserveSig]
    function GetRefTypeOfImplType(index: Integer; out reftype: HRefType): HResult;
    [PreserveSig]
    function GetImplTypeFlags(index: Integer; out impltypeflags: Integer): HResult;
    [PreserveSig]
    function GetIDsOfNames(
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr, SizeParamIndex = 1)]
      rgpszNames: array of string;
      cNames: Integer;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      rgmemid: array of TMemberID): HResult;
    [PreserveSig]
    function Invoke([MarshalAs(UnmanagedType.IUnknown)] pvInstance: TObject;
      memid: TMemberID; flags: Word; var dispParams: TDispParams;
      out varResult: TObject; out excepInfo: TExcepInfo; out argErr: Integer): HResult;
    [PreserveSig]
    function GetDocumentation(memid: TMemberID; out pbstrName: string;
      out pbstrDocString: string; out pdwHelpContext: Longint;
      out pbstrHelpFile: WideString): HResult;
    [PreserveSig]
    function GetDllEntry(memid: TMemberID; invkind: TInvokeKind;
      out bstrDllName, bstrName: string; out wOrdinal: Word): HResult;
    [PreserveSig]
    function GetRefTypeInfo(reftype: HRefType; out tinfo: ITypeInfo): HResult;
    [PreserveSig]
    function AddressOfMember(memid: TMemberID; invkind: TInvokeKind;
      out ppv: IntPtr): HResult;
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      var iid: TIID; [MarshalAs(UnmanagedType.IUnknown)] out vObj): HResult;
    [PreserveSig]
    function GetMops(memid: TMemberID; out bstrMops: WideString): HResult;
    [PreserveSig]
    function GetContainingTypeLib(out tlib: ITypeLib; out pindex: Integer): HResult;
    [PreserveSig]
    procedure ReleaseTypeAttr(ptypeattr: IntPtr);
    [PreserveSig]
    procedure ReleaseFuncDesc(pfuncdesc: IntPtr);
    [PreserveSig]
    procedure ReleaseVarDesc(pvardesc: IntPtr);
  end;

{ ITypeLib interface }

  TSysKind = Longint;

  [StructLayout(LayoutKind.Sequential)]
  tagTLIBATTR = record
    guid: TGUID;
    lcid: TLCID;
    syskind: TSysKind;
    wMajorVerNum: Word;
    wMinorVerNum: Word;
    wLibFlags: Word;
  end;
  TTLibAttr = tagTLIBATTR;
  TLIBATTR = TTLibAttr;


  TTypeInfoList = array[0..65535] of ITypeInfo;

  [ComImport,
  GuidAttribute('00020402-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITypeLib = interface
    [PreserveSig]
    function GetTypeInfoCount: Integer;
    [PreserveSig]
    function GetTypeInfo(index: Integer; out tinfo: ITypeInfo): HResult;
    [PreserveSig]
    function GetTypeInfoType(index: Integer; out tkind: TTypeKind): HResult;
    [PreserveSig]
    function GetTypeInfoOfGuid([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out tinfo: ITypeInfo): HResult;
    [PreserveSig]
    function GetLibAttr(out ptlibattr: IntPtr): HResult;
    [PreserveSig]
    function GetTypeComp(out tcomp: ITypeComp): HResult;
    [PreserveSig]
    function GetDocumentation(index: Integer; out pbstrName: string;
      out pbstrDocString: string; out pdwHelpContext: Longint;
      out pbstrHelpFile: string): HResult;
    [PreserveSig]
    function IsName([MarshalAs(UnmanagedType.LPWStr)] szNameBuf: string;
      lHashVal: Longint; out fName: BOOL): HResult;
    [PreserveSig]
    function FindName([MarshalAs(UnmanagedType.LPWStr)] szNameBuf: string;
      lHashVal: Longint;
      [out, MarshalAs(UnmanagedType.LPArray)] rgptinfo: array of ITypeLib;
      [out, MarshalAs(UnmanagedType.LPArray)] rgmemid: array of TMemberID;
      out pcFound: Word): HResult;
    [PreserveSig]
    procedure ReleaseTLibAttr(ptlibattr: IntPtr);
  end;

{ ITypeLib2 interface }

  [StructLayout(LayoutKind.Sequential)]
  tagCUSTDATAITEM = record
    guid: TGUID;
    varValue: TVariantArg;
   end;
  TCustDataItem = tagCUSTDATAITEM;
  CUSTDATAITEM = TCustDataItem;

  TCustDataItemList = array[0..65535] of TCustDataItem;

  [StructLayout(LayoutKind.Sequential)]
  tagCUSTDATA = record
    cCustData: DWORD;
    prgCustData: IntPtr; { ^TCustDataItemList }
  end;
  TCustData = tagCUSTDATA;
  CUSTDATA = TCustData;

  [ComImport,
  GuidAttribute('00020411-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITypeLib2 = interface { ITypeLib }
    // ITypeLib
    [PreserveSig]
    function GetTypeInfoCount: Integer;
    [PreserveSig]
    function GetTypeInfo(index: Integer; out tinfo: ITypeInfo): HResult;
    [PreserveSig]
    function GetTypeInfoType(index: Integer; out tkind: TTypeKind): HResult;
    [PreserveSig]
    function GetTypeInfoOfGuid([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out tinfo: ITypeInfo): HResult;
    [PreserveSig]
    function GetLibAttr(out ptlibattr: IntPtr): HResult;
    [PreserveSig]
    function GetTypeComp(out tcomp: ITypeComp): HResult;
    [PreserveSig]
    function GetDocumentation(index: Integer; out pbstrName: string;
      out pbstrDocString: string; out pdwHelpContext: Longint;
      out pbstrHelpFile: string): HResult;
    [PreserveSig]
    function IsName([MarshalAs(UnmanagedType.LPWStr)] szNameBuf: string;
      lHashVal: Longint; out fName: BOOL): HResult;
    [PreserveSig]
    function FindName([MarshalAs(UnmanagedType.LPWStr)] szNameBuf: string;
      lHashVal: Longint;
      [out, MarshalAs(UnmanagedType.LPArray)] rgptinfo: array of ITypeLib;
      [out, MarshalAs(UnmanagedType.LPArray)] rgmemid: array of TMemberID;
      out pcFound: Word): HResult;
    [PreserveSig]
    procedure ReleaseTLibAttr(ptlibattr: IntPtr);

    // ITypeLib2
    [PreserveSig]
    function GetCustData([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out pVarVal: TObject): HResult;
    [PreserveSig]
    function GetLibStatistics(pcUniqueNames: IntPtr;
      out pcchUniqueNames: LongInt): HResult;
    [PreserveSig]
    function GetDocumentation2(index: Integer; lcid: TLCID;
      [MarshalAs(UnmanagedType.BStr)] out pbstrHelpString: string;
      pdwHelpStringContext: IntPtr; pbstrHelpStringDll: IntPtr): HResult;
    [PreserveSig]
    function GetAllCustData(out pCustData: TCustData): HResult;
  end;

  [ComImport,
  GuidAttribute('00020412-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITypeInfo2 = interface { ITypeInfo }
    // ITypeInfo
    [PreserveSig]
    function GetTypeAttr(out ptypeattr: IntPtr): HResult;
    [PreserveSig]
    function GetTypeComp(out tcomp: ITypeComp): HResult;
    [PreserveSig]
    function GetFuncDesc(index: Integer; out pfuncdesc: IntPtr): HResult;
    [PreserveSig]
    function GetVarDesc(index: Integer; out pvardesc: IntPtr): HResult;
    [PreserveSig]
    function GetNames(memid: TMemberID;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 2)]
      rgbstrNames: array of string;
      cMaxNames: Integer; out cNames: Integer): HResult;
    [PreserveSig]
    function GetRefTypeOfImplType(index: Integer; out reftype: HRefType): HResult;
    [PreserveSig]
    function GetImplTypeFlags(index: Integer; out impltypeflags: Integer): HResult;
    [PreserveSig]
    function GetIDsOfNames(
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr, SizeParamIndex = 1)]
      rgpszNames: array of string;
      cNames: Integer;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      rgmemid: array of TMemberID): HResult;
    [PreserveSig]
    function Invoke([MarshalAs(UnmanagedType.IUnknown)] pvInstance: TObject;
      memid: TMemberID; flags: Word; var dispParams: TDispParams;
      out varResult: TObject; out excepInfo: TExcepInfo; out argErr: Integer): HResult;
    [PreserveSig]
    function GetDocumentation(memid: TMemberID; out pbstrName: string;
      out pbstrDocString: string; out pdwHelpContext: Longint;
      out pbstrHelpFile: WideString): HResult;
    [PreserveSig]
    function GetDllEntry(memid: TMemberID; invkind: TInvokeKind;
      out bstrDllName, bstrName: string; out wOrdinal: Word): HResult;
    [PreserveSig]
    function GetRefTypeInfo(reftype: HRefType; out tinfo: ITypeInfo): HResult;
    [PreserveSig]
    function AddressOfMember(memid: TMemberID; invkind: TInvokeKind;
      out ppv: IntPtr): HResult;
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      var iid: TIID; [MarshalAs(UnmanagedType.IUnknown)] out vObj): HResult;
    [PreserveSig]
    function GetMops(memid: TMemberID; out bstrMops: WideString): HResult;
    [PreserveSig]
    function GetContainingTypeLib(out tlib: ITypeLib; out pindex: Integer): HResult;
    [PreserveSig]
    procedure ReleaseTypeAttr(ptypeattr: IntPtr);
    [PreserveSig]
    procedure ReleaseFuncDesc(pfuncdesc: IntPtr);
    [PreserveSig]
    procedure ReleaseVarDesc(pvardesc: IntPtr);

    // ITypeInfo2
    [PreserveSig]
    function GetTypeKind(out pTypeKind: TTypeKind): HResult;
    [PreserveSig]
    function GetTypeFlags(out pTypeFlags: LongInt): HResult;
    [PreserveSig]
    function GetFuncIndexOfMemId(memid: TMemberID; invKind: TInvokeKind;
      out pFuncIndex: UINT): HResult;
    [PreserveSig]
    function GetVarIndexOfMemId(memid: TMemberID; out pVarIndex: UINT): HResult;
    [PreserveSig]
    function GetCustData([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out pVarVal: TObject): HResult;
    [PreserveSig]
    function GetFuncCustData(index: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out pVarVal: TObject): HResult;
    [PreserveSig]
    function GetParamCustData(indexFunc, indexParam: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out pVarVal: TObject): HResult;
    [PreserveSig]
    function GetVarCustData(index: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out pVarVal: TObject): HResult;
    [PreserveSig]
    function GetImplTypeCustData(index: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
      out pVarVal: TObject): HResult;
    [PreserveSig]
    function GetDocumentation2(memid: TMemberID; lcid: TLCID;
      pbstrHelpString: string; pdwHelpStringContext: IntPtr;
      pbstrHelpStringDll: string): HResult;
    [PreserveSig]
    function GetAllCustData(out pCustData: TCustData): HResult;
    [PreserveSig]
    function GetAllFuncCustData(index: UINT; out pCustData: TCustData): HResult;
    [PreserveSig]
    function GetAllParamCustData(indexFunc, indexParam: UINT;
      out pCustData: TCustData): HResult;
    [PreserveSig]
    function GetAllVarCustData(index: UINT; out pCustData: TCustData): HResult;
    [PreserveSig]
    function GetAllImplTypeCustData(index: UINT; out pCustData: TCustData): HResult;
  end;

{ IErrorInfo interface }

  [ComImport,
  GuidAttribute('1CF2B120-547D-101B-8E65-08002B2BD119'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IErrorInfo = interface
    [PreserveSig]
    function GetGUID(out guid: TGUID): HResult;
    [PreserveSig]
    function GetSource([in, out, MarshalAs(UnmanagedType.BStr)]
      var bstrSource: string): HResult;
    [PreserveSig]
    function GetDescription([in, out, MarshalAs(UnmanagedType.BStr)]
      var bstrDescription: string): HResult;
    [PreserveSig]
    function GetHelpFile([in, out, MarshalAs(UnmanagedType.BStr)]
      var bstrHelpFile: string): HResult;
    [PreserveSig]
    function GetHelpContext(out dwHelpContext: Longint): HResult;
  end;

{ ICreateErrorInfo interface }

  [ComImport,
  GuidAttribute('22F03340-547D-101B-8E65-08002B2BD119'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICreateErrorInfo = interface
    [PreserveSig]
    function SetGUID([MarshalAs(UnmanagedType.LPStruct)] guid: TGUID): HResult;
    [PreserveSig]
    function SetSource([MarshalAs(UnmanagedType.LPWStr)] szSource: string): HResult;
    [PreserveSig]
    function SetDescription([MarshalAs(UnmanagedType.LPWStr)] szDescription: string): HResult;
    [PreserveSig]
    function SetHelpFile([MarshalAs(UnmanagedType.LPWStr)] szHelpFile: string): HResult;
    [PreserveSig]
    function SetHelpContext(dwHelpContext: Longint): HResult;
  end;

{ ISupportErrorInfo interface }

  [ComImport,
  GuidAttribute('DF0B3D60-548F-101B-8E65-08002B2BD119'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISupportErrorInfo = interface
    [PreserveSig]
    function InterfaceSupportsErrorInfo(
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID): HResult;
  end;

{ IEnumOleVerb interface }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagOLEVERB = record
    lVerb: Longint;
    [MarshalAs(UnmanagedType.LPWStr)]
    lpszVerbName: string;
    fuFlags: Longint;
    grfAttribs: Longint;
  end;
  TOleVerb = tagOLEVERB;
  OLEVERB = TOleVerb;

  [ComImport,
  GuidAttribute('00000104-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumOLEVERB = interface
    [PreserveSig]
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of TOleVerb; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out enm: IEnumOleVerb): HResult;
  end;

{ from OLEAUTO.H }
{ IDispatch implementation support }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagPARAMDATA = record
    [MarshalAs(UnmanagedType.LPWStr)]
    szName: string;    
    vt: TVarType;
  end;
  TParamData = tagPARAMDATA;
  PARAMDATA = TParamData;


  TParamDataList = array[0..65535] of TParamData;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagMETHODDATA = record
    [MarshalAs(UnmanagedType.LPWStr)]
    szName: string;     
    ppdata: IntPtr; { ^TParamDataList }
    dispid: TDispID;
    iMeth: Integer;
    cc: TCallConv;
    cArgs: Integer;
    wFlags: Word;
    vtReturn: TVarType;
  end;
  TMethodData = tagMETHODDATA;
  METHODDATA = TMethodData;


  TMethodDataList = array[0..65535] of TMethodData;

  [StructLayout(LayoutKind.Sequential)]
  tagINTERFACEDATA = record
    pmethdata: IntPtr; { ^TMethodDataList }
    cMembers: Integer;
  end;
  TInterfaceData = tagINTERFACEDATA;
  INTERFACEDATA = TInterfaceData;

  tagREGKIND = (REGKIND_DEFAULT, REGKIND_REGISTER, REGKIND_NONE);
  TRegKind = tagREGKIND;

{ from OLEIDL.H }
{ IOleAdviseHolder interface }

  [ComImport,
  GuidAttribute('00000111-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleAdviseHolder = interface
    [PreserveSig]
    function Advise([in, MarshalAs(UnmanagedType.Interface)] advise: IAdviseSink;
      out dwConnection: Longint): HResult;
    [PreserveSig]
    function Unadvise(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumAdvise(out enumAdvise: IEnumStatData): HResult;
    [PreserveSig]
    function SendOnRename([in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker): HResult;
    [PreserveSig]
    function SendOnSave: HResult;
    [PreserveSig]
    function SendOnClose: HResult;
  end;

{ IOleCache interface }

  [ComImport,
  GuidAttribute('0000011E-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleCache = interface
    [PreserveSig]
    function Cache([in] var formatetc: TFormatEtc; advf: Longint;
      out dwConnection: Longint): HResult;
    [PreserveSig]
    function Uncache(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumCache(out enumStatData: IEnumStatData): HResult;
    [PreserveSig]
    function InitCache([in, MarshalAs(UnmanagedType.Interface)]
      dataObject: IDataObject): HResult;
    [PreserveSig]
    function SetData([in] var formatetc: TFormatEtc; [in] var medium: TStgMedium;
      fRelease: BOOL): HResult;
  end;

{ IOleCache2 interface }

  [ComImport,
  GuidAttribute('00000128-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleCache2 = interface { IOleCache }
    // IOleCache
    [PreserveSig]
    function Cache([in] var formatetc: TFormatEtc; advf: Longint;
      out dwConnection: Longint): HResult;
    [PreserveSig]
    function Uncache(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumCache(out enumStatData: IEnumStatData): HResult;
    [PreserveSig]
    function InitCache([in, MarshalAs(UnmanagedType.Interface)]
      dataObject: IDataObject): HResult;
    [PreserveSig]
    function SetData([in] var formatetc: TFormatEtc; [in] var medium: TStgMedium;
      fRelease: BOOL): HResult;

    // IOleCache2
    [PreserveSig]
    function UpdateCache([in, MarshalAs(UnmanagedType.Interface)] dataObject: IDataObject;
      grfUpdf: Longint; pReserved: IntPtr): HResult;
    [PreserveSig]
    function DiscardCache(dwDiscardOptions: Longint): HResult;
  end;

{ IOleCacheControl interface }

  [ComImport,
  GuidAttribute('00000129-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleCacheControl = interface
    [PreserveSig]
    function OnRun([in, MarshalAs(UnmanagedType.Interface)] dataObject: IDataObject): HResult;
    [PreserveSig]
    function OnStop: HResult;
  end;

{ IParseDisplayName interface }

  [ComImport,
  GuidAttribute('0000011A-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IParseDisplayName = interface
    [PreserveSig]
    function ParseDisplayName([in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx;
      [MarshalAs(UnmanagedType.LPWStr)] pszDisplayName: string;
      out chEaten: Longint; out mkOut: IMoniker): HResult;
  end;

{ IOleContainer interface }

  [ComImport,
  GuidAttribute('0000011B-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleContainer = interface { IParseDisplayName }
    // IParseDisplayName
    [PreserveSig]
    function ParseDisplayName([in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx;
      [MarshalAs(UnmanagedType.LPWStr)] pszDisplayName: string;
      out chEaten: Longint; out mkOut: IMoniker): HResult;

    // IOleContainer
    [PreserveSig]
    function EnumObjects(grfFlags: Longint; out Enum: IEnumUnknown): HResult;
    [PreserveSig]
    function LockContainer(fLock: BOOL): HResult;
  end;

{ IOleClientSite interface }

  [ComImport,
  GuidAttribute('00000118-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleClientSite = interface
    [PreserveSig]
    function SaveObject: HResult;
    [PreserveSig]
    function GetMoniker(dwAssign: Longint; dwWhichMoniker: Longint;
      out mk: IMoniker): HResult;
    [PreserveSig]
    function GetContainer(out container: IOleContainer): HResult;
    [PreserveSig]
    function ShowObject: HResult;
    [PreserveSig]
    function OnShowWindow(fShow: BOOL): HResult;
    [PreserveSig]
    function RequestNewObjectLayout: HResult;
  end;

{ IOleObject interface }

  [ComImport,
  GuidAttribute('00000112-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleObject = interface
    [PreserveSig]
    function SetClientSite([in, MarshalAs(UnmanagedType.Interface)] clientSite: IOleClientSite): HResult;
    [PreserveSig]
    function GetClientSite(out clientSite: IOleClientSite): HResult;
    [PreserveSig]
    function SetHostNames([MarshalAs(UnmanagedType.LPWStr)] szContainerApp: string;
      [MarshalAs(UnmanagedType.LPWStr)] szContainerObj: string): HResult;
    [PreserveSig]
    function Close(dwSaveOption: Longint): HResult;
    [PreserveSig]
    function SetMoniker(dwWhichMoniker: Longint;
      [in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker): HResult;
    [PreserveSig]
    function GetMoniker(dwAssign: Longint; dwWhichMoniker: Longint; out mk: IMoniker): HResult;
    [PreserveSig]
    function InitFromData([in, MarshalAs(UnmanagedType.Interface)] dataObject: IDataObject;
      fCreation: BOOL; dwReserved: Longint): HResult;
    [PreserveSig]
    function GetClipboardData(dwReserved: Longint; out dataObject: IDataObject): HResult;
    [PreserveSig]
    function DoVerb(iVerb: Longint; [in] var msg: TMsg;
      [in, MarshalAs(UnmanagedType.Interface)] activeSite: IOleClientSite;
      lindex: Longint; hwndParent: HWND; [in] var posRect: TRect): HResult;
    [PreserveSig]
    function EnumVerbs(out enumOleVerb: IEnumOleVerb): HResult;
    [PreserveSig]
    function Update: HResult;
    [PreserveSig]
    function IsUpToDate: HResult;
    [PreserveSig]
    function GetUserClassID(out clsid: TCLSID): HResult;
    [PreserveSig]
    function GetUserType(dwFormOfType: Longint;
      [MarshalAs(UnmanagedType.LPWStr)] out pszUserType: string): HResult;
    [PreserveSig]
    function SetExtent(dwDrawAspect: Longint; [in] var size: TPoint): HResult;
    [PreserveSig]
    function GetExtent(dwDrawAspect: Longint; out size: TPoint): HResult;
    [PreserveSig]
    function Advise([in, MarshalAs(UnmanagedType.Interface)] advSink: IAdviseSink;
      out dwConnection: Longint): HResult;
    [PreserveSig]
    function Unadvise(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumAdvise(out enumAdvise: IEnumStatData): HResult;
    [PreserveSig]
    function GetMiscStatus(dwAspect: Longint; out dwStatus: Longint): HResult;
    [PreserveSig]
    function SetColorScheme([in] var logpal: TLogPalette): HResult;
  end;

{ OLE types }

  [StructLayout(LayoutKind.Sequential)]
  tagOBJECTDESCRIPTOR = record
    cbSize: Longint;
    clsid: TCLSID;
    dwDrawAspect: Longint;
    size: TPoint;
    point: TPoint;
    dwStatus: Longint;
    dwFullUserTypeName: Longint;
    dwSrcOfCopy: Longint;
  end;
  TObjectDescriptor = tagOBJECTDESCRIPTOR;
  OBJECTDESCRIPTOR = TObjectDescriptor;


  TLinkSrcDescriptor = TObjectDescriptor;

{ IOleWindow interface }

  [ComImport,
  GuidAttribute('00000114-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleWindow = interface
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;
  end;

{ IOleLink interface }

  [ComImport,
  GuidAttribute('0000011D-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleLink = interface
    [PreserveSig]       
    function SetUpdateOptions(dwUpdateOpt: Longint): HResult;
    [PreserveSig]       
    function GetUpdateOptions(out dwUpdateOpt: Longint): HResult;
    [PreserveSig]       
    function SetSourceMoniker([in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker;
      [MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID): HResult;
    [PreserveSig]       
    function GetSourceMoniker(out mk: IMoniker): HResult;
    [PreserveSig]       
    function SetSourceDisplayName([MarshalAs(UnmanagedType.LPWStr)]
      pszDisplayName: string): HResult;
    [PreserveSig]       
    function GetSourceDisplayName([MarshalAs(UnmanagedType.LPWStr)]
      out pszDisplayName: string): HResult;
    [PreserveSig]       
    function BindToSource(bindflags: Longint;
      [in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx): HResult;
    [PreserveSig]       
    function BindIfRunning: HResult;
    [PreserveSig]       
    function GetBoundSource([MarshalAs(UnmanagedType.IUnknown)] out unk): HResult;
    [PreserveSig]       
    function UnbindSource: HResult;
    [PreserveSig]       
    function Update([in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx): HResult;
  end;

{ IOleItemContainer interface }

  [ComImport,
  GuidAttribute('0000011C-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleItemContainer = interface { IOleContainer }
    // IParseDisplayName
    [PreserveSig]
    function ParseDisplayName([in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx;
      [MarshalAs(UnmanagedType.LPWStr)] pszDisplayName: string;
      out chEaten: Longint; out mkOut: IMoniker): HResult;

    // IOleContainer
    [PreserveSig]
    function EnumObjects(grfFlags: Longint; out Enum: IEnumUnknown): HResult;
    [PreserveSig]
    function LockContainer(fLock: BOOL): HResult;

    // IOleItemContainer
    [PreserveSig]
    function GetObject([MarshalAs(UnmanagedType.LPWStr)] pszItem: string;
      dwSpeedNeeded: Longint;
      [in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out vObject): HResult;
    [PreserveSig]
    function GetObjectStorage([MarshalAs(UnmanagedType.LPWStr)] pszItem: string;
      [in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out vStorage): HResult;
    [PreserveSig]
    function IsRunning([MarshalAs(UnmanagedType.LPWStr)] pszItem: string): HResult;
  end;

{ IOleInPlaceUIWindow interface }

  [ComImport,
  GuidAttribute('00000115-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceUIWindow = interface { IOleWindow }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceUIWindow
    [PreserveSig]
    function GetBorder(out rectBorder: TRect): HResult;
    [PreserveSig]
    function RequestBorderSpace([in] var borderwidths: TRect): HResult;
    [PreserveSig]
    function SetBorderSpace(pborderwidths: IntPtr): HResult;
    [PreserveSig]
    function SetActiveObject([in, MarshalAs(UnmanagedType.Interface)]
      activeObject: IOleInPlaceActiveObject;
      [MarshalAs(UnmanagedType.LPWStr)] pszObjName: string): HResult;
  end;

{ IOleInPlaceActiveObject interface }

  [ComImport,
  GuidAttribute('00000117-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceActiveObject = interface { IOleWindow }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceActiveObject
    [PreserveSig]
    function TranslateAccelerator(var msg: TMsg): HResult;
    [PreserveSig]
    function OnFrameWindowActivate(fActivate: BOOL): HResult;
    [PreserveSig]
    function OnDocWindowActivate(fActivate: BOOL): HResult;
    [PreserveSig]
    function ResizeBorder([in] var rcBorder: TRect;
      [in, MarshalAs(UnmanagedType.Interface)] uiWindow: IOleInPlaceUIWindow;
      fFrameWindow: BOOL): HResult;
    [PreserveSig]
    function EnableModeless(fEnable: BOOL): HResult;
  end;

{ IOleInPlaceFrame interface }

  [StructLayout(LayoutKind.Sequential)]
  tagOIFI = record
    cb: Integer;
    fMDIApp: BOOL;
    hwndFrame: HWND;
    haccel: HAccel;
    cAccelEntries: Integer;
  end;
  TOleInPlaceFrameInfo = tagOIFI;
  OLEINPLACEFRAMEINFO = TOleInPlaceFrameInfo;

  [StructLayout(LayoutKind.Sequential)]
  tagOleMenuGroupWidths = record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 6)]
    width: array[0..5] of Longint;
  end;
  TOleMenuGroupWidths = tagOleMenuGroupWidths;
  OLEMENUGROUPWIDTHS = TOleMenuGroupWidths;


  [ComImport,
  GuidAttribute('00000116-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceFrame = interface { IOleInPlaceUIWindow }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceUIWindow
    [PreserveSig]
    function GetBorder(out rectBorder: TRect): HResult;
    [PreserveSig]
    function RequestBorderSpace([in] var borderwidths: TRect): HResult;
    [PreserveSig]
    function SetBorderSpace(pborderwidths: IntPtr): HResult;
    [PreserveSig]
    function SetActiveObject([in, MarshalAs(UnmanagedType.Interface)]
      activeObject: IOleInPlaceActiveObject;
      [MarshalAs(UnmanagedType.LPWStr)] pszObjName: string): HResult;

    // IOleInPlaceFrame
    [PreserveSig]
    function InsertMenus(hmenuShared: HMenu;
      var menuWidths: TOleMenuGroupWidths): HResult;
    [PreserveSig]
    function SetMenu(hmenuShared: HMenu; holemenu: HMenu;
      hwndActiveObject: HWnd): HResult;
    [PreserveSig]
    function RemoveMenus(hmenuShared: HMenu): HResult;
    [PreserveSig]
    function SetStatusText([MarshalAs(UnmanagedType.LPWStr)] pszStatusText: string): HResult;
    [PreserveSig]
    function EnableModeless(fEnable: BOOL): HResult;
    [PreserveSig]
    function TranslateAccelerator(var msg: TMsg; wID: Word): HResult;
  end;

{ IOleInPlaceObject interface }

  [ComImport,
  GuidAttribute('00000113-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceObject = interface { IOleWindow }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceObject
    [PreserveSig]
    function InPlaceDeactivate: HResult;
    [PreserveSig]
    function UIDeactivate: HResult;
    [PreserveSig]
    function SetObjectRects([in] var rcPosRect: TRect;
      [in] var rcClipRect: TRect): HResult;
    [PreserveSig]
    function ReactivateAndUndo: HResult;
  end;



{ IOleInPlaceSite interface }

  [ComImport,
  GuidAttribute('00000119-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceSite = interface { IOleWindow }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceSite
    [PreserveSig]
    function CanInPlaceActivate: HResult;
    [PreserveSig]
    function OnInPlaceActivate: HResult;
    [PreserveSig]
    function OnUIActivate: HResult;
    [PreserveSig]
    function GetWindowContext(out frame: IOleInPlaceFrame;
      out doc: IOleInPlaceUIWindow; out rcPosRect: TRect;
      out rcClipRect: TRect; out frameInfo: TOleInPlaceFrameInfo): HResult;
    [PreserveSig]
    function Scroll(scrollExtent: TPoint): HResult;
    [PreserveSig]
    function OnUIDeactivate(fUndoable: BOOL): HResult;
    [PreserveSig]
    function OnInPlaceDeactivate: HResult;
    [PreserveSig]
    function DiscardUndoState: HResult;
    [PreserveSig]
    function DeactivateAndUndo: HResult;
    [PreserveSig]
    function OnPosRectChange([in] var rcPosRect: TRect): HResult;
  end;

{ IViewObject interface }

  TContinueFunc = function(dwContinue: Longint): BOOL;

  [ComImport,
  GuidAttribute('0000010D-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewObject = interface
    [PreserveSig]
    function Draw(dwDrawAspect: Longint; lindex: Longint; pvAspect: IntPtr;
      ptd: IntPtr; hicTargetDev: HDC; hdcDraw: HDC;
      prcBounds: IntPtr; prcWBounds: IntPtr; fnContinue: TContinueFunc;
      dwContinue: Longint): HResult;
    [PreserveSig]
    function GetColorSet(dwDrawAspect: Longint; lindex: Longint;
      pvAspect: IntPtr; ptd: IntPtr; hicTargetDev: HDC;
      out colorSet: IntPtr): HResult;
    [PreserveSig]
    function Freeze(dwDrawAspect: Longint; lindex: Longint; pvAspect: IntPtr;
      out dwFreeze: Longint): HResult;
    [PreserveSig]
    function Unfreeze(dwFreeze: Longint): HResult;
    [PreserveSig]
    function SetAdvise(aspects: Longint; advf: Longint;
      [in, MarshalAs(UnmanagedType.Interface)] advSink: IAdviseSink): HResult;
    [PreserveSig]
    function GetAdvise(pAspects: IntPtr; pAdvf: IntPtr;
      out advSink: IAdviseSink): HResult;
  end;

{ IViewObject2 interface }

  [ComImport,
  GuidAttribute('00000127-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IViewObject2 = interface { IViewObject }
    // IViewObject
    [PreserveSig]
    function Draw(dwDrawAspect: Longint; lindex: Longint; pvAspect: IntPtr;
      ptd: IntPtr; hicTargetDev: HDC; hdcDraw: HDC;
      prcBounds: IntPtr; prcWBounds: IntPtr; fnContinue: TContinueFunc;
      dwContinue: Longint): HResult;
    [PreserveSig]
    function GetColorSet(dwDrawAspect: Longint; lindex: Longint;
      pvAspect: IntPtr; ptd: IntPtr; hicTargetDev: HDC;
      out colorSet: IntPtr): HResult;
    [PreserveSig]
    function Freeze(dwDrawAspect: Longint; lindex: Longint; pvAspect: IntPtr;
      out dwFreeze: Longint): HResult;
    [PreserveSig]
    function Unfreeze(dwFreeze: Longint): HResult;
    [PreserveSig]
    function SetAdvise(aspects: Longint; advf: Longint;
      [in, MarshalAs(UnmanagedType.Interface)] advSink: IAdviseSink): HResult;
    [PreserveSig]
    function GetAdvise(pAspects: IntPtr; pAdvf: IntPtr;
      out advSink: IAdviseSink): HResult;

    // IViewObject2
    [PreserveSig]
    function GetExtent(dwDrawAspect: Longint; lindex: Longint;
      ptd: IntPtr; out size: TPoint): HResult;
  end;

{ IDropSource interface }

  [ComImport,
  GuidAttribute('00000121-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDropSource = interface
    [PreserveSig]
    function QueryContinueDrag(fEscapePressed: BOOL;
      grfKeyState: Longint): HResult;
    [PreserveSig]
    function GiveFeedback(dwEffect: Longint): HResult;
  end;

{ IDropTarget interface }

  [ComImport,
  GuidAttribute('00000122-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDropTarget = interface
    [PreserveSig]
    function DragEnter([in, MarshalAs(UnmanagedType.Interface)] dataObj: IDataObject;
      grfKeyState: Longint; pt: TPoint; var dwEffect: Longint): HResult;
    [PreserveSig]
    function DragOver(grfKeyState: Longint; pt: TPoint; var dwEffect: Longint): HResult;
    [PreserveSig]
    function DragLeave: HResult;
    [PreserveSig]
    function Drop([in, MarshalAs(UnmanagedType.Interface)] dataObj: IDataObject;
      grfKeyState: Longint; pt: TPoint; var dwEffect: Longint): HResult;
  end;

{ IOleControl interface }

  [ComImport,
  GuidAttribute('B196B288-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleControl = interface
    [PreserveSig]
    function GetControlInfo(var ci: TControlInfo): HResult;
    [PreserveSig]
    function OnMnemonic([in] var msg: TMsg): HResult;
    [PreserveSig]
    function OnAmbientPropertyChange(dispid: TDispID): HResult;
    [PreserveSig]
    function FreezeEvents(bFreeze: BOOL): HResult;
  end;

{ IOleControlSite interface }

  [ComImport,
  GuidAttribute('B196B289-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleControlSite = interface
    [PreserveSig]
    function OnControlInfoChanged: HResult;
    [PreserveSig]
    function LockInPlaceActive(fLock: BOOL): HResult;
    [PreserveSig]
    function GetExtendedControl([MarshalAs(UnmanagedType.IDispatch)] out disp): HResult;
    [PreserveSig]
    function TransformCoords(var ptlHimetric: TPoint; var ptfContainer: TPointF;
      flags: Longint): HResult;
    [PreserveSig]
    function TranslateAccelerator([in] var msg: TMsg; grfModifiers: Longint): HResult;
    [PreserveSig]
    function OnFocus(fGotFocus: BOOL): HResult;
    [PreserveSig]
    function ShowPropertyFrame: HResult;
  end;

{ ISimpleFrameSite interface }

  [ComImport,
  GuidAttribute('742B0E01-14E6-101B-914E-00AA00300CAB'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISimpleFrameSite = interface
    [PreserveSig]
    function PreMessageFilter(wnd: HWnd; msg, wp, lp: Integer;
      out res: Integer; out Cookie: Longint): HResult;
    [PreserveSig]
    function PostMessageFilter(wnd: HWnd; msg, wp, lp: Integer;
      out res: Integer; Cookie: Longint): HResult;
  end;

{ IObjectWithSite interface }

  [ComImport,
  GuidAttribute('FC4801A3-2BA9-11CF-A229-00AA003D7352'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectWithSite = interface
    [PreserveSig]
    function SetSite([in, MarshalAs(UnmanagedType.IUnknown)] pUnkSite: TObject):HResult;
    [PreserveSig]
    function GetSite([MarshalAs(UnmanagedType.LPStruct)] riid: TIID;
      [MarshalAs(UnmanagedType.IUnknown)] out site):HResult;
  end;

{ IErrorLog interface }

  [ComImport,
  GuidAttribute('3127CA40-446E-11CE-8135-00AA004BB851'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IErrorLog = interface
    [PreserveSig]
    function AddError([MarshalAs(UnmanagedType.LPWStr)] pszPropName: string;
      pExcepInfo: IntPtr): HResult;
  end;

{ IPropertyBag interface }

  [ComImport,
  GuidAttribute('55272A00-42CB-11CE-8135-00AA004BB851'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertyBag = interface
    [PreserveSig]
    function Read([MarshalAs(UnmanagedType.LPWStr)] pszPropName: string;
      var pvar: TObject;
      [in, MarshalAs(UnmanagedType.Interface)] pErrorLog: IErrorLog): HResult;
    [PreserveSig]
    function Write([MarshalAs(UnmanagedType.LPWStr)] pszPropName: string;
      [in] var pvar: TObject): HResult;
  end;

{ IPersistPropertyBag interface }

  [ComImport,
  GuidAttribute('37D84F60-42CB-11CE-8135-00AA004BB851'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistPropertyBag = interface { IPersist }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistPropertyBag
    [PreserveSig]
    function InitNew: HResult;
    [PreserveSig]
    function Load([in, MarshalAs(UnmanagedType.Interface)] pPropBag: IPropertyBag;
      [in, MarshalAs(UnmanagedType.Interface)] pErrorLog: IErrorLog): HResult;
    [PreserveSig]
    function Save([in, MarshalAs(UnmanagedType.Interface)] pPropBag: IPropertyBag;
      fClearDirty: BOOL; fSaveAllProperties: BOOL): HResult;
  end;

{ IPersistStreamInit interface }

  [ComImport,
  GuidAttribute('7FD52380-4E07-101B-AE2D-08002B2EC713'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistStreamInit = interface { IPersistStream }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistStream
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function Load([in, MarshalAs(UnmanagedType.Interface)] stm: IStream): HResult;
    [PreserveSig]
    function Save([in, MarshalAs(UnmanagedType.Interface)] stm: IStream; fClearDirty: BOOL): HResult;
    [PreserveSig]
    function GetSizeMax(out cbSize: Largeint): HResult;

    // IPersistStreamInit
    [PreserveSig]
    function InitNew: HResult;
  end;

{ IPropertyNotifySink interface }

  [ComImport,
  GuidAttribute('9BFBBC02-EFF1-101A-84ED-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertyNotifySink = interface
    [PreserveSig]
    function OnChanged(dispid: TDispID): HResult;
    [PreserveSig]
    function OnRequestEdit(dispid: TDispID): HResult;
  end;

{ IProvideClassInfo interface }

  [ComImport,
  GuidAttribute('B196B283-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IProvideClassInfo = interface
    [PreserveSig]       
    function GetClassInfo(out ti: ITypeInfo): HResult;
  end;

{ IConnectionPointContainer interface }

  [ComImport,
  GuidAttribute('B196B284-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IConnectionPointContainer = interface
    [PreserveSig]
    function EnumConnectionPoints(out Enum: IEnumConnectionPoints): HResult;
    [PreserveSig]
    function FindConnectionPoint([MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      out cp: IConnectionPoint): HResult;
  end;

{ IEnumConnectionPoints interface }

  [ComImport,
  GuidAttribute('B196B285-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumConnectionPoints = interface
    [PreserveSig]
    function Next(celt: Longint;
      [MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      out rgelt: array of IEnumConnectionPoints; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumConnectionPoints): HResult;
  end;

{ IConnectionPoint interface }

  [ComImport,
  GuidAttribute('B196B286-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IConnectionPoint = interface
    [PreserveSig]
    function GetConnectionInterface(out iid: TIID): HResult;
    [PreserveSig]
    function GetConnectionPointContainer(out cpc: IConnectionPointContainer): HResult;
    [PreserveSig]
    function Advise([in, MarshalAs(UnmanagedType.IUnknown)] unkSink: TObject;
      out dwCookie: Longint): HResult;
    [PreserveSig]
    function Unadvise(dwCookie: Longint): HResult;
    [PreserveSig]
    function EnumConnections(out Enum: IEnumConnections): HResult;
  end;

{ from OCIDL.H }
{ TConnectData structure }

  [StructLayout(LayoutKind.Sequential)]
  tagCONNECTDATA = record
    [MarshalAs(UnmanagedType.IUnknown)]
    pUnk: TObject;
    dwCookie: Longint;
  end;
  TConnectData = tagCONNECTDATA;
  CONNECTDATA = TConnectData;


{ IEnumConnections interface }

  [ComImport,
  GuidAttribute('B196B287-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumConnections = interface
    [PreserveSig]
    function Next(celt: Longint;
      [MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      out rgelt: array of IEnumConnections; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumConnections): HResult;
  end;

{ TLicInfo structure }

  [StructLayout(LayoutKind.Sequential)]
  tagLICINFO = record
    cbLicInfo: Longint;
    fRuntimeKeyAvail: BOOL;
    fLicVerified: BOOL;
  end;
  TLicInfo = tagLICINFO;
  LICINFO = TLicInfo;


{ IClassFactory2 interface }

  [ComImport,
  GuidAttribute('B196B28F-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IClassFactory2 = interface { IClassFactory }
    // IClassFactory
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out obj): HResult;
    [PreserveSig]
    function LockServer(fLock: BOOL): HResult;

    // IClassFactory2
    [PreserveSig]
    function GetLicInfo(var licInfo: TLicInfo): HResult;
    [PreserveSig]
    function RequestLicKey(dwResrved: Longint;
      [MarshalAs(UnmanagedType.BStr)] out bstrKey: string): HResult;
    [PreserveSig]
    function CreateInstanceLic([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      [MarshalAs(UnmanagedType.IUnknown)] unkReserved: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [in, MarshalAs(UnmanagedType.BStr)] bstrKey: WideString;
      [MarshalAs(UnmanagedType.Interface)] out vObject): HResult;
  end;

{ TCAUUID structure - a counted array of TGUID }

  TGUIDList = array[0..65535] of TGUID;
  TGUIDArray = array of TGUID; 

  [StructLayout(LayoutKind.Sequential)]
  tagCAUUID = record
    cElems: Longint;
    pElems: IntPtr; { ^TGUIDList }
  end;
  TCAGUID = tagCAUUID;
  CAUUID = TCAGUID;


{ TCAPOleStr structure - a counted array of POleStr }

  [StructLayout(LayoutKind.Sequential)]
  tagCALPOLESTR = record
    cElems: Longint;
    pElems: IntPtr; { ^TOleStrList }
  end;
  CALPOLESTR = tagCALPOLESTR;
  TCAPOleStr = tagCALPOLESTR;

{ TCALongint - a counted array of Longint }

  TLongintList = array[0..65535] of Longint;

  [StructLayout(LayoutKind.Sequential)]
  tagCADWORD = record
    cElems: Longint;
    pElems: IntPtr; { ^TLongintList }
  end;
  CADWORD = tagCADWORD;
  TCALongint = tagCADWORD;

{ IOleInPlaceObjectWindowless interface }

  [ComImport,
  GuidAttribute('1C2056CC-5EF4-101B-8BC8-00AA003E3B29'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceObjectWindowless = interface { IOleInPlaceObject }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceObject
    [PreserveSig]
    function InPlaceDeactivate: HResult;
    [PreserveSig]
    function UIDeactivate: HResult;
    [PreserveSig]
    function SetObjectRects([in] var rcPosRect: TRect;
      [in] var rcClipRect: TRect): HResult;
    [PreserveSig]
    function ReactivateAndUndo: HResult;

    // IOleInPlaceObjectWindowless
    [PreserveSig]
    function OnWindowMessage(msg: LongWord; wParam: WPARAM; lParam: LPARAM;
        var lResult: LRESULT): HResult;
    [PreserveSig]
    function GetDropTarget(out pDropTarget: IDropTarget):HResult ;
  end;

{ IOleInPlaceSiteEx interface }

  [ComImport,
  GuidAttribute('9C2CAD80-3424-11CF-B670-00AA004CD6D8'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceSiteEx = interface { IOleInPlaceSite }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceSite
    [PreserveSig]
    function CanInPlaceActivate: HResult;
    [PreserveSig]
    function OnInPlaceActivate: HResult;
    [PreserveSig]
    function OnUIActivate: HResult;
    [PreserveSig]
    function GetWindowContext(out frame: IOleInPlaceFrame;
      out doc: IOleInPlaceUIWindow; out rcPosRect: TRect;
      out rcClipRect: TRect; out frameInfo: TOleInPlaceFrameInfo): HResult;
    [PreserveSig]
    function Scroll(scrollExtent: TPoint): HResult;
    [PreserveSig]
    function OnUIDeactivate(fUndoable: BOOL): HResult;
    [PreserveSig]
    function OnInPlaceDeactivate: HResult;
    [PreserveSig]
    function DiscardUndoState: HResult;
    [PreserveSig]
    function DeactivateAndUndo: HResult;
    [PreserveSig]
    function OnPosRectChange([in] var rcPosRect: TRect): HResult;

    // IOleInPlaceSiteEx
    [PreserveSig]
    function OnInPlaceActivateEx(fNoRedraw: IntPtr; dwFlags: DWORD): HResult;
    [PreserveSig]
    function OnInPlaceDeActivateEx(fNoRedraw: BOOL): HResult;
    [PreserveSig]
    function RequestUIActivate: HResult;
  end;

{ IOleInPlaceSiteWindowless interface }

  [ComImport,
  GuidAttribute('922EADA0-3424-11CF-B670-00AA004CD6D8'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleInPlaceSiteWindowless = interface { IOleInPlaceSiteEx }
    // IOleWindow
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;

    // IOleInPlaceSite
    [PreserveSig]
    function CanInPlaceActivate: HResult;
    [PreserveSig]
    function OnInPlaceActivate: HResult;
    [PreserveSig]
    function OnUIActivate: HResult;
    [PreserveSig]
    function GetWindowContext(out frame: IOleInPlaceFrame;
      out doc: IOleInPlaceUIWindow; out rcPosRect: TRect;
      out rcClipRect: TRect; out frameInfo: TOleInPlaceFrameInfo): HResult;
    [PreserveSig]
    function Scroll(scrollExtent: TPoint): HResult;
    [PreserveSig]
    function OnUIDeactivate(fUndoable: BOOL): HResult;
    [PreserveSig]
    function OnInPlaceDeactivate: HResult;
    [PreserveSig]
    function DiscardUndoState: HResult;
    [PreserveSig]
    function DeactivateAndUndo: HResult;
    [PreserveSig]
    function OnPosRectChange([in] var rcPosRect: TRect): HResult;

    // IOleInPlaceSiteEx
    [PreserveSig]
    function OnInPlaceActivateEx(fNoRedraw: IntPtr; dwFlags: DWORD): HResult;
    [PreserveSig]
    function OnInPlaceDeActivateEx(fNoRedraw: BOOL): HResult;
    [PreserveSig]
    function RequestUIActivate: HResult;

    // IOleInPlaceSiteWindowless
    [PreserveSig]
    function CanWindowlessActivate: HResult;
    [PreserveSig]
    function GetCapture: HResult;
    [PreserveSig]
    function SetCapture(fCapture: BOOL): HResult;
    [PreserveSig]
    function GetFocus: HResult;
    [PreserveSig]
    function SetFocus(fFocus: BOOL): HResult;
    [PreserveSig]
    function GetDC(var Rect: TRect; qrfFlags: DWORD; var hDC: HDC): HResult;
    [PreserveSig]
    function ReleaseDC(hDC: HDC): HResult;
    [PreserveSig]
    function InvalidateRect(var Rect: TRect; fErase: BOOL): HResult;
    [PreserveSig]
    function InvalidateRgn(hRGN: HRGN; fErase: BOOL): HResult;
    [PreserveSig]
    function ScrollRect(dx, dy: Integer; var RectScroll: TRect;
       var RectClip: TRect): HResult;
    [PreserveSig]
    function AdjustRect(var rc: TRect): HResult;
    [PreserveSig]
    function OnDefWindowMessage(msg: LongWord; wParam: WPARAM;
       lParam: LPARAM; var LResult: LRESULT): HResult;
  end;

{ from OLECTL.H }
{ TOCPFIParams - parameters for OleCreatePropertyFrameIndirect }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagOCPFIPARAMS = record
    cbStructSize: Longint;
    hWndOwner: HWnd;
    x: Integer;
    y: Integer;
    [MarshalAs(UnmanagedType.LPWStr)] 
    lpszCaption: string;
    cObjects: Longint;
    pObjects: IntPtr;
    cPages: Longint;
    pPages: IntPtr;
    lcid: TLCID;
    dispidInitialProperty: TDispID;
  end;
  TOCPFIParams = tagOCPFIPARAMS;
  OCPFIPARAMS = TOCPFIParams;


{ from OCIDL.H }
{ TPropPageInfo structure - information about a property page }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagPROPPAGEINFO = record
    cb: Longint;
    [MarshalAs(UnmanagedType.LPWStr)]
    pszTitle: string; 
    size: TSize;
    [MarshalAs(UnmanagedType.LPWStr)]
    pszDocString: string;
    [MarshalAs(UnmanagedType.LPWStr)]
    pszHelpFile: string; 
    dwHelpContext: Longint;
  end;
  TPropPageInfo = tagPROPPAGEINFO;
  PROPPAGEINFO = TPropPageInfo;


{ ISpecifyPropertyPages interface }

  [ComImport,
  GuidAttribute('B196B28B-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISpecifyPropertyPages = interface
    [PreserveSig]
    function GetPages(out pages: TCAGUID): HResult;
  end;

{ IPerPropertyBrowsing interface }

  [ComImport,
  GuidAttribute('376BD3AA-3845-101B-84ED-08002B2EC713'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPerPropertyBrowsing = interface
    [PreserveSig]
    function GetDisplayString(dispid: TDispID;
      [MarshalAs(UnmanagedType.BStr)] out bstr: WideString): HResult;
    [PreserveSig]
    function MapPropertyToPage(dispid: TDispID; out clsid: TCLSID): HResult;
    [PreserveSig]
    function GetPredefinedStrings(dispid: TDispID; out caStringsOut: TCAPOleStr;
      out caCookiesOut: TCALongint): HResult;
    [PreserveSig]
    function GetPredefinedValue(dispid: TDispID; dwCookie: Longint;
      out varOut: TObject): HResult;
  end;

{ IPropertyPageSite interface }

  [ComImport,
  GuidAttribute('B196B28C-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertyPageSite = interface
    [PreserveSig]
    function OnStatusChange(flags: Longint): HResult;
    [PreserveSig]
    function GetLocaleID(out localeID: TLCID): HResult;
    [PreserveSig]
    function GetPageContainer([MarshalAs(UnmanagedType.IUnknown)] out unk): HResult;
    [PreserveSig]
    function TranslateAccelerator([in] var msg: TMsg): HResult;
  end;

{ IPropertyPage interface }

  [ComImport,
  GuidAttribute('B196B28D-BAB4-101A-B69C-00AA00341D07'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertyPage = interface
    [PreserveSig]
    function SetPageSite([in, MarshalAs(UnmanagedType.Interface)] pageSite: IPropertyPageSite): HResult;
    [PreserveSig]
    function Activate(hwndParent: HWnd; [in] var rc: TRect; bModal: BOOL): HResult;
    [PreserveSig]
    function Deactivate: HResult;
    [PreserveSig]
    function GetPageInfo(out pageInfo: TPropPageInfo): HResult;
    [PreserveSig]
    function SetObjects(cObjects: Longint;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.IUnknown)]
      pUnkList: array of TObject): HResult;
    [PreserveSig]
    function Show(nCmdShow: Integer): HResult;
    [PreserveSig]
    function Move([in] var rect: TRect): HResult;
    [PreserveSig]
    function IsPageDirty: HResult;
    [PreserveSig]
    function Apply: HResult;
    [PreserveSig]
    function Help([MarshalAs(UnmanagedType.LPWStr)] pszHelpDir: string): HResult;
    [PreserveSig]
    function TranslateAccelerator([in] var msg: TMsg): HResult;
  end;

{ IPropertyPage2 interface }

  [ComImport,
  GuidAttribute('01E44665-24AC-101B-84ED-08002B2EC713'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPropertyPage2 = interface { IPropertyPage }
    // IPropertyPage
    [PreserveSig]
    function SetPageSite([in, MarshalAs(UnmanagedType.Interface)] pageSite: IPropertyPageSite): HResult;
    [PreserveSig]
    function Activate(hwndParent: HWnd; [in] var rc: TRect; bModal: BOOL): HResult;
    [PreserveSig]
    function Deactivate: HResult;
    [PreserveSig]
    function GetPageInfo(out pageInfo: TPropPageInfo): HResult;
    [PreserveSig]
    function SetObjects(cObjects: Longint;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.IUnknown)]
      pUnkList: array of TObject): HResult;
    [PreserveSig]
    function Show(nCmdShow: Integer): HResult;
    [PreserveSig]
    function Move([in] var rect: TRect): HResult;
    [PreserveSig]
    function IsPageDirty: HResult;
    [PreserveSig]
    function Apply: HResult;
    [PreserveSig]
    function Help([MarshalAs(UnmanagedType.LPWStr)] pszHelpDir: string): HResult;
    [PreserveSig]
    function TranslateAccelerator([in] var msg: TMsg): HResult;

    // IPropertyPage2
    [PreserveSig]
    function EditProperty(dispid: TDispID): HResult;
  end;

{ IFont interface }

  [ComImport,
  GuidAttribute('BEF6E002-A874-101A-8BBA-00AA00300CAB'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IFont = interface
    [PreserveSig]
    function get_Name([MarshalAs(UnmanagedType.BStr)] out name: WideString): HResult;
    [PreserveSig]
    function put_Name([in, MarshalAs(UnmanagedType.BStr)] name: WideString): HResult;
    [PreserveSig]
    function get_Size(out size: TOACurrency): HResult;
    [PreserveSig]
    function put_Size(size: TOACurrency): HResult;
    [PreserveSig]
    function get_Bold(out bold: BOOL): HResult;
    [PreserveSig]
    function put_Bold(bold: BOOL): HResult;
    [PreserveSig]
    function get_Italic(out italic: BOOL): HResult;
    [PreserveSig]
    function put_Italic(italic: BOOL): HResult;
    [PreserveSig]
    function get_Underline(out underline: BOOL): HResult;
    [PreserveSig]
    function put_Underline(underline: BOOL): HResult;
    [PreserveSig]
    function get_Strikethrough(out strikethrough: BOOL): HResult;
    [PreserveSig]
    function put_Strikethrough(strikethrough: BOOL): HResult;
    [PreserveSig]
    function get_Weight(out weight: Smallint): HResult;
    [PreserveSig]
    function put_Weight(weight: Smallint): HResult;
    [PreserveSig]
    function get_Charset(out charset: Smallint): HResult;
    [PreserveSig]
    function put_Charset(charset: Smallint): HResult;
    [PreserveSig]
    function get_hFont(out font: HFont): HResult;
    [PreserveSig]
    function Clone(out font: IFont): HResult;
    [PreserveSig]
    function IsEqual([in, MarshalAs(UnmanagedType.Interface)] fontOther: IFont): HResult;
    [PreserveSig]
    function SetRatio(cyLogical, cyHimetric: Longint): HResult;
    [PreserveSig]
    function QueryTextMetrics(out tm: TTextMetricOle): HResult;
    [PreserveSig]
    function AddRefHfont(font: HFont): HResult;
    [PreserveSig]
    function ReleaseHfont(font: HFont): HResult;
  end;

{ Font dispatch interface }

  [ComImport,
  GuidAttribute('BEF6E003-A874-101A-8BBA-00AA00300CAB'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  IFontDisp = interface
  end;

  Font = IFontDisp;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagSOLE_AUTHENTICATION_SERVICE = record
    dwAuthnSvc: Longint;
    dwAuthzSvc: Longint;
    [MarshalAs(UnmanagedType.LPWStr)]
    pPrincipalName: string;
    hr: HResult;
  end;
  TSOleAuthenticationService = tagSOLE_AUTHENTICATION_SERVICE;
  SOLE_AUTHENTICATION_SERVICE = TSOleAuthenticationService;


{ from OLECTL.H }
{ TFontDesc structure }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  tagFONTDESC = record
    cbSizeofstruct: Integer;
    [MarshalAs(UnmanagedType.LPWStr)]
    lpstrName: string;
    cySize: Currency;
    sWeight: Smallint;
    sCharset: Smallint;
    fItalic: BOOL;
    fUnderline: BOOL;
    fStrikethrough: BOOL;
  end;
  TFontDesc = tagFONTDESC;
  FONTDESC = TFontDesc;


{ from OCIDL.H }
{ IPicture interface }

  [ComImport,
  GuidAttribute('7BF80980-BF32-101A-8BBB-00AA00300CAB'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPicture = interface
    [PreserveSig]
    function get_Handle(out handle: OLE_HANDLE): HResult;
    [PreserveSig]
    function get_hPal(out handle: OLE_HANDLE): HResult;
    [PreserveSig]
    function get_Type(out typ: Smallint): HResult;
    [PreserveSig]
    function get_Width(out width: OLE_XSIZE_HIMETRIC): HResult;
    [PreserveSig]
    function get_Height(out height: OLE_YSIZE_HIMETRIC): HResult;
    [PreserveSig]
    function Render(dc: HDC; x, y, cx, cy: Longint;
      xSrc: OLE_XPOS_HIMETRIC; ySrc: OLE_YPOS_HIMETRIC;
      cxSrc: OLE_XSIZE_HIMETRIC; cySrc: OLE_YSIZE_HIMETRIC;
      [in] var rcWBounds: TRect): HResult;
    [PreserveSig]
    function set_hPal(hpal: OLE_HANDLE): HResult;
    [PreserveSig]
    function get_CurDC(out dcOut: HDC): HResult;
    [PreserveSig]
    function SelectPicture(dcIn: HDC; out hdcOut: HDC;
      out bmpOut: OLE_HANDLE): HResult;
    [PreserveSig]
    function get_KeepOriginalFormat(out fkeep: BOOL): HResult;
    [PreserveSig]
    function put_KeepOriginalFormat(fkeep: BOOL): HResult;
    [PreserveSig]
    function PictureChanged: HResult;
    [PreserveSig]
    function SaveAsFile([in, MarshalAs(UnmanagedType.Interface)] stream: IStream;
      fSaveMemCopy: BOOL; out cbSize: Longint): HResult;
    [PreserveSig]
    function get_Attributes(out dwAttr: Longint): HResult;
  end;

{ Picture dispatch interface }

  [ComImport,
  GuidAttribute('7BF80981-BF32-101A-8BBB-00AA00300CAB'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  IPictureDisp = interface
  end;

  Picture = IPictureDisp;

{ from OLECTL.H }
{ TPictDesc structure }

  tagPICTDESC = record
    cbSizeofstruct: Integer;
    picType: Integer;
    case Integer of
      PICTYPE_BITMAP: (
  hbitmap: THandle;       { Bitmap }
  hpal: THandle);         { Accompanying palette }
      PICTYPE_METAFILE: (
  hMeta: THandle;         { Metafile }
  xExt, yExt: Integer);   { Extent }
      PICTYPE_ICON: (
  hIcon: THandle);        { Icon }
      PICTYPE_ENHMETAFILE: (
  hemf: THandle);         { Enhanced Metafile }
  end;
  TPictDesc = tagPICTDESC;
  PICTDESC = TPictDesc;


{ The following ActiveDoc interfaces come from DocObj.idl }

  [ComImport,
  GuidAttribute('b722bcc6-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleDocumentView = interface
    [PreserveSig]
    function SetInPlaceSite([in, MarshalAs(UnmanagedType.Interface)] Site: IOleInPlaceSite): HResult;
    [PreserveSig]
    function GetInPlaceSite(out Site: IOleInPlaceSite): HResult;
    [PreserveSig]
    function GetDocument([MarshalAs(UnmanagedType.IUnknown)] out P): HResult;
    [PreserveSig]
    function SetRect([in] var View: TRECT): HResult;
    [PreserveSig]
    function GetRect(var View: TRECT): HResult;
    [PreserveSig]
    function SetRectComplex([in] var View, HScroll, VScroll, SizeBox: TRect): HResult;
    [PreserveSig]
    function Show(fShow: BOOL): HResult;
    [PreserveSig]
    function UIActivate(fUIActivate: BOOL): HResult;
    [PreserveSig]
    function Open: HResult;
    [PreserveSig]
    function CloseView(dwReserved: DWORD): HResult;
    [PreserveSig]
    function SaveViewState([in, MarshalAs(UnmanagedType.Interface)] pstm: IStream): HResult;
    [PreserveSig]
    function ApplyViewState([in, MarshalAs(UnmanagedType.Interface)] pstm: IStream): HResult;
    [PreserveSig]
    function Clone([in, MarshalAs(UnmanagedType.Interface)] NewSite: IOleInPlaceSite;
      out NewView: IOleDocumentView): HResult;
  end;

  [ComImport,
  GuidAttribute('b722bcc8-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumOleDocumentViews = interface
    [PreserveSig]
    function Next(celt: Longint;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of IOleDocumentView; out pceltFetched: Longint): HResult;
    [PreserveSig]
    function Skip(Count: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumOleDocumentViews): HResult;
  end;

  [ComImport,
  GuidAttribute('b722bcc5-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleDocument = interface
    [PreserveSig]
    function CreateView([in, MarshalAs(UnmanagedType.Interface)] Site: IOleInPlaceSite;
      [in, MarshalAs(UnmanagedType.Interface)] Stream: IStream;
      rsrvd: DWORD; out View: IOleDocumentView): HResult;
    [PreserveSig]
    function GetDocMiscStatus(var Status: DWORD): HResult;
    [PreserveSig]
    function EnumViews(out Enum: IEnumOleDocumentViews;
      out View: IOleDocumentView): HResult;
  end;

  [ComImport,
  GuidAttribute('b722bcc7-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleDocumentSite = interface
    [PreserveSig]
    function ActivateMe([in, MarshalAs(UnmanagedType.Interface)] View: IOleDocumentView): HRESULT;
  end;

  [ComImport,
  GuidAttribute('b722bcca-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IContinueCallback = interface
    [PreserveSig]
    function Continue: HResult;
    [PreserveSig]
    function ContinuePrinting( nCntPrinted, nCurPage: Longint;
      PrintStatus: PWideChar): HResult;
  end;

{+ ! From servprov.idl: }

  // Note: IServiceProvider renamed to ICOMServiceProvider
  [ComImport,
  GuidAttribute('6d5140c1-7436-11ce-8034-00aa006009fa'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICOMServiceProvider = interface
    [PreserveSig]
    function QueryService([MarshalAs(UnmanagedType.LPStruct)] rsid, iid: TGuid;
      [MarshalAs(UnmanagedType.Interface)] out Obj): HResult;
  end;



const
  PRINTFLAG_MAYBOTHERUSER         = 1;
  PRINTFLAG_PROMPTUSER            = 2;
  PRINTFLAG_USERMAYCHANGEPRINTER  = 4;
  PRINTFLAG_RECOMPOSETODEVICE     = 8;
  PRINTFLAG_DONTACTUALLYPRINT     = 16;
  PRINTFLAG_FORCEPROPERTIES       = 32;
  PRINTFLAG_PRINTTOFILE           = 64;

  PAGESET_TOLASTPAGE              = Cardinal(-1);

type
  [StructLayout(LayoutKind.Sequential)]
  tagPAGERANGE = record
    nFromPage: Longint;
    nToPage: Longint;
  end;
  PAGERANGE = tagPAGERANGE;
  TPageRange = tagPAGERANGE;

  [StructLayout(LayoutKind.Sequential)]
  tagPAGESET = record
    cbStruct: Cardinal;
    fOddPages: BOOL;
    fEvenPages: BOOL;
    cPageRange: Cardinal;
    rgPages: IntPtr; { array [0..0] of TPageRange }
  end;
  PAGESET = tagPAGESET;
  TPageSet = tagPAGESET;

  [ComImport,
  GuidAttribute('b722bcc9-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPrint = interface
    [PreserveSig]
    function SetInitialPageNum(nFirstPage: Longint): HResult;
    [PreserveSig]
    function GetPageInfo(var pnFirstPage, pcPages: Longint): HResult;
    [PreserveSig]
    function Print(grfFlags: DWORD; var td: TDVTARGETDEVICE;
      var PageSet: TPageSet; stgmOptions: IntPtr;
      [in, MarshalAs(UnmanagedType.Interface)] Callback: IContinueCallback;
      FirstPage: Longint; out pcPagesPrinted, pnLastPage: Longint): HResult;
  end;

const
  OLECMDIDF_REFRESH_NORMAL     = 0;
  OLECMDIDF_REFRESH_IFEXPIRED  = 1;
  OLECMDIDF_REFRESH_CONTINUE   = 2;
  OLECMDIDF_REFRESH_COMPLETELY = 3;

  OLECMDF_SUPPORTED       = 1;
  OLECMDF_ENABLED         = 2;
  OLECMDF_LATCHED         = 4;
  OLECMDF_NINCHED         = 8;

  OLECMDTEXTF_NONE        = 0;
  OLECMDTEXTF_NAME        = 1;
  OLECMDTEXTF_STATUS      = 2;

  OLECMDEXECOPT_DODEFAULT         = 0;
  OLECMDEXECOPT_PROMPTUSER        = 1;
  OLECMDEXECOPT_DONTPROMPTUSER    = 2;
  OLECMDEXECOPT_SHOWHELP          = 3;

  OLECMDID_OPEN                           = 1;
  OLECMDID_NEW                            = 2;
  OLECMDID_SAVE                           = 3;
  OLECMDID_SAVEAS                         = 4;
  OLECMDID_SAVECOPYAS                     = 5;
  OLECMDID_PRINT                          = 6;
  OLECMDID_PRINTPREVIEW                   = 7;
  OLECMDID_PAGESETUP                      = 8;
  OLECMDID_SPELL                          = 9;
  OLECMDID_PROPERTIES                     = 10;
  OLECMDID_CUT                            = 11;
  OLECMDID_COPY                           = 12;
  OLECMDID_PASTE                          = 13;
  OLECMDID_PASTESPECIAL                   = 14;
  OLECMDID_UNDO                           = 15;
  OLECMDID_REDO                           = 16;
  OLECMDID_SELECTALL                      = 17;
  OLECMDID_CLEARSELECTION                 = 18;
  OLECMDID_ZOOM                           = 19;
  OLECMDID_GETZOOMRANGE                   = 20;
  OLECMDID_UPDATECOMMANDS                 = 21;
  OLECMDID_REFRESH                        = 22;
  OLECMDID_STOP                           = 23;
  OLECMDID_HIDETOOLBARS                   = 24;
  OLECMDID_SETPROGRESSMAX                 = 25;
  OLECMDID_SETPROGRESSPOS                 = 26;
  OLECMDID_SETPROGRESSTEXT                = 27;
  OLECMDID_SETTITLE                       = 28;
  OLECMDID_SETDOWNLOADSTATE               = 29;
  OLECMDID_STOPDOWNLOAD                   = 30;
    // OLECMDID_STOPDOWNLOAD is supported for QueryStatus Only

// error codes
  OLECMDERR_E_FIRST           = OLE_E_LAST+1;
  OLECMDERR_E_NOTSUPPORTED    = OLECMDERR_E_FIRST;
  OLECMDERR_E_DISABLED        = OLECMDERR_E_FIRST+1;
  OLECMDERR_E_NOHELP          = OLECMDERR_E_FIRST+2;
  OLECMDERR_E_CANCELED        = OLECMDERR_E_FIRST+3;
  OLECMDERR_E_UNKNOWNGROUP    = OLECMDERR_E_FIRST+4;

  MSOCMDERR_E_FIRST           = OLECMDERR_E_FIRST;
  MSOCMDERR_E_NOTSUPPORTED    = OLECMDERR_E_NOTSUPPORTED;
  MSOCMDERR_E_DISABLED        = OLECMDERR_E_DISABLED;
  MSOCMDERR_E_NOHELP          = OLECMDERR_E_NOHELP;
  MSOCMDERR_E_CANCELED        = OLECMDERR_E_CANCELED;
  MSOCMDERR_E_UNKNOWNGROUP    = OLECMDERR_E_UNKNOWNGROUP;

type

  [StructLayout(LayoutKind.Sequential)]
  _tagOLECMD = record
    cmdID: Cardinal;
    cmdf: Longint;
  end;
  OLECMD = _tagOLECMD;
  TOleCmd = _tagOLECMD;

  [StructLayout(LayoutKind.Sequential)]
  _tagOLECMDTEXT = record
    cmdtextf: Longint;
    cwActual: Cardinal;
    cwBuf: Cardinal;         // size in wide chars of the buffer for text
    rgwz: IntPtr;            // array [0..0] of WideChar:
                             // Array into which callee writes the text
  end;
  OLECMDTEXT = _tagOLECMDTEXT;
  TOleCmdText = _tagOLECMDTEXT;

  [ComImport,
  GuidAttribute('b722bccb-4e68-101b-a2bc-00aa00404770'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleCommandTarget = interface
    [PreserveSig]
    function QueryStatus([MarshalAs(UnmanagedType.LPStruct)] CmdGroup: TGUID;
      cCmds: Cardinal;
      [in, out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      prgCmds: array of TOleCmd; CmdText: IntPtr): HResult;
    [PreserveSig]
    function Exec([MarshalAs(UnmanagedType.LPStruct)] CmdGroup: TGUID;
      nCmdID, nCmdexecopt: DWORD; vaIn: IntPtr; var vaOut: IntPtr): HResult;
  end;

{ from designer.h}

const                    
  CATID_Designer = '4EB304D0-7555-11cf-A0C2-00AA0062BE57';

type
  [ComImport,
  GuidAttribute('51AAE3E0-7486-11cf-A0C2-00AA0062BE57'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IActiveDesigner = interface
    [PreserveSig]
    function GetRuntimeClassID(var clsid: TGUID): HResult;
    [PreserveSig]
    function GetRuntimeMiscStatusFlags(var dwMiscFlags: DWORD): HResult;
    [PreserveSig]
    function QueryPersistenceInterface([MarshalAs(UnmanagedType.LPStruct)] iid: TGUID): HResult;
    [PreserveSig]
    function SaveRuntimeState([MarshalAs(UnmanagedType.LPStruct)] iidItf: TGUID;
      [MarshalAs(UnmanagedType.LPStruct)] iidObj: TGUID;
      [MarshalAs(UnmanagedType.IUnknown)] Obj: TObject): HResult;
    [PreserveSig]
    function GetExtensibilityObject([MarshalAs(UnmanagedType.IDispatch)] var ppvObjOut): HResult;
  end;


{ from webdc.h }
const                        
  CATID_WebDesigntimeControl = '73cef3dd-ae85-11cf-a406-00aa00c00940';

type
  [ComImport,
  GuidAttribute('56223fe3-d397-11cf-a42e-00aa00c00940'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistTextStream = interface { IPersistStreamInit }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistStream
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function Load([in, MarshalAs(UnmanagedType.Interface)] stm: IStream): HResult;
    [PreserveSig]
    function Save([in, MarshalAs(UnmanagedType.Interface)] stm: IStream; fClearDirty: BOOL): HResult;
    [PreserveSig]
    function GetSizeMax(out cbSize: Largeint): HResult;

    // IPersistStreamInit
    [PreserveSig]
    function InitNew: HResult;
  end;

  [ComImport,
  GuidAttribute('56223FE1-D397-11cf-A42E-00AA00C00940'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IProvideRuntimeText = interface
    [PreserveSig]
    function GetRuntimeText([MarshalAs(UnmanagedType.BStr)] var strRuntimeText: string): HResult;
  end;

const
{ from CGUID.H }
{ Standard GUIDs }

  GUID_NULL = '00000000-0000-0000-0000-000000000000';
  GUID_OLE_COLOR = '66504301-BE0F-101A-8BBB-00AA00300CAB';

{ Additional GUIDs }

  IID_IRpcChannel = '00000004-0000-0000-C000-000000000046';
  IID_IRpcStub = '00000005-0000-0000-C000-000000000046';
  IID_IStubManager = '00000006-0000-0000-C000-000000000046';
  IID_IRpcProxy = '00000007-0000-0000-C000-000000000046';
  IID_IProxyManager = '00000008-0000-0000-C000-000000000046';
  IID_IPSFactory = '00000009-0000-0000-C000-000000000046';
  IID_IInternalMoniker = '00000011-0000-0000-C000-000000000046';
  CLSID_StdMarshal = '00000017-0000-0000-C000-000000000046';
  IID_IEnumGeneric = '00000106-0000-0000-C000-000000000046';
  IID_IEnumHolder = '00000107-0000-0000-C000-000000000046';
  IID_IEnumCallback = '00000108-0000-0000-C000-000000000046';
  IID_IOleManager = '0000011F-0000-0000-C000-000000000046';
  IID_IOlePresObj = '00000120-0000-0000-C000-000000000046';
  IID_IDebug = '00000123-0000-0000-C000-000000000046';
  IID_IDebugStream = '00000124-0000-0000-C000-000000000046';

{ Standard class IDs }

  CLSID_CFontPropPage = '2542f180-3532-1069-a2cd-00aa0034b50b';
  CLSID_CColorPropPage = 'ddf5a600-b9c0-101a-af1a-00aa0034b50b';
  CLSID_CPicturePropPage = 'fc7af71d-fc74-101a-84ed-08002b2ec713';
  CLSID_PersistPropset = 'fb8f0821-0164-101b-84ed-08002b2ec713';
  CLSID_ConvertVBX = 'fb8f0822-0164-101b-84ed-08002b2ec713';
  CLSID_StdFont = 'fb8f0823-0164-101b-84ed-08002b2ec713';
  CLSID_StdPicture = 'fb8f0824-0164-101b-84ed-08002b2ec713';

{ from comcat.h }
{ COM Category Manager Interfaces }
type
  IEnumGUID = interface;
  IEnumCATEGORYINFO = interface;
  ICatRegister = interface;
  ICatInformation = interface;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  TCATEGORYINFO = record
    catid: TGUID;
    lcid: UINT;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
    szDescription: string;
  end;

  [ComImport,
  GuidAttribute('0002E000-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumGUID = interface
    [PreserveSig]
    function Next(celt: UINT; out rgelt: TGUID; out pceltFetched: UINT): HResult;
    [PreserveSig]
    function Skip(celt: UINT): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out ppenum: IEnumGUID): HResult;
  end;

  [ComImport,
  GuidAttribute('0002E011-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumCATEGORYINFO = interface
    [PreserveSig]       
    function Next(celt: UINT; out rgelt: TCATEGORYINFO; out pceltFetched: UINT): HResult; 
    [PreserveSig]
    function Skip(celt: UINT): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out ppenum: IEnumCATEGORYINFO): HResult;
  end;

  [ComImport,
  GuidAttribute('0002E012-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICatRegister = interface
    [PreserveSig]
    function RegisterCategories(cCategories: UINT;
      [in] rgCategoryInfo: array of TCATEGORYINFO): HResult;
    [PreserveSig]
    function UnRegisterCategories(cCategories: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function RegisterClassImplCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function UnRegisterClassImplCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function RegisterClassReqCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function UnRegisterClassReqCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
  end;

  [ComImport,
  GuidAttribute('0002E013-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICatInformation = interface
    [PreserveSig]
    function EnumCategories(lcid: UINT; out ppenumCategoryInfo: IEnumCATEGORYINFO): HResult;
    [PreserveSig]
    function GetCategoryDesc([MarshalAs(UnmanagedType.LPStruct)] rcatid: TGUID;
      lcid: UINT; [MarshalAs(UnmanagedType.LPWStr)] out pszDesc: string): HResult;
    [PreserveSig]
    function EnumClassesOfCategories(cImplemented: UINT;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPStruct)]
      rgcatidImpl: TGUIDArray; cRequired: UINT;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPStruct)]
      rgcatidReq: TGUIDArray; out ppenumClsid: IEnumGUID): HResult;
    [PreserveSig]
    function IsClassOfCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cImplemented: UINT;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPStruct)]
      rgcatidImpl: TGUIDArray; cRequired: UINT;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPStruct)]
      rgcatidReq: TGUIDArray): HResult;
    [PreserveSig]
    function EnumImplCategoriesOfClass([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      out ppenumCatid: IEnumGUID): HResult;
    [PreserveSig]
    function EnumReqCategoriesOfClass([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
	  out ppenumCatid: IEnumGUID): HResult;
  end;

  _tagBINDINFO = packed record
	cbSize: ULONG;
	[MarshalAs(UnmanagedType.LPWStr)]
	szExtraInfo: string;
	stgmedData: TStgMedium;
	grfBindInfoF: DWORD;
	dwBindVerb: DWORD;
	[MarshalAs(UnmanagedType.LPWStr)]
	szCustomVerb: string;
	cbstgmedData: DWORD;
	dwOptions: DWORD;
	dwOptionsFlags: DWORD;
	dwCodePage: DWORD;
	securityAttributes: TSecurityAttributes;
	iid: TGUID;
	pUnk: IntPtr; { IUnknown }
	dwReserved: DWORD;
  end;
  TBindInfo = _tagBINDINFO;
  BINDINFO = _tagBINDINFO;

  [ComImport,
  GuidAttribute('79eac9c0-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IBinding = interface
    [PreserveSig]
    function Abort: HResult;
    [PreserveSig]
    function Suspend: HResult;
    [PreserveSig]
    function Resume: HResult;
    [PreserveSig]
    function SetPriority(nPriority: Longint): HResult;
    [PreserveSig]
    function GetPriority(out nPriority: Longint): HResult;
    [PreserveSig]
    function GetBindResult(out clsidProtocol: TCLSID; out dwResult: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] out szResult: string;
      dwReserved: DWORD): HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9c1-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IBindStatusCallback = interface
    [PreserveSig]
    function OnStartBinding(dwReserved: DWORD; pib: IBinding): HResult;
    [PreserveSig]
    function GetPriority(out nPriority): HResult;
    [PreserveSig]
    function OnLowResource(reserved: DWORD): HResult;
    [PreserveSig]
    function OnProgress(ulProgress, ulProgressMax, ulStatusCode: ULONG;
      szStatusText: string): HResult;
    [PreserveSig]
    function OnStopBinding(hresult: HResult;
      [MarshalAs(UnmanagedType.LPWStr)] szError: string): HResult;
    [PreserveSig]
    function GetBindInfo(out grfBINDF: DWORD; var bindinfo: TBindInfo): HResult;
    [PreserveSig]
    function OnDataAvailable(grfBSCF: DWORD; dwSize: DWORD; var formatetc: TFormatEtc;
      var stgmed: TStgMedium): HResult;
    [PreserveSig]
    function OnObjectAvailable([in, MarshalAs(UnmanagedType.LPStruct)] iid: TGUID;
      [in, MarshalAs(UnmanagedType.IUnknown)] punk: TObject): HResult;
  end;

{ IBindHost Interface }
  [ComImport,
  GuidAttribute('fc4801a1-2ba9-11cf-a229-00aa003d7352'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IBindHost = interface
    [PreserveSig]
    function CreateMoniker([MarshalAs(UnmanagedType.LPWStr)] szName: string;
      BC: IBindCtx; out mk: IMoniker; dwReserved: DWORD): HResult;
    [PreserveSig]
    function MonikerBindToStorage(Mk: IMoniker; BC: IBindCtx; BSC: IBindStatusCallback;
      [in, MarshalAs(UnmanagedType.LPStruct)] iid: TGUID;
      [MarshalAs(UnmanagedType.Interface)] out pvObj): HResult;
    [PreserveSig]
    function MonikerBindToObject(Mk: IMoniker; BC: IBindCtx; BSC: IBindStatusCallback;
      [in, MarshalAs(UnmanagedType.LPStruct)] iid: TGUID;
      [MarshalAs(UnmanagedType.Interface)] out pvObj): HResult;
  end;

{ IOleUndoManager Interface }
  [ComImport,
  GuidAttribute('d001f200-ef97-11ce-9bc9-00aa00608e01'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleUndoManager = interface
  end;

{ IQuickActivate Interface }

  [StructLayout(LayoutKind.Sequential)]
  tagQACONTAINER = record
    cbSize: LongInt;
    [MarshalAs(UnmanagedType.Interface)]
    pClientSite: IOleClientSite;
    [MarshalAs(UnmanagedType.Interface)]
    pAdviseSink: IAdviseSink;
    [MarshalAs(UnmanagedType.Interface)]
    pPropertyNotifySink: IPropertyNotifySink;
    [MarshalAs(UnmanagedType.IUnknown)]
    pUnkEventSink: TObject;
    dwAmbientFlags: LongInt;
    colorFore: OLE_COLOR;
    colorBack: OLE_COLOR;
    pFont: IFont;
    [MarshalAs(UnmanagedType.Interface)]
    pUndoMgr: IOleUndoManager;
    dwAppearance: LongInt;
    lcid: LongInt;
    hpal: HPALETTE;
    [MarshalAs(UnmanagedType.Interface)]
    pBindHost: IBindHost;
  end;

  TQaContainer =  tagQACONTAINER;

  [StructLayout(LayoutKind.Sequential)]
  tagQACONTROL = record
    cbSize: LongInt;
    dwMiscStatus: LongInt;
    dwViewStatus: LongInt;
    dwEventCookie: LongInt;
    dwPropNotifyCookie: LongInt;
    dwPointerActivationPolicy: LongInt;
  end;

  TQaControl =  tagQACONTROL;

  [ComImport,
  GuidAttribute('cf51ed10-62fe-11cf-bf86-00a0c9034836'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IQuickActivate = interface
    function QuickActivate(var qaCont: tagQACONTAINER; var qaCtrl: tagQACONTROL): HResult;
    function SetContentExtent([in] var sizel: TPoint): HResult;
    function GetContentExtent(out sizel: TPoint): HResult;
  end;

const  
  CLSID_StdComponentCategoryMgr = '0002E005-0000-0000-C000-000000000046';

{ from OBJSAFE.H }

//+--------------------------------------------------------------------------=
//
//  Contents:   IObjectSafety definition
//
//
//  IObjectSafety should be implemented by objects that have interfaces which
//      support "untrusted" clients (for example, scripts). It allows the owner of
//      the object to specify which interfaces need to be protected from untrusted
//      use. Examples of interfaces that might be protected in this way are:
//
//      IID_IDispatch           - "Safe for automating with untrusted automation client or script"
//      IID_IPersist*           - "Safe for initializing with untrusted data"
//      IID_IActiveScript       - "Safe for running untrusted scripts"
//
//---------------------------------------------------------------------------=

const
  // Option bit definitions for IObjectSafety:
  INTERFACESAFE_FOR_UNTRUSTED_CALLER = 1;   // Caller of interface may be untrusted
  INTERFACESAFE_FOR_UNTRUSTED_DATA = 2;     // Data passed into interface may be untrusted

type
  [ComImport,
  GuidAttribute('CB5BDC81-93C1-11CF-8F20-00805F2CD064'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectSafety = interface
    [PreserveSig]
    function GetInterfaceSafetyOptions([MarshalAs(UnmanagedType.LPStruct)] IID: TIID;
      out pdwSupportedOptions, pdwEnabledOptions: DWORD): HResult;
    [PreserveSig]
    function SetInterfaceSafetyOptions([MarshalAs(UnmanagedType.LPStruct)] IID: TIID;
      dwOptionSetMask, dwEnabledOptions: DWORD): HResult;
  end;

{ from DISPEX.H }
type
  [ComImport,
  GuidAttribute('A6EF9860-C720-11D0-9337-00A0C90DCAA9'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  IDispatchEx = interface
    [PreserveSig]
    function GetDispID([MarshalAs(UnmanagedType.BStr)] bstrName: string;
      [in] vargrfdex: DWORD; out id: TDispID): HResult;
    [PreserveSig]
    function InvokeEx([in] var id: TDispID; [in] var lcid: LCID;
      [in] var wflags: WORD; pdp: IntPtr; out varRes: TObject;
      out pei: TExcepInfo; pspCaller: IntPtr): HResult;
    [PreserveSig]
    function DeleteMemberByName([MarshalAs(UnmanagedType.BStr)] bstr: string;
      [in] var grfdex: DWORD): HResult;
    [PreserveSig]
    function DeleteMemberByDispID([in] var id: TDispID): HResult;
    [PreserveSig]
    function GetMemberProperties([in] var id: TDispID; [in] var grfdexFetch: DWORD;
      out grfdex: DWORD): HResult;
    [PreserveSig]
    function GetMemberName([in] var id: TDispID;
      [MarshalAs(UnmanagedType.BStr)] out bstrName: string): HResult;
    [PreserveSig]
    function GetNextDispID([in] var grfdex: DWORD; [in] var id: TDispID;
       out nid: TDispID): HResult;
    [PreserveSig]
    function GetNameSpaceParent([MarshalAs(UnmanagedType.IUnknown)] out unk): HResult;
  end;

const
  { Input flags for GetDispID }
  fdexNameCaseSensitive       = $1;
  fdexNameEnsure              = $2;
  fdexNameImplicit            = $4;
  fdexNameCaseInsensitive     = $8;

  { input flags for GetMemberProperties }
  fdexPropCanGet              = $1;
  fdexPropCannotGet           = $2;
  fdexPropCanPut              = $4;
  fdexPropCannotPut           = $8;
  fdexPropCanPutRef           = $10;
  fdexPropCannotPutRef        = $20;
  fdexPropNoSideEffects       = $40;
  fdexPropDynamicType         = $80;
  fdexPropCanCall             = $100;
  fdexPropCannotCall          = $200;
  fdexPropCanConstruct        = $400;
  fdexPropCannotConstruct     = $800;
  fdexPropCanSourceEvents     = $1000;
  fdexPropCannotSourceEvents  = $2000;

  fdexPropCanAll = fdexPropCanGet or fdexPropCanPut or 
                   fdexPropCanPutRef or fdexPropCanCall or
                   fdexPropCanConstruct or fdexPropCanSourceEvents;

  fdexPropCannotAll = fdexPropCannotGet or fdexPropCannotPut or
                      fdexPropCannotPutRef or fdexPropCannotCall or
                      fdexPropCannotConstruct or fdexPropCannotSourceEvents;

  fdexPropExtraAll = fdexPropNoSideEffects or fdexPropDynamicType;

  fdexPropAll = fdexPropCanAll or fdexPropCannotAll or fdexPropExtraAll;

  { input flags for GetNextDispID }
  fdexEnumDefault = $01;
  fdexEnumAll     = $02;

{ from OBJBASE.H }
{ HResult manipulation routines }

function Succeeded(Res: HResult): Boolean; inline;
function Failed(Res: HResult): Boolean; inline;
function ResultCode(Res: HResult): Integer; inline;
function ResultFacility(Res: HResult): Integer; inline;
function ResultSeverity(Res: HResult): Integer; inline;
function MakeResult(Severity, Facility, Code: Integer): HResult; inline;

{ GUID functions }

function IsEqualGUID([in, MarshalAs(UnmanagedType.LPStruct)] guid1, guid2: TGUID): Boolean;
function IsEqualIID([in, MarshalAs(UnmanagedType.LPStruct)] iid1, iid2: TIID): Boolean;
function IsEqualCLSID([in, MarshalAs(UnmanagedType.LPStruct)] clsid1, clsid2: TCLSID): Boolean;

{ Standard object API functions }

function CoBuildVersion: Longint;

{ Init/Uninit }

const
  // flags passed as the coInit parameter to CoInitializeEx.
  COINIT_MULTITHREADED      = 0;      // OLE calls objects on any thread.
  COINIT_APARTMENTTHREADED  = 2;      // Apartment model
  COINIT_DISABLE_OLE1DDE    = 4;      // Dont use DDE for Ole1 support.
  COINIT_SPEED_OVER_MEMORY  = 8;      // Trade memory for speed.

function CoInitialize(pvReserved: IntPtr): HResult;
procedure CoUninitialize;
function CoGetMalloc(dwMemContext: Longint; out malloc: IMalloc): HResult;
function CoGetCurrentProcess: Longint;
function CoRegisterMallocSpy([in, MarshalAs(UnmanagedType.Interface)] mallocSpy: IMallocSpy): HResult;
function CoRevokeMallocSpy: HResult;
function CoCreateStandardMalloc(memctx: Longint; out malloc: IMalloc): HResult;
function CoInitializeEx(pvReserved: IntPtr; coInit: Longint): HResult;

{ Register, revoke, and get class objects }

function CoGetClassObject([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  dwClsContext: Longint; pvReserved: IntPtr;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
function CoRegisterClassObject([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  dwClsContext: Longint; flags: Longint; out dwRegister: Longint): HResult;
function CoRevokeClassObject(dwRegister: Longint): HResult;
function CoResumeClassObjects: HResult;
function CoSuspendClassObjects: HResult;
function CoAddRefServerProcess: Longint;
function CoReleaseServerProcess: Longint;
function CoGetPSClsid([in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  var pClsid: TCLSID): HResult;
function CoRegisterPSClsid([in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  clsid: TCLSID): HResult;

{ Marshaling interface pointers }

function CoGetMarshalSizeMax(out ulSize: Longint;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject; dwDestContext: Longint;
  pvDestContext: IntPtr; mshlflags: Longint): HResult;
function CoMarshalInterface([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  dwDestContext: Longint; pvDestContext: IntPtr;
  mshlflags: Longint): HResult;
function CoUnmarshalInterface([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
function CoMarshalHResult([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  result: HResult): HResult;
function CoUnmarshalHResult([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  out result: HResult): HResult;
function CoReleaseMarshalData([in, MarshalAs(UnmanagedType.Interface)] stm: IStream): HResult;
function CoDisconnectObject([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  dwReserved: Longint): HResult;
function CoLockObjectExternal([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  fLock: BOOL; fLastUnlockReleases: BOOL): HResult;
function CoGetStandardMarshal([in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  dwDestContext: Longint; pvDestContext: IntPtr; mshlflags: Longint;
  out marshal: IMarshal): HResult;

function CoIsHandlerConnected(
  [in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject): BOOL;
function CoHasStrongExternalConnections(
  [in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject): BOOL;

{ Apartment model inter-thread interface passing helpers }

function CoMarshalInterThreadInterfaceInStream(
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  out stm: IStream): HResult;
function CoGetInterfaceAndReleaseStream(
  [in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
function CoCreateFreeThreadedMarshaler(
  [in, MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  [MarshalAs(UnmanagedType.IUnknown)] out unkMarshal): HResult;

{ DLL loading helpers; keeps track of ref counts and unloads all on exit }

function CoLoadLibrary([MarshalAs(UnmanagedType.LPWStr)] pszLibName: string;
  bAutoFree: BOOL): THandle;
procedure CoFreeLibrary(hInst: THandle);
procedure CoFreeAllLibraries;
procedure CoFreeUnusedLibraries;

{ Call Security. }

function CoInitializeSecurity(pSecDesc: IntPtr; cAuthSvc: Longint;
  [in] asAuthSvc: array of TSOleAuthenticationService; pReserved1: IntPtr;
  dwAuthnLevel, dImpLevel: Longint; pReserved2: IntPtr; dwCapabilities: Longint;
  pReserved3: IntPtr): HResult;
function CoGetCallContext([in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  pInterface: IntPtr): HResult;
function CoQueryProxyBlanket([in, MarshalAs(UnmanagedType.IUnknown)] Proxy: TObject;
  pwAuthnSvc, pAuthzSvc: IntPtr; pServerPrincName: IntPtr;
  pAuthnLevel, pImpLevel: IntPtr; pAuthInfo: IntPtr; pCapabilites: IntPtr): HResult;
function CoSetProxyBlanket([in, MarshalAs(UnmanagedType.IUnknown)] Proxy: TObject;
  dwAuthnSvc, dwAuthzSvc: Longint; pServerPrincName: IntPtr; dwAuthnLevel, dwImpLevel: Longint;
  pAuthInfo: IntPtr; dwCapabilites: Longint): HResult;
function CoCopyProxy([in, MarshalAs(UnmanagedType.IUnknown)] Proxy: TObject;
  [MarshalAs(UnmanagedType.IUnknown)] out pCopy): HResult;
function CoQueryClientBlanket(pwAuthnSvc, pAuthzSvc: IntPtr;
  pServerPrincName: IntPtr; var dwAuthnLevel, dwImpLevel: Longint;
  pPrivs: IntPtr; var dwCapabilites: Longint): HResult;
function CoImpersonateClient: HResult;
function CoRevertToSelf: HResult;
function CoQueryAuthenticationServices(out pcAuthSvc: Longint;
  [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
  asAuthSvc: array of TSOleAuthenticationService): HResult;
function CoSwitchCallContext([MarshalAs(UnmanagedType.IUnknown)] NewObject: TObject;
  [MarshalAs(UnmanagedType.IUnknown)] out pOldObject: TObject): HResult;

{ Helper for creating instances }

function CoCreateInstance([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  dwClsContext: Longint; [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
function CoGetInstanceFromFile(ServerInfo: IntPtr;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
  dwClsCtx, grfMode: Longint; [MarshalAs(UnmanagedType.LPWStr)] pwszName: string;
  dwCount: Longint; [in] rgmqResults: TMultiQIArray): HResult;
function CoGetInstanceFromIStorage(ServerInfo: IntPtr;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.IUnknown)] punkOuter: TObject;
  dwClsCtx: Longint; [in, MarshalAs(UnmanagedType.IUnknown)] stg: TObject;
  dwCount: Longint; [in] rgmqResults: TMultiQIArray): HResult;
function CoCreateInstanceEx([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  dwClsCtx: Longint; [in] var ServerInfo: TCoServerInfo;
  dwCount: Longint; [in, out] rgmqResults: TMultiQIArray): HResult;

{ Other helpers }

function StringFromCLSID([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.LPWStr)] out psz: string): HResult;
function CLSIDFromString([MarshalAs(UnmanagedType.LPWStr)] psz: string;
  out clsid: TCLSID): HResult;
function StringFromIID([in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.LPWStr)] out psz: string): HResult;
function IIDFromString([MarshalAs(UnmanagedType.LPWStr)] psz: string;
  out iid: TIID): HResult;
function CoIsOle1Class([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID): BOOL;
function ProgIDFromCLSID([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  out pszProgID: IntPtr): HResult;
function CLSIDFromProgID(pszProgID: IntPtr; out clsid: TCLSID): HResult;
function StringFromGUID2([in, MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
  [MarshalAs(UnmanagedType.LPWStr)] psz: string; cbMax: Integer): Integer;

function CoCreateGuid(out guid: TGUID): HResult; 

function CoFileTimeToDosDateTime(const filetime: TFileTime; out dosDate: Word;
  out dosTime: Word): BOOL;
function CoDosDateTimeToFileTime(nDosDate: Word; nDosTime: Word;
  out filetime: TFileTime): BOOL;
function CoFileTimeNow(out filetime: TFileTime): HResult;
function CoRegisterMessageFilter(messageFilter: IMessageFilter;
  out pMessageFilter: IMessageFilter): HResult;
function CoRegisterChannelHook([in, MarshalAs(UnmanagedType.LPStruct)] ExtensionUuid: TGUID;
  [in, MarshalAs(UnmanagedType.Interface)] ChannelHook: IChannelHook): HResult;

{ TreatAs APIs }

function CoGetTreatAsClass([in, MarshalAs(UnmanagedType.LPStruct)] clsidOld: TCLSID;
  out clsidNew: TCLSID): HResult;
function CoTreatAsClass([in, MarshalAs(UnmanagedType.LPStruct)] clsidOld: TCLSID;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsidNew: TCLSID): HResult;

{ The server DLLs must define their DllGetClassObject and DllCanUnloadNow
  to match these; the typedefs are located here to ensure all are changed at
  the same time }

type
  TDLLGetClassObject = function([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
    [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
    [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
  TDLLCanUnloadNow = function: HResult;

{ Default memory allocation }

function CoTaskMemAlloc(cb: Longint): IntPtr; 
function CoTaskMemRealloc(pv: IntPtr; cb: Longint): IntPtr; 
procedure CoTaskMemFree(pv: IntPtr);

{ DV APIs }

function CreateDataAdviseHolder(out DAHolder: IDataAdviseHolder): HResult;
function CreateDataCache([in, MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pv): HResult;

{ Storage API prototypes }

function StgCreateDocfile([MarshalAs(UnmanagedType.LPWStr)] pwcsName: string;
  grfMode: Longint; reserved: Longint; out stgOpen: IStorage): HResult;
function StgCreateDocfileOnILockBytes([in, MarshalAs(UnmanagedType.Interface)] lkbyt: ILockBytes;
  grfMode: Longint; reserved: Longint; out stgOpen: IStorage): HResult;
function StgOpenStorage([MarshalAs(UnmanagedType.LPWStr)] pwcsName: string;
  [in, MarshalAs(UnmanagedType.Interface)] stgPriority: IStorage;
  grfMode: Longint; snbExclude: IntPtr; reserved: Longint; out stgOpen: IStorage): HResult;
function StgOpenStorageOnILockBytes([in, MarshalAs(UnmanagedType.Interface)] lkbyt: ILockBytes;
  [in, MarshalAs(UnmanagedType.Interface)] stgPriority: IStorage;
  grfMode: Longint; snbExclude: IntPtr; reserved: Longint; out stgOpen: IStorage): HResult;
function StgIsStorageFile([MarshalAs(UnmanagedType.LPWStr)] pwcsName: string): HResult;
function StgIsStorageILockBytes([in, MarshalAs(UnmanagedType.Interface)] lkbyt: ILockBytes): HResult;
function StgSetTimes([MarshalAs(UnmanagedType.LPWStr)] pszName: string;
  const ctime: TFileTime; const atime: TFileTime; const mtime: TFileTime): HResult;
function StgOpenAsyncDocfileOnIFillLockBytes([in, MarshalAs(UnmanagedType.Interface)] flb: IFillLockBytes;
  grfMode, asyncFlags: Longint; out stgOpen: IStorage): HResult;
function StgGetIFillLockBytesOnILockBytes([in, MarshalAs(UnmanagedType.Interface)]
  ilb: ILockBytes; out flb: IFillLockBytes): HResult;
function StgGetIFillLockBytesOnFile([MarshalAs(UnmanagedType.LPWStr)] pwcsName: string;
  out flb: IFillLockBytes): HResult;
function StgOpenLayoutDocfile([MarshalAs(UnmanagedType.LPWStr)] pwcsDfName: string;
  grfMode, reserved: Longint; out stgOpen: IStorage): HResult;


{ Moniker APIs }

function BindMoniker([in, MarshalAs(UnmanagedType.Interface)] mk: IMoniker;
  grfOpt: Longint; [in, MarshalAs(UnmanagedType.LPStruct)] iidResult: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pvResult): HResult;
function CoGetObject([MarshalAs(UnmanagedType.LPWStr)] pszName: string;
  pBindOptions: IntPtr; [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out ppv): HResult;
function MkParseDisplayName([in, MarshalAs(UnmanagedType.Interface)] bc: IBindCtx;
  [MarshalAs(UnmanagedType.LPWStr)] szUserName: string;
  out chEaten: Longint; out mk: IMoniker): HResult;
function MonikerRelativePathTo([in, MarshalAs(UnmanagedType.Interface)] mkSrc: IMoniker;
  [in, MarshalAs(UnmanagedType.Interface)] mkDest: IMoniker;
  out mkRelPath: IMoniker; dwReserved: BOOL): HResult;
function MonikerCommonPrefixWith([in, MarshalAs(UnmanagedType.Interface)] mkThis: IMoniker;
  [in, MarshalAs(UnmanagedType.Interface)] mkOther: IMoniker;
  out mkCommon: IMoniker): HResult;
function CreateBindCtx(reserved: Longint; out bc: IBindCtx): HResult;
function CreateGenericComposite([in, MarshalAs(UnmanagedType.Interface)] mkFirst: IMoniker;
  [in, MarshalAs(UnmanagedType.Interface)] mkRest: IMoniker;
  out mkComposite: IMoniker): HResult;
function GetClassFile([MarshalAs(UnmanagedType.LPWStr)] szFilename: string;
  out clsid: TCLSID): HResult;
function CreateFileMoniker([MarshalAs(UnmanagedType.LPWStr)] pszPathName: string;
  out mk: IMoniker): HResult;
function CreateItemMoniker([MarshalAs(UnmanagedType.LPWStr)] pszDelim: string;
  [MarshalAs(UnmanagedType.LPWStr)] pszItem: string;
  out mk: IMoniker): HResult;
function CreateAntiMoniker(out mk: IMoniker): HResult;
function CreatePointerMoniker([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  out mk: IMoniker): HResult;
function GetRunningObjectTable(reserved: Longint;
  out rot: IRunningObjectTable): HResult;

{ from OLEAUTO.H }
{ TBStr API }

function SysAllocString(psz: IntPtr): IntPtr;
function SysReAllocString(var bstr: IntPtr; psz: IntPtr): Integer;
function SysAllocStringLen(psz: IntPtr; len: Integer): IntPtr;
function SysReAllocStringLen(var bstr: IntPtr; psz: IntPtr;
  len: Integer): Integer;
procedure SysFreeString(bstr: IntPtr);
function SysStringLen(bstr: IntPtr): Integer;
function SysStringByteLen(bstr: IntPtr): Integer;
function SysAllocStringByteLen(psz: IntPtr; len: Integer): IntPtr;

{ Time API }

function DosDateTimeToVariantTime(wDosDate, wDosTime: Word;
  out vtime: TOleDate): Integer;
function VariantTimeToDosDateTime(vtime: TOleDate; out wDosDate,
  wDosTime: Word): Integer;
function SystemTimeToVariantTime(var SystemTime: TSystemTime;
  out vtime: TOleDate): Integer;
function VariantTimeToSystemTime(vtime: TOleDate;
  out SystemTime: TSystemTime): Integer;

{ SafeArray API }

function SafeArrayAllocDescriptor(cDims: Integer; out psaOut: PSafeArray): HResult;
function SafeArrayAllocData(psa: PSafeArray): HResult;
function SafeArrayCreate(vt: TVarType; cDims: Integer; [in] rgsabound: array of Integer): PSafeArray;
function SafeArrayCreateVector(vt: TVarType; Lbound, cElements: Longint): PSafeArray;
function SafeArrayCopyData(psaSource, psaTarget: PSafeArray): HResult;
function SafeArrayDestroyDescriptor(psa: PSafeArray): HResult;
function SafeArrayDestroyData(psa: PSafeArray): HResult;
function SafeArrayDestroy(psa: PSafeArray): HResult;
function SafeArrayRedim(psa: PSafeArray; const saboundNew: TSafeArrayBound): HResult;
function SafeArrayGetDim(psa: PSafeArray): Integer;
function SafeArrayGetElemsize(psa: PSafeArray): Integer;
function SafeArrayGetUBound(psa: PSafeArray; nDim: Integer; out lUbound: Longint): HResult;
function SafeArrayGetLBound(psa: PSafeArray; nDim: Integer; out lLbound: Longint): HResult;
function SafeArrayLock(psa: PSafeArray): HResult;
function SafeArrayUnlock(psa: PSafeArray): HResult;
function SafeArrayAccessData(psa: PSafeArray; out pvData: IntPtr): HResult;
function SafeArrayUnaccessData(psa: PSafeArray): HResult;
function SafeArrayGetElement(psa: PSafeArray; [in] rgIndices: array of Integer;
  pv: IntPtr): HResult;
function SafeArrayPutElement(psa: PSafeArray; [in] rgIndices: array of Integer;
  pv: IntPtr): HResult;
function SafeArrayCopy(psa: PSafeArray; out psaOut: PSafeArray): HResult;
function SafeArrayPtrOfIndex(psa: PSafeArray; [in] rgIndices: array of Integer;
  out pvData: IntPtr): HResult;

{ Variant API }

procedure VariantInit(varg: IntPtr);
function VariantClear(varg: IntPtr): HResult;
function VariantCopy(vargDest: IntPtr; vargSrc: IntPtr): HResult;
function VariantCopyInd(varDest: IntPtr; vargSrc: IntPtr): HResult;
function VariantChangeType(vargDest: IntPtr; vargSrc: IntPtr;
  wFlags: Word; vt: TVarType): HResult;
function VariantChangeTypeEx(vargDest: IntPtr; vargSrc: IntPtr;
  lcid: TLCID; wFlags: Word; vt: TVarType): HResult;

{ Vector <-> Bstr conversion APIs }

function VectorFromBstr([MarshalAs(UnmanagedType.BStr)] bstr: string;
  out psa: PSafeArray): HResult;
function BstrFromVector(psa: PSafeArray;
  [MarshalAs(UnmanagedType.BStr)] out bstr: string): HResult;

{ VarType coercion API }

{ Note: The routines that convert from a string are defined
  to take a POleStr rather than a TBStr because no allocation is
  required, and this makes the routines a bit more generic.
  They may of course still be passed a TBStr as the strIn param. }

{ Any of the coersion functions that converts either from or to a string
  takes an additional lcid and dwFlags arguments. The lcid argument allows
  locale specific parsing to occur.  The dwFlags allow additional function
  specific condition to occur.  All function that accept the dwFlags argument
  can include either 0 or LOCALE_NOUSEROVERRIDE flag. In addition, the
  VarDateFromStr functions also accepts the VAR_TIMEVALUEONLY and
  VAR_DATEVALUEONLY flags }

function VarUI1FromI2(sIn: Smallint; out bOut: Byte): HResult; 
function VarUI1FromI4(lIn: Longint; out bOut: Byte): HResult; 
function VarUI1FromR4(fltIn: Single; out bOut: Byte): HResult; 
function VarUI1FromR8(dblIn: Double; out bOut: Byte): HResult; 
function VarUI1FromCy(cyIn: TOACurrency; out bOut: Byte): HResult;
function VarUI1FromDate(dateIn: TOleDate; out bOut: Byte): HResult;
function VarUI1FromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out bOut: Byte): HResult;
function VarUI1FromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out bOut: Byte): HResult;
function VarUI1FromBool(boolIn: TOleBool; out bOut: Byte): HResult;
function VarUI1FromI1(cIn: AnsiChar; out bOut: Byte): HResult;
function VarUI1FromUI2(uiIn: Word; out bOut: Byte): HResult;
function VarUI1FromUI4(ulIn: Longint; out bOut: Byte): HResult;
function VarUI1FromDec(const pdecIn: TDecimal; out bOut: Byte): HResult;

function VarI2FromUI1(bIn: Byte; out sOut: Smallint): HResult;
function VarI2FromI4(lIn: Longint; out sOut: Smallint): HResult;
function VarI2FromR4(fltIn: Single; out sOut: Smallint): HResult;
function VarI2FromR8(dblIn: Double; out sOut: Smallint): HResult;
function VarI2FromCy(cyIn: TOACurrency; out sOut: Smallint): HResult;
function VarI2FromDate(dateIn: TOleDate; out sOut: Smallint): HResult;
function VarI2FromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out sOut: Smallint): HResult;
function VarI2FromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out sOut: Smallint): HResult;
function VarI2FromBool(boolIn: TOleBool; out sOut: Smallint): HResult;
function VarI2FromI1(cIn: AnsiChar; out bOut: Smallint): HResult;
function VarI2FromUI2(uiIn: Word; out bOut: Smallint): HResult;
function VarI2FromUI4(ulIn: Longint; out bOut: Smallint): HResult;
function VarI2FromDec(const pdecIn: TDecimal; out bOut: Smallint): HResult;

function VarI4FromUI1(bIn: Byte; out lOut: Longint): HResult; 
function VarI4FromI2(sIn: Smallint; out lOut: Longint): HResult; 
function VarI4FromR4(fltIn: Single; out lOut: Longint): HResult; 
function VarI4FromR8(dblIn: Double; out lOut: Longint): HResult; 
function VarI4FromCy(cyIn: TOACurrency; out lOut: Longint): HResult; 
function VarI4FromDate(dateIn: TOleDate; out lOut: Longint): HResult; 
function VarI4FromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out lOut: Longint): HResult;
function VarI4FromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out lOut: Longint): HResult;
function VarI4FromBool(boolIn: TOleBool; out lOut: Longint): HResult;
function VarI4FromI1(cIn: AnsiChar; out bOut: Longint): HResult;
function VarI4FromUI2(uiIn: Word; out bOut: Longint): HResult;
function VarI4FromUI4(ulIn: Longint; out bOut: Longint): HResult;
function VarI4FromDec(const pdecIn: TDecimal; out bOut: Longint): HResult;
function VarI4FromInt(intIn: Integer; out bOut: Longint): HResult;

function VarR4FromUI1(bIn: Byte; out fltOut: Single): HResult;
function VarR4FromI2(sIn: Smallint; out fltOut: Single): HResult;
function VarR4FromI4(lIn: Longint; out fltOut: Single): HResult;
function VarR4FromR8(dblIn: Double; out fltOut: Single): HResult;
function VarR4FromCy(cyIn: TOACurrency; out fltOut: Single): HResult;
function VarR4FromDate(dateIn: TOleDate; out fltOut: Single): HResult;
function VarR4FromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out fltOut: Single): HResult;
function VarR4FromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out fltOut: Single): HResult;
function VarR4FromBool(boolIn: TOleBool; out fltOut: Single): HResult; 
function VarR4FromI1(cIn: AnsiChar; out bOut: Single): HResult; 
function VarR4FromUI2(uiIn: Word; out bOut: Single): HResult;
function VarR4FromUI4(ulIn: Longint; out bOut: Single): HResult; 
function VarR4FromDec(const pdecIn: TDecimal; out bOut: Single): HResult;

function VarR8FromUI1(bIn: Byte; out dblOut: Double): HResult; 
function VarR8FromI2(sIn: Smallint; out dblOut: Double): HResult; 
function VarR8FromI4(lIn: Longint; out dblOut: Double): HResult; 
function VarR8FromR4(fltIn: Single; out dblOut: Double): HResult; 
function VarR8FromCy(cyIn: TOACurrency; out dblOut: Double): HResult; 
function VarR8FromDate(dateIn: TOleDate; out dblOut: Double): HResult; 
function VarR8FromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out dblOut: Double): HResult;
function VarR8FromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out dblOut: Double): HResult;
function VarR8FromBool(boolIn: TOleBool; out dblOut: Double): HResult; 
function VarR8FromI1(cIn: AnsiChar; out bOut: Double): HResult; 
function VarR8FromUI2(uiIn: Word; out bOut: Double): HResult; 
function VarR8FromUI4(ulIn: Longint; out bOut: Double): HResult; 
function VarR8FromDec(const pdecIn: TDecimal; out bOut: Double): HResult;

function VarDateFromUI1(bIn: Byte; out dateOut: TOleDate): HResult; 
function VarDateFromI2(sIn: Smallint; out dateOut: TOleDate): HResult; 
function VarDateFromI4(lIn: Longint; out dateOut: TOleDate): HResult; 
function VarDateFromR4(fltIn: Single; out dateOut: TOleDate): HResult; 
function VarDateFromR8(dblIn: Double; out dateOut: TOleDate): HResult; 
function VarDateFromCy(cyIn: TOACurrency; out dateOut: TOleDate): HResult; 
function VarDateFromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out dateOut: TOleDate): HResult;
function VarDateFromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out dateOut: TOleDate): HResult;
function VarDateFromBool(boolIn: TOleBool; out dateOut: TOleDate): HResult;
function VarDateFromI1(cIn: AnsiChar; out bOut: TOleDate): HResult; 
function VarDateFromUI2(uiIn: Word; out bOut: TOleDate): HResult; 
function VarDateFromUI4(ulIn: Longint; out bOut: TOleDate): HResult; 
function VarDateFromDec(const pdecIn: TDecimal; out bOut: TOleDate): HResult;

function VarCyFromUI1(bIn: Byte; out cyOut: TOACurrency): HResult; 
function VarCyFromI2(sIn: Smallint; out cyOut: TOACurrency): HResult; 
function VarCyFromI4(lIn: Longint; out cyOut: TOACurrency): HResult; 
function VarCyFromR4(fltIn: Single; out cyOut: TOACurrency): HResult; 
function VarCyFromR8(dblIn: Double; out cyOut: TOACurrency): HResult; 
function VarCyFromDate(dateIn: TOleDate; out cyOut: TOACurrency): HResult; 
function VarCyFromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out cyOut: TOACurrency): HResult;
function VarCyFromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out cyOut: TOACurrency): HResult;
function VarCyFromBool(boolIn: TOleBool; out cyOut: TOACurrency): HResult; 
function VarCyFromI1(cIn: AnsiChar; out bOut: TOACurrency): HResult; 
function VarCyFromUI2(uiIn: Word; out bOut: TOACurrency): HResult; 
function VarCyFromUI4(ulIn: Longint; out bOut: TOACurrency): HResult; 
function VarCyFromDec(const pdecIn: TDecimal; out bOut: TOACurrency): HResult;

function VarBStrFromUI1(bVal: Byte; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromI2(iVal: Smallint; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromI4(lIn: Longint; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromR4(fltIn: Single; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromR8(dblIn: Double; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromCy(cyIn: TOACurrency; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromDate(dateIn: TOleDate; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; dwFlags: Longint; [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromBool(boolIn: TOleBool; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromI1(cIn: AnsiChar; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromUI2(uiIn: Word; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromUI4(ulIn: Longint; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;
function VarBStrFromDec(const pdecIn: TDecimal; lcid: TLCID; dwFlags: Longint;
  [MarshalAs(UnmanagedType.BStr)] out bstrOut: string): HResult;

function VarBoolFromUI1(bIn: Byte; out boolOut: TOleBool): HResult; 
function VarBoolFromI2(sIn: Smallint; out boolOut: TOleBool): HResult; 
function VarBoolFromI4(lIn: Longint; out boolOut: TOleBool): HResult; 
function VarBoolFromR4(fltIn: Single; out boolOut: TOleBool): HResult; 
function VarBoolFromR8(dblIn: Double; out boolOut: TOleBool): HResult; 
function VarBoolFromDate(dateIn: TOleDate; out boolOut: TOleBool): HResult; 
function VarBoolFromCy(cyIn: TOACurrency; out boolOut: TOleBool): HResult;
function VarBoolFromStr([MarshalAs(UnmanagedType.BStr)] strIn: string;
  lcid: TLCID; dwFlags: Longint; out boolOut: TOleBool): HResult;
function VarBoolFromDisp([in, MarshalAs(UnmanagedType.IDispatch)] dispIn: TObject;
  lcid: TLCID; out boolOut: TOleBool): HResult;
function VarBoolFromI1(cIn: AnsiChar; out boolOut: TOleBool): HResult; 
function VarBoolFromUI2(uiIn: Word; out boolOut: TOleBool): HResult; 
function VarBoolFromUI4(ulIn: Longint; out boolOut: TOleBool): HResult; 
function VarBoolFromDec(const pdecIn: TDecimal; out boolOut: TOleBool): HResult;

{ TypeInfo API }

function LHashValOfNameSys(syskind: TSysKind; lcid: TLCID;
  [MarshalAs(UnmanagedType.LPWStr)] szName: string): Longint;
function LHashValOfNameSysA(syskind: TSysKind; lcid: TLCID;
  szName: string): Longint;

function LHashValOfName(lcid: TLCID; szName: string): Longint;
function WHashValOfLHashVal(lhashval: Longint): Word; inline;
function IsHashValCompatible(lhashval1, lhashval2: Longint): Boolean; inline;

function LoadTypeLib([MarshalAs(UnmanagedType.LPWStr)] szFile: string;
  out tlib: ITypeLib): HResult;
function LoadTypeLibEx([MarshalAs(UnmanagedType.LPWStr)] szFile: string;
  regkind: TRegKind; out tlib: ITypeLib): HResult;
function LoadRegTypeLib([in, MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
  wVerMajor, wVerMinor: Word; lcid: TLCID; out tlib: ITypeLib): HResult;
function QueryPathOfRegTypeLib([in, MarshalAs(UnmanagedType.LPStruct)] guid: TGUID;
  wMaj, wMin: Word; lcid: TLCID;
  [MarshalAs(UnmanagedType.BStr)] out bstrPathName: string): HResult;
function RegisterTypeLib([in, MarshalAs(UnmanagedType.Interface)] tlib: ITypeLib;
  [MarshalAs(UnmanagedType.LPWStr)] szFullPath, szHelpDir: string): HResult;
function UnRegisterTypeLib([in, MarshalAs(UnmanagedType.LPStruct)] libID: TGUID;
  wVerMajor, wVerMinor: Word; lcid: TLCID; syskind: TSysKind): HResult;
function CreateTypeLib(syskind: TSysKind;
  [MarshalAs(UnmanagedType.LPWStr)] szFile: string;
  out ctlib: ICreateTypeLib): HResult;
function CreateTypeLib2(syskind: TSysKind;
  [MarshalAs(UnmanagedType.LPWStr)] szFile: string;
  out ctlib: ICreateTypeLib2): HResult;

{ IDispatch implementation support }

function DispGetParam(const dispparams: TDispParams; position: Integer;
  vtTarg: TVarType; varResult: IntPtr; var puArgErr: Integer): HResult;
function DispGetIDsOfNames(tinfo: ITypeInfo;
  [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr)]
  rgszNames: array of string;
  cNames: Integer;
  [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex=2)]
  rgdispid: array of TDispID): HResult;
function DispInvoke(This: IntPtr; tinfo: ITypeInfo; dispidMember: TDispID;
  wFlags: Word; var params: TDispParams; varResult: IntPtr;
  var excepinfo: TExcepInfo; puArgErr: IntPtr): HResult;
function CreateDispTypeInfo(var idata: TInterfaceData; lcid: TLCID;
  out tinfo: ITypeInfo): HResult;
function CreateStdDispatch([in, MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  pvThis: IntPtr; tinfo: ITypeInfo;
  [MarshalAs(UnmanagedType.IUnknown)] out unkStdDisp): HResult;
function DispCallFunc(pvInstance: IntPtr; oVft: Longint; cc: TCallConv;
  vtReturn: TVarType; cActuals: Longint; var rgvt: TVarType; var prgpvarg: IntPtr;
  var vargResult: IntPtr): HResult;

{ Active object registration API }
const
  ACTIVEOBJECT_STRONG = 0;
  ACTIVEOBJECT_WEAK = 1;

function RegisterActiveObject([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  dwFlags: Longint; out dwRegister: Longint): HResult;
function RevokeActiveObject(dwRegister: Longint; pvReserved: IntPtr): HResult;
function GetActiveObject([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  pvReserved: IntPtr; [MarshalAs(UnmanagedType.IUnknown)] out unk): HResult;

{ ErrorInfo API }

function SetErrorInfo(dwReserved: Longint;
  [in, MarshalAs(UnmanagedType.Interface)] errinfo: IErrorInfo): HResult;
function GetErrorInfo(dwReserved: Longint; out errinfo: IErrorInfo): HResult;
function CreateErrorInfo(out errinfo: ICreateErrorInfo): HResult;

{ Misc API }

function OaBuildVersion: Longint;

procedure ClearCustData(var pCustData: TCustData);

{ from OLE2.H }
{ OLE API prototypes }

function OleBuildVersion: HResult;

{ helper functions }

function ReadClassStg([in, MarshalAs(UnmanagedType.Interface)] stg: IStorage;
  out clsid: TCLSID): HResult; 
function WriteClassStg([in, MarshalAs(UnmanagedType.Interface)] stg: IStorage;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TIID): HResult; 
function ReadClassStm([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  out clsid: TCLSID): HResult;
function WriteClassStm([in, MarshalAs(UnmanagedType.Interface)] stm: IStream;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TIID): HResult; 
function WriteFmtUserTypeStg([in, MarshalAs(UnmanagedType.Interface)] stg: IStorage;
  cf: TClipFormat; [MarshalAs(UnmanagedType.LPWStr)] pszUserType: string): HResult;
function ReadFmtUserTypeStg([in, MarshalAs(UnmanagedType.Interface)] stg: IStorage;
  out cf: TClipFormat; pszUserType: IntPtr): HResult;

{ Initialization and termination }

function OleInitialize(pwReserved: IntPtr): HResult;
procedure OleUninitialize;

{ APIs to query whether (Embedded/Linked) object can be created from
  the data object }

function OleQueryLinkFromData(srcDataObject: IDataObject): HResult;
function OleQueryCreateFromData(srcDataObject: IDataObject): HResult;

{ Object creation APIs }

function OleCreate([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID; renderopt: Longint;
  [in] var formatEtc: TFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateEx([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  dwFlags, renderopt, cFormats: Longint; [in] rgAdvf: array of Longint;
  rgFFormatEtc: IntPtr; AdviseSink: IAdviseSink; rgdwConnection: IntPtr;
  clientSite: IOleClientSite; stg: IStorage;
  [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateFromData(srcDataObj: IDataObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  renderopt: Longint; const formatEtc: TFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateFromDataEx(srcDataObj: IDataObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  dwFlags, renderopt, cFormats: Longint; [in] rgAdvf: array of Longint;
  [in] rgFFormatEtc: array of TFormatEtc; AdviseSink: IAdviseSink;
  rgdwConnection: IntPtr; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateLinkFromData(srcDataObj: IDataObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  renderopt: Longint; const formatEtc: TFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateLinkFromDataEx(srcDataObj: IDataObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  dwFlags, renderopt, cFormats: Longint; [in] rgAdvf: array of Longint;
  [in] rgFFormatEtc: array of TFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: IntPtr; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateStaticFromData(srcDataObj: IDataObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  renderopt: Longint; const formatEtc: TFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateLink(mkLinkSrc: IMoniker;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  renderopt: Longint; const formatEtc: TFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateLinkEx(mkLinkSrc: IMoniker;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  dwFlags, renderopt, cFormats: Longint; [in] rgAdvf: array of Longint;
  [in] rgFFormatEtc: array of TFormatEtc; AdviseSink: IAdviseSink;
  rgdwConnection: IntPtr; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateLinkToFile([MarshalAs(UnmanagedType.LPWStr)] pszFileName: string;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  renderopt: Longint; const formatEtc: TFormatEtc; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateLinkToFileEx([MarshalAs(UnmanagedType.LPWStr)] pszFileName: string;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  dwFlags, renderopt, cFormats: Longint; [in] rgAdvf: array of Longint;
  [in] rgFFormatEtc: array of TFormatEtc; AdviseSink: IAdviseSink;
  rgdwConnection: IntPtr; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateFromFile([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.LPWStr)] pszFileName: string;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID; renderopt: Longint;
  const formatEtc: TFormatEtc; clientSite: IOleClientSite; stg: IStorage;
  [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateFromFileEx([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.LPWStr)] pszFileName: string;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  dwFlags, renderopt, cFormats: Longint; [in] rgAdvf: array of Longint;
  [in] rgFFormatEtc: array of TFormatEtc;
  AdviseSink: IAdviseSink; rgdwConnection: IntPtr; clientSite: IOleClientSite;
  stg: IStorage; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleLoad(stg: IStorage; [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  clientSite: IOleClientSite; [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleSave(ps: IPersistStorage; stg: IStorage; fSameAsLoad: BOOL): HResult;
function OleLoadFromStream(stm: IStream;
  [in, MarshalAs(UnmanagedType.LPStruct)] iidInterface: TIID;
  [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleSaveToStream(pstm: IPersistStream; stm: IStream): HResult;
function OleSetContainedObject([in, MarshalAs(UnmanagedType.IUnknown)] unknown: TObject;
  fContained: BOOL): HResult;
function OleNoteObjectVisible([in, MarshalAs(UnmanagedType.IUnknown)] unknown: TObject;
  fVisible: BOOL): HResult;

{ DragDrop APIs }

function RegisterDragDrop(wnd: HWnd; dropTarget: IDropTarget): HResult; 
function RevokeDragDrop(wnd: HWnd): HResult;
function DoDragDrop(dataObj: IDataObject; dropSource: IDropSource;
  dwOKEffects: Longint; var dwEffect: Longint): HResult;

{ Clipboard APIs }

function OleSetClipboard(dataObj: IDataObject): HResult; 
function OleGetClipboard(out dataObj: IDataObject): HResult; 
function OleFlushClipboard: HResult; 
function OleIsCurrentClipboard(dataObj: IDataObject): HResult;

{ In-place editing APIs }

function OleCreateMenuDescriptor(hmenuCombined: HMenu;
  var menuWidths: TOleMenuGroupWidths): HMenu; 
function OleSetMenuDescriptor(holemenu: HMenu; hwndFrame: HWnd;
  hwndActiveObject: HWnd; frame: IOleInPlaceFrame;
  activeObj: IOleInPlaceActiveObject): HResult; 
function OleDestroyMenuDescriptor(holemenu: HMenu): HResult;
function OleTranslateAccelerator(frame: IOleInPlaceFrame;
  var frameInfo: TOleInPlaceFrameInfo; const msg: TMsg): HResult;

{ Helper APIs }

function OleDuplicateData(hSrc: THandle; cfFormat: TClipFormat;
  uiFlags: Integer): THandle;
function OleDraw([in, MarshalAs(UnmanagedType.IUnknown)] unknown: TObject;
  dwAspect: Longint; hdcDraw: HDC; const rcBounds: TRect): HResult;
function OleRun([in, MarshalAs(UnmanagedType.IUnknown)] unknown: TObject): HResult;
function OleIsRunning(obj: IOleObject): BOOL;
function OleLockRunning([in, MarshalAs(UnmanagedType.IUnknown)] unknown: TObject;
  fLock: BOOL; fLastUnlockCloses: BOOL): HResult;
procedure ReleaseStgMedium(var medium: TStgMedium);
function CreateOleAdviseHolder(out OAHolder: IOleAdviseHolder): HResult;
function OleCreateDefaultHandler([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function OleCreateEmbeddingHelper([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [in, MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  flags: Longint; cf: IClassFactory;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out vObj): HResult;
function IsAccelerator(accel: HAccel; cAccelEntries: Integer; const msg: TMsg;
  var pwCmd: Word): BOOL;

{ Icon extraction helper APIs }

function OleGetIconOfFile([MarshalAs(UnmanagedType.LPWStr)] pszPath: string;
  fUseFileAsLabel: BOOL): HGlobal;
function OleGetIconOfClass([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.LPWStr)] pszLabel: string;
  fUseTypeAsLabel: BOOL): HGlobal;
function OleMetafilePictFromIconAndLabel(icon: HIcon;
  [MarshalAs(UnmanagedType.LPWStr)] pszLabel: string;
  [MarshalAs(UnmanagedType.LPWStr)] pszSourceFile: string;
  iIconIndex: Integer): HGlobal;

{ Registration database helper APIs }

function OleRegGetUserType([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  dwFormOfType: Longint; [out] pszUserType: StringBuilder): HResult;
function OleRegGetMiscStatus([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  dwAspect: Longint; out dwStatus: Longint): HResult;
function OleRegEnumFormatEtc([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  dwDirection: Longint; out Enum: IEnumFormatEtc): HResult;
function OleRegEnumVerbs([in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  out Enum: IEnumOleVerb): HResult;

{ OLE 1.0 conversion APIs }

function OleConvertIStorageToOLESTREAM(stg: IStorage;
  polestm: IntPtr): HResult;
function OleConvertOLESTREAMToIStorage(polestm: IntPtr; stg: IStorage;
  const td: TDVTargetDevice): HResult;
function OleConvertIStorageToOLESTREAMEx(stg: IStorage; cfFormat: TClipFormat;
  lWidth: Longint; lHeight: Longint; dwSize: Longint; var medium: TStgMedium;
  polestm: IntPtr): HResult;
function OleConvertOLESTREAMToIStorageEx(polestm: IntPtr; stg: IStorage;
  var cfFormat: TClipFormat; var lWidth: Longint; var lHeight: Longint;
  var dwSize: Longint; var medium: TStgMedium): HResult;

{ Storage utility APIs }

function GetHGlobalFromILockBytes(lkbyt: ILockBytes; out hglob: HGlobal): HResult;
function CreateILockBytesOnHGlobal(hglob: HGlobal; fDeleteOnRelease: BOOL;
  out lkbyt: ILockBytes): HResult;
function GetHGlobalFromStream(stm: IStream; out hglob: HGlobal): HResult;
function CreateStreamOnHGlobal(hglob: HGlobal; fDeleteOnRelease: BOOL;
  out stm: IStream): HResult;

{ ConvertTo APIs }

function OleDoAutoConvert(stg: IStorage; out clsidNew: TCLSID): HResult;
function OleGetAutoConvert([in, MarshalAs(UnmanagedType.LPStruct)] clsidOld: TCLSID;
  out clsidNew: TCLSID): HResult;
function OleSetAutoConvert([in, MarshalAs(UnmanagedType.LPStruct)] clsidOld: TCLSID;
  [in, MarshalAs(UnmanagedType.LPStruct)] clsidNew: TCLSID): HResult;
function GetConvertStg(stg: IStorage): HResult;
function SetConvertStg(stg: IStorage; fConvert: BOOL): HResult;

{ from OLECTL.H }
{ Property frame APIs }

function OleCreatePropertyFrame(hwndOwner: HWnd; x, y: Integer;
  [MarshalAs(UnmanagedType.LPWStr)] lpszCaption: string; cObjects: Integer;
  [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.IUnknown, SizeParamIndex = 4)]
  pObjects: array of TObject; cPages: Integer;
  [in, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 6)]
  pPageCLSIDs: array of TCLSID; lcid: TLCID; dwReserved: Longint;
  pvReserved: IntPtr): HResult;
function OleCreatePropertyFrameIndirect(const Params: TOCPFIParams): HResult;

{ Standard type APIs }

function OleTranslateColor(clr: TOleColor; hpal: HPalette;
 out colorref: TColorRef): HResult;
function OleCreateFontIndirect(const FontDesc: TFontDesc;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out vObject): HResult;
function OleCreatePictureIndirect(const PictDesc: TPictDesc;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  fOwn: BOOL; [MarshalAs(UnmanagedType.Interface)] out vObject): HResult;
function OleLoadPicture(stream: IStream; lSize: Longint; fRunmode: BOOL;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out vObject): HResult;
function OleLoadPicturePath([MarshalAs(UnmanagedType.LPWStr)] szURLorPath: string;
  [in, MarshalAs(UnmanagedType.IUnknown)] unkCaller: TObject;
  dwReserved: Longint; clrReserved: TOleColor;
  [in, MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out ppvRet): HResult;
function OleLoadPictureFile(varFileName: TObject;
  [MarshalAs(UnmanagedType.IDispatch)] out lpdispPicture): HResult;
function OleSavePictureFile([in, MarshalAs(UnmanagedType.IDispatch)] dispPicture: TObject;
  [MarshalAs(UnmanagedType.BStr)] bstrFileName: string): HResult;
function OleIconToCursor(hinstExe: THandle; hIcon: THandle): HCursor;

// Macros for parsing the OS Version of the Property Set Header
function PROPSETHDR_OSVER_KIND(dwOSVer: DWORD): Word; inline;
function PROPSETHDR_OSVER_MAJOR(dwOSVer: DWORD): Byte; inline;
function PROPSETHDR_OSVER_MINOR(dwOSVer: DWORD): Byte; inline;

const
  PROPSETHDR_OSVERSION_UNKNOWN        = $FFFFFFFF;

type
  [ComImport,
  GuidAttribute('00020400-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDispatch = interface
    [PreserveSig]
    function GetTypeInfoCount(out Count: Integer): HResult;
    [PreserveSig]
    function GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult;
    [PreserveSig]
    function GetIDsOfNames([MarshalAs(UnmanagedType.LPStruct)] IID: TGUID;
      [in] var Names: string; NameCount, LocaleID: Integer; out DispIDs: Integer): HResult;
    [PreserveSig]
    function Invoke(DispID: Integer; [MarshalAs(UnmanagedType.LPStruct)] IID: TGUID;
      LocaleID: Integer; Flags: Word; var Params: TDispParams;
      out VarResult; out ExcepInfo: TExcepInfo; ArgErr: IntPtr): HResult;
  end;

implementation

uses
  System.Security;

const
  ole32    = 'ole32.dll';
  oleaut32 = 'oleaut32.dll';
  olepro32 = 'olepro32.dll';

{ Externals from ole32.dll }

[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'IsEqualGUID')]
function IsEqualGUID; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'IsEqualIID')]
function IsEqualIID; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'IsEqualCLSID')]
function IsEqualCLSID; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoBuildVersion')]
function CoBuildVersion; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoInitialize')]
function CoInitialize; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoInitializeEx')]
function CoInitializeEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoUninitialize')]
procedure CoUninitialize; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetMalloc')]
function CoGetMalloc; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetCurrentProcess')]
function CoGetCurrentProcess; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRegisterMallocSpy')]
function CoRegisterMallocSpy; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRevokeMallocSpy')]
function CoRevokeMallocSpy; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoCreateStandardMalloc')]
function CoCreateStandardMalloc; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetClassObject')]
function CoGetClassObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRegisterClassObject')]
function CoRegisterClassObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRevokeClassObject')]
function CoRevokeClassObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoResumeClassObjects')]
function CoResumeClassObjects; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoSuspendClassObjects')]
function CoSuspendClassObjects; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoAddRefServerProcess')]
function CoAddRefServerProcess; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoReleaseServerProcess')]
function CoReleaseServerProcess; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetPSClsid')]
function CoGetPSClsid; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRegisterPSClsid')]
function CoRegisterPSClsid; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetMarshalSizeMax')]
function CoGetMarshalSizeMax; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoMarshalInterface')]
function CoMarshalInterface; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoUnmarshalInterface')]
function CoUnmarshalInterface; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoMarshalHResult')]
function CoMarshalHResult; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoUnmarshalHResult')]
function CoUnmarshalHResult; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoReleaseMarshalData')]
function CoReleaseMarshalData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoDisconnectObject')]
function CoDisconnectObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoLockObjectExternal')]
function CoLockObjectExternal; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetStandardMarshal')]
function CoGetStandardMarshal; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoIsHandlerConnected')]
function CoIsHandlerConnected; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoHasStrongExternalConnections')]
function CoHasStrongExternalConnections; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoMarshalInterThreadInterfaceInStream')]
function CoMarshalInterThreadInterfaceInStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetInterfaceAndReleaseStream')]
function CoGetInterfaceAndReleaseStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoCreateFreeThreadedMarshaler')]
function CoCreateFreeThreadedMarshaler; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoLoadLibrary')]
function CoLoadLibrary; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoFreeLibrary')]
procedure CoFreeLibrary; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoFreeAllLibraries')]
procedure CoFreeAllLibraries; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoFreeUnusedLibraries')]
procedure CoFreeUnusedLibraries; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoInitializeSecurity')]
function CoInitializeSecurity; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetCallContext')]
function CoGetCallContext; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoQueryProxyBlanket')]
function CoQueryProxyBlanket; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoSetProxyBlanket')]
function CoSetProxyBlanket; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoCopyProxy')]
function CoCopyProxy; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoQueryClientBlanket')]
function CoQueryClientBlanket; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoImpersonateClient')]
function CoImpersonateClient; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRevertToSelf')]
function CoRevertToSelf; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoQueryAuthenticationServices')]
function CoQueryAuthenticationServices; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoSwitchCallContext')]
function CoSwitchCallContext; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoCreateInstance')]
function CoCreateInstance; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetInstanceFromFile')]
function CoGetInstanceFromFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetInstanceFromIStorage')]
function CoGetInstanceFromIStorage; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoCreateInstanceEx')]
function CoCreateInstanceEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StringFromCLSID')]
function StringFromCLSID; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CLSIDFromString')]
function CLSIDFromString; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StringFromIID')]
function StringFromIID; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'IIDFromString')]
function IIDFromString; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoIsOle1Class')]
function CoIsOle1Class; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'ProgIDFromCLSID')]
function ProgIDFromCLSID; external;
[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Unicode, EntryPoint = 'CLSIDFromProgID')]
function CLSIDFromProgID; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StringFromGUID2')]
function StringFromGUID2; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoCreateGuid')]
function CoCreateGuid; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoFileTimeToDosDateTime')]
function CoFileTimeToDosDateTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoDosDateTimeToFileTime')]
function CoDosDateTimeToFileTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoFileTimeNow')]
function CoFileTimeNow; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRegisterMessageFilter')]
function CoRegisterMessageFilter; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoRegisterChannelHook')]
function CoRegisterChannelHook; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetTreatAsClass')]
function CoGetTreatAsClass; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoTreatAsClass')]
function CoTreatAsClass; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoTaskMemAlloc')]
function CoTaskMemAlloc; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoTaskMemRealloc')]
function CoTaskMemRealloc; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoTaskMemFree')]
procedure CoTaskMemFree; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateDataAdviseHolder')]
function CreateDataAdviseHolder; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateDataCache')]
function CreateDataCache; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgCreateDocfile')]
function StgCreateDocfile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgCreateDocfileOnILockBytes')]
function StgCreateDocfileOnILockBytes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgOpenStorage')]
function StgOpenStorage; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgOpenStorageOnILockBytes')]
function StgOpenStorageOnILockBytes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgIsStorageFile')]
function StgIsStorageFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgIsStorageILockBytes')]
function StgIsStorageILockBytes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgSetTimes')]
function StgSetTimes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgOpenAsyncDocfileOnIFillLockBytes')]
function StgOpenAsyncDocfileOnIFillLockBytes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgGetIFillLockBytesOnILockBytes')]
function StgGetIFillLockBytesOnILockBytes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgGetIFillLockBytesOnFile')]
function StgGetIFillLockBytesOnFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'StgOpenLayoutDocfile')]
function StgOpenLayoutDocfile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'BindMoniker')]
function BindMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CoGetObject')]
function CoGetObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'MkParseDisplayName')]
function MkParseDisplayName; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'MonikerRelativePathTo')]
function MonikerRelativePathTo; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'MonikerCommonPrefixWith')]
function MonikerCommonPrefixWith; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateBindCtx')]
function CreateBindCtx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateGenericComposite')]
function CreateGenericComposite; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'GetClassFile')]
function GetClassFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateFileMoniker')]
function CreateFileMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateItemMoniker')]
function CreateItemMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateAntiMoniker')]
function CreateAntiMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreatePointerMoniker')]
function CreatePointerMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'GetRunningObjectTable')]
function GetRunningObjectTable; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleBuildVersion')]
function OleBuildVersion; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'ReadClassStg')]
function ReadClassStg; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'WriteClassStg')]
function WriteClassStg; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'ReadClassStm')]
function ReadClassStm; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'WriteClassStm')]
function WriteClassStm; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'WriteFmtUserTypeStg')]
function WriteFmtUserTypeStg; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'ReadFmtUserTypeStg')]
function ReadFmtUserTypeStg; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleInitialize')]
function OleInitialize; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleUninitialize')]
procedure OleUninitialize; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleQueryLinkFromData')]
function OleQueryLinkFromData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleQueryCreateFromData')]
function OleQueryCreateFromData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreate')]
function OleCreate; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateEx')]
function OleCreateEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateFromDataEx')]
function OleCreateFromDataEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateFromData')]
function OleCreateFromData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateLinkFromData')]
function OleCreateLinkFromData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateLinkFromDataEx')]
function OleCreateLinkFromDataEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateStaticFromData')]
function OleCreateStaticFromData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateLink')]
function OleCreateLink; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateLinkEx')]
function OleCreateLinkEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateLinkToFile')]
function OleCreateLinkToFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateLinkToFileEx')]
function OleCreateLinkToFileEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateFromFile')]
function OleCreateFromFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateFromFileEx')]
function OleCreateFromFileEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleLoad')]
function OleLoad; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleSave')]
function OleSave; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleLoadFromStream')]
function OleLoadFromStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleSaveToStream')]
function OleSaveToStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleSetContainedObject')]
function OleSetContainedObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleNoteObjectVisible')]
function OleNoteObjectVisible; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'RegisterDragDrop')]
function RegisterDragDrop; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'RevokeDragDrop')]
function RevokeDragDrop; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'DoDragDrop')]
function DoDragDrop; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleSetClipboard')]
function OleSetClipboard; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleGetClipboard')]
function OleGetClipboard; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleFlushClipboard')]
function OleFlushClipboard; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleIsCurrentClipboard')]
function OleIsCurrentClipboard; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateMenuDescriptor')]
function OleCreateMenuDescriptor; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleSetMenuDescriptor')]
function OleSetMenuDescriptor; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleDestroyMenuDescriptor')]
function OleDestroyMenuDescriptor; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleTranslateAccelerator')]
function OleTranslateAccelerator; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleDuplicateData')]
function OleDuplicateData; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleDraw')]
function OleDraw; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleRun')]
function OleRun; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleIsRunning')]
function OleIsRunning; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleLockRunning')]
function OleLockRunning; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'ReleaseStgMedium')]
procedure ReleaseStgMedium; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateOleAdviseHolder')]
function CreateOleAdviseHolder; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateDefaultHandler')]
function OleCreateDefaultHandler; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateEmbeddingHelper')]
function OleCreateEmbeddingHelper; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'IsAccelerator')]
function IsAccelerator; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleGetIconOfFile')]
function OleGetIconOfFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleGetIconOfClass')]
function OleGetIconOfClass; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleMetafilePictFromIconAndLabel')]
function OleMetafilePictFromIconAndLabel; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleRegGetUserType')]
function OleRegGetUserType; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleRegGetMiscStatus')]
function OleRegGetMiscStatus; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleRegEnumFormatEtc')]
function OleRegEnumFormatEtc; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleRegEnumVerbs')]
function OleRegEnumVerbs; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleConvertIStorageToOLESTREAM')]
function OleConvertIStorageToOLESTREAM; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleConvertOLESTREAMToIStorage')]
function OleConvertOLESTREAMToIStorage; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleConvertIStorageToOLESTREAMEx')]
function OleConvertIStorageToOLESTREAMEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleConvertOLESTREAMToIStorageEx')]
function OleConvertOLESTREAMToIStorageEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'GetHGlobalFromILockBytes')]
function GetHGlobalFromILockBytes; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateILockBytesOnHGlobal')]
function CreateILockBytesOnHGlobal; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'GetHGlobalFromStream')]
function GetHGlobalFromStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'CreateStreamOnHGlobal')]
function CreateStreamOnHGlobal; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleDoAutoConvert')]
function OleDoAutoConvert; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleGetAutoConvert')]
function OleGetAutoConvert; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'OleSetAutoConvert')]
function OleSetAutoConvert; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'GetConvertStg')]
function GetConvertStg; external;
[SuppressUnmanagedCodeSecurity, DllImport(ole32, CharSet = CharSet.Unicode, EntryPoint = 'SetConvertStg')]
function SetConvertStg; external;

{ Externals from oleaut32.dll }

[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysAllocString')]
function SysAllocString; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysReAllocString')]
function SysReAllocString; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysAllocStringLen')]
function SysAllocStringLen; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysReAllocStringLen')]
function SysReAllocStringLen; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysFreeString')]
procedure SysFreeString; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysStringLen')]
function SysStringLen; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysStringByteLen')]
function SysStringByteLen; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SysAllocStringByteLen')]
function SysAllocStringByteLen; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'DosDateTimeToVariantTime')]
function DosDateTimeToVariantTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantTimeToDosDateTime')]
function VariantTimeToDosDateTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SystemTimeToVariantTime')]
function SystemTimeToVariantTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantTimeToSystemTime')]
function VariantTimeToSystemTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayAllocDescriptor')]
function SafeArrayAllocDescriptor; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayAllocData')]
function SafeArrayAllocData; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayCreate')]
function SafeArrayCreate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayCreateVector')]
function SafeArrayCreateVector; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayCopyData')]
function SafeArrayCopyData; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayDestroyDescriptor')]
function SafeArrayDestroyDescriptor; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayDestroyData')]
function SafeArrayDestroyData; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayDestroy')]
function SafeArrayDestroy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayRedim')]
function SafeArrayRedim; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayGetDim')]
function SafeArrayGetDim; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayGetElemsize')]
function SafeArrayGetElemsize; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayGetUBound')]
function SafeArrayGetUBound; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayGetLBound')]
function SafeArrayGetLBound; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayLock')]
function SafeArrayLock; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayUnlock')]
function SafeArrayUnlock; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayAccessData')]
function SafeArrayAccessData; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayUnaccessData')]
function SafeArrayUnaccessData; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayGetElement')]
function SafeArrayGetElement; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayPutElement')]
function SafeArrayPutElement; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayCopy')]
function SafeArrayCopy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SafeArrayPtrOfIndex')]
function SafeArrayPtrOfIndex; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantInit')]
procedure VariantInit; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantClear')]
function VariantClear; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantCopy')]
function VariantCopy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantCopyInd')]
function VariantCopyInd; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantChangeType')]
function VariantChangeType; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VariantChangeTypeEx')]
function VariantChangeTypeEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VectorFromBstr')]
function VectorFromBstr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'BstrFromVector')]
function BstrFromVector; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromI2')]
function VarUI1FromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromI4')]
function VarUI1FromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromR4')]
function VarUI1FromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromR8')]
function VarUI1FromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromCy')]
function VarUI1FromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromDate')]
function VarUI1FromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromStr')]
function VarUI1FromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromDisp')]
function VarUI1FromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromBool')]
function VarUI1FromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromI1')]
function VarUI1FromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromUI2')]
function VarUI1FromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromUI4')]
function VarUI1FromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarUI1FromDec')]
function VarUI1FromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromUI1')]
function VarI2FromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromI4')]
function VarI2FromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromR4')]
function VarI2FromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromR8')]
function VarI2FromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromCy')]
function VarI2FromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromDate')]
function VarI2FromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromStr')]
function VarI2FromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromDisp')]
function VarI2FromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromBool')]
function VarI2FromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromI1')]
function VarI2FromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromUI2')]
function VarI2FromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromUI4')]
function VarI2FromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI2FromDec')]
function VarI2FromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromUI1')]
function VarI4FromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromI2')]
function VarI4FromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromR4')]
function VarI4FromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromR8')]
function VarI4FromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromCy')]
function VarI4FromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromDate')]
function VarI4FromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromStr')]
function VarI4FromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromDisp')]
function VarI4FromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromBool')]
function VarI4FromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromI1')]
function VarI4FromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromUI2')]
function VarI4FromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromUI4')]
function VarI4FromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromDec')]
function VarI4FromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarI4FromInt')]
function VarI4FromInt; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromUI1')]
function VarR4FromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromI2')]
function VarR4FromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromI4')]
function VarR4FromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromR8')]
function VarR4FromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromCy')]
function VarR4FromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromDate')]
function VarR4FromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromStr')]
function VarR4FromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromDisp')]
function VarR4FromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromBool')]
function VarR4FromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromI1')]
function VarR4FromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromUI2')]
function VarR4FromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromUI4')]
function VarR4FromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR4FromDec')]
function VarR4FromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromUI1')]
function VarR8FromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromI2')]
function VarR8FromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromI4')]
function VarR8FromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromR4')]
function VarR8FromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromCy')]
function VarR8FromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromDate')]
function VarR8FromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromStr')]
function VarR8FromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromDisp')]
function VarR8FromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromBool')]
function VarR8FromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromI1')]
function VarR8FromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromUI2')]
function VarR8FromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromUI4')]
function VarR8FromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarR8FromDec')]
function VarR8FromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromUI1')]
function VarDateFromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromI2')]
function VarDateFromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromI4')]
function VarDateFromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromR4')]
function VarDateFromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromR8')]
function VarDateFromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromCy')]
function VarDateFromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromStr')]
function VarDateFromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromDisp')]
function VarDateFromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromBool')]
function VarDateFromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromI1')]
function VarDateFromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromUI2')]
function VarDateFromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromUI4')]
function VarDateFromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarDateFromDec')]
function VarDateFromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromUI1')]
function VarCyFromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromI2')]
function VarCyFromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromI4')]
function VarCyFromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromR4')]
function VarCyFromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromR8')]
function VarCyFromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromDate')]
function VarCyFromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromStr')]
function VarCyFromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromDisp')]
function VarCyFromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromBool')]
function VarCyFromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromI1')]
function VarCyFromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromUI2')]
function VarCyFromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromUI4')]
function VarCyFromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarCyFromDec')]
function VarCyFromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromUI1')]
function VarBStrFromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromI2')]
function VarBStrFromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromI4')]
function VarBStrFromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromR4')]
function VarBStrFromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromR8')]
function VarBStrFromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromCy')]
function VarBStrFromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromDate')]
function VarBStrFromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromDisp')]
function VarBStrFromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBStrFromBool')]
function VarBStrFromBool; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBstrFromI1')]
function VarBstrFromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBstrFromUI2')]
function VarBstrFromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBstrFromUI4')]
function VarBstrFromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBstrFromDec')]
function VarBstrFromDec; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromUI1')]
function VarBoolFromUI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromI2')]
function VarBoolFromI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromI4')]
function VarBoolFromI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromR4')]
function VarBoolFromR4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromR8')]
function VarBoolFromR8; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromDate')]
function VarBoolFromDate; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromCy')]
function VarBoolFromCy; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromStr')]
function VarBoolFromStr; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromDisp')]
function VarBoolFromDisp; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromI1')]
function VarBoolFromI1; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromUI2')]
function VarBoolFromUI2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromUI4')]
function VarBoolFromUI4; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'VarBoolFromDec')]
function VarBoolFromDec; external;

[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'LHashValOfNameSys')]
function LHashValOfNameSys; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Ansi, EntryPoint = 'LHashValOfNameSysA')]
function LHashValOfNameSysA; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'LoadTypeLib')]
function LoadTypeLib; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'LoadTypeLibEx')]
function LoadTypeLibEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'LoadRegTypeLib')]
function LoadRegTypeLib; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'QueryPathOfRegTypeLib')]
function QueryPathOfRegTypeLib; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'RegisterTypeLib')]
function RegisterTypeLib; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'UnRegisterTypeLib')]
function UnRegisterTypeLib; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'CreateTypeLib')]
function CreateTypeLib; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'CreateTypeLib2')]
function CreateTypeLib2; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'DispGetParam')]
function DispGetParam; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'DispGetIDsOfNames')]
function DispGetIDsOfNames; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'DispInvoke')]
function DispInvoke; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'CreateDispTypeInfo')]
function CreateDispTypeInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'CreateStdDispatch')]
function CreateStdDispatch; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'DispCallFunc')]
function DispCallFunc; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'RegisterActiveObject')]
function RegisterActiveObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'RevokeActiveObject')]
function RevokeActiveObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'GetActiveObject')]
function GetActiveObject; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'SetErrorInfo')]
function SetErrorInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'GetErrorInfo')]
function GetErrorInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'CreateErrorInfo')]
function CreateErrorInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'OaBuildVersion')]
function OaBuildVersion; external;
[SuppressUnmanagedCodeSecurity, DllImport(oleaut32, CharSet = CharSet.Unicode, EntryPoint = 'ClearCustData')]
procedure ClearCustData; external;

{ Externals from olepro32.dll }

[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreatePropertyFrame')]
function OleCreatePropertyFrame; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreatePropertyFrameIndirect')]
function OleCreatePropertyFrameIndirect; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleTranslateColor')]
function OleTranslateColor; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreateFontIndirect')]
function OleCreateFontIndirect; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleCreatePictureIndirect')]
function OleCreatePictureIndirect; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleLoadPicture')]
function OleLoadPicture; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleLoadPicturePath')]
function OleLoadPicturePath; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleLoadPictureFile')]
function OleLoadPictureFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleSavePictureFile')]
function OleSavePictureFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(olepro32, CharSet = CharSet.Unicode, EntryPoint = 'OleIconToCursor')]
function OleIconToCursor; external;

{ Helper functions }

function Succeeded(Res: HResult): Boolean;
begin
  Result := Res and $80000000 = 0;
end;

function Failed(Res: HResult): Boolean;
begin
  Result := Res and $80000000 <> 0;
end;

function ResultCode(Res: HResult): Integer;
begin
  Result := Res and $0000FFFF;
end;

function ResultFacility(Res: HResult): Integer;
begin
  Result := (Res shr 16) and $00001FFF;
end;

function ResultSeverity(Res: HResult): Integer;
begin
  Result := Res shr 31;
end;

function MakeResult(Severity, Facility, Code: Integer): HResult;
begin
  Result := (Severity shl 31) or (Facility shl 16) or Code;
end;

function LHashValOfName(lcid: TLCID; szName: string): Longint;
begin
  Result := LHashValOfNameSys(SYS_WIN32, lcid, szName);
end;

function WHashValOfLHashVal(lhashval: Longint): Word;
begin
  Result := lhashval and $0000FFFF;
end;

function IsHashValCompatible(lhashval1, lhashval2: Longint): Boolean;
begin
  Result := lhashval1 and $00FF0000 = lhashval2 and $00FF0000;
end;

function PROPSETHDR_OSVER_KIND(dwOSVer: DWORD): Word;
begin
  Result := HiWord(dwOSVer);
end;

function PROPSETHDR_OSVER_MAJOR(dwOSVer: DWORD): Byte;
begin
  Result := LoByte(dwOSVer);
end;

function PROPSETHDR_OSVER_MINOR(dwOSVer: DWORD): Byte;
begin
  Result := HiByte(LoWord(dwOSVer));
end;

end.